/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import java.io.IOException;
import java.io.OutputStream;

public abstract class WireProtocolMessage {
    public static final int TAILABLE_CURSOR = 2;
    public static final int SLAVE_OK = 4;
    public static final int NO_CURSOR_TIMEOUT = 16;
    public static final int AWAIT_DATA = 32;
    public static final int PARTIAL = 128;
    protected int flags;

    public static int readInt(byte[] bytes, int idx) {
        return bytes[idx] & 0xFF | (bytes[idx + 1] & 0xFF) << 8 | (bytes[idx + 2] & 0xFF) << 16 | (bytes[idx + 3] & 0xFF) << 24;
    }

    public static long readLong(byte[] bytes, int idx) {
        return (long)(bytes[idx] & 0xFF) | (long)(bytes[idx + 1] & 0xFF) << 8 | (long)(bytes[idx + 2] & 0xFF) << 16 | (long)(bytes[idx + 3] & 0xFF) << 24 | (long)(bytes[idx + 4] & 0xFF) << 32 | (long)(bytes[idx + 5] & 0xFF) << 40 | (long)(bytes[idx + 6] & 0xFF) << 48 | (long)(bytes[idx + 7] & 0xFF) << 56;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setTailableCursor(boolean t) {
        this.flags = t ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isPartial() {
        return (this.flags & 0x80) != 0;
    }

    public void setPartial(boolean t) {
        this.flags = t ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    public boolean isAwaitData() {
        return (this.flags & 0x20) != 0;
    }

    public void setAwaitData(boolean t) {
        this.flags = t ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public boolean isTailable() {
        return (this.flags & 2) != 0;
    }

    public boolean isSlaveOk() {
        return (this.flags & 4) != 0;
    }

    public void setSlaveOk(boolean t) {
        this.flags = t ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isNoCursorTimeout() {
        return (this.flags & 0x10) != 0;
    }

    public void setNoCursorTimeout(boolean t) {
        this.flags = t ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public void writeInt(int value, OutputStream to) throws IOException {
        to.write((byte)(value & 0xFF));
        to.write((byte)(value >> 8 & 0xFF));
        to.write((byte)(value >> 16 & 0xFF));
        to.write((byte)(value >> 24 & 0xFF));
    }

    public void writeString(String n, OutputStream to) throws IOException {
        to.write(n.getBytes("UTF-8"));
        to.write(0);
    }
}

