/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.driver.bson.BsonDecoder;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpReply
extends WireProtocolMessage {
    public final long timestamp = System.currentTimeMillis();
    private int reqId;
    private int inReplyTo;
    private int size = 0;
    private int opcode = 1;
    private int flags;
    private long cursorId;
    private int startFrom;
    private int numReturned;
    private List<Map<String, Object>> documents;

    public void parse(byte[] bytes) throws UnsupportedEncodingException {
        this.parse(bytes, 0);
    }

    public int getReqId() {
        return this.reqId;
    }

    public void setReqId(int reqId) {
        this.reqId = reqId;
    }

    public int getInReplyTo() {
        return this.inReplyTo;
    }

    public void setInReplyTo(int inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    public long getCursorId() {
        return this.cursorId;
    }

    public void setCursorId(long cursorId) {
        this.cursorId = cursorId;
    }

    public int getStartFrom() {
        return this.startFrom;
    }

    public void setStartFrom(int startFrom) {
        this.startFrom = startFrom;
    }

    public int getNumReturned() {
        return this.numReturned;
    }

    public void setNumReturned(int numReturned) {
        this.numReturned = numReturned;
    }

    public List<Map<String, Object>> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Map<String, Object>> documents) {
        this.documents = documents;
    }

    private void parse(byte[] bytes, int offset) throws UnsupportedEncodingException {
        this.size = OpReply.readInt(bytes, offset);
        this.reqId = OpReply.readInt(bytes, offset += 4);
        this.inReplyTo = OpReply.readInt(bytes, offset += 4);
        this.opcode = OpReply.readInt(bytes, offset += 4);
        offset += 4;
        if (this.opcode != 1) {
            throw new IllegalArgumentException("Unknown Opcode " + this.opcode);
        }
        this.flags = OpReply.readInt(bytes, offset);
        this.cursorId = OpReply.readLong(bytes, offset += 4);
        this.startFrom = OpReply.readInt(bytes, offset += 8);
        this.numReturned = OpReply.readInt(bytes, offset += 4);
        offset += 4;
        this.documents = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.numReturned; ++i) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            BsonDecoder dec = new BsonDecoder();
            int l = dec.decodeDocumentIn(m, bytes, offset);
            offset += l;
            this.documents.add(m);
        }
    }

    public int getOpCode() {
        return this.opcode;
    }
}

