/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Logger;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Aliases;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.IgnoreFields;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.LimitToFields;
import de.caluga.morphium.annotations.Property;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.annotations.caching.AsyncWrites;
import de.caluga.morphium.annotations.caching.WriteBuffer;
import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import de.caluga.morphium.driver.bson.MorphiumId;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class AnnotationAndReflectionHelper {
    private final Annotation annotationNotPresent = () -> null;
    private final Logger log = new Logger(AnnotationAndReflectionHelper.class);
    private final Map<Class<?>, Class<?>> realClassCache = new ConcurrentHashMap();
    private final Map<Class<?>, List<Field>> fieldListCache = new ConcurrentHashMap();
    private final Map<Class<?>, Map<Class<? extends Annotation>, Annotation>> annotationCache;
    private final Map<Class<?>, Map<String, String>> fieldNameCache;
    private Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();
    private Map<String, List<String>> fieldAnnotationListCache = new ConcurrentHashMap<String, List<String>>();
    private Map<Class<?>, Map<Class<? extends Annotation>, Method>> lifeCycleMethods;
    private Map<Class<?>, Boolean> hasAdditionalData;
    private boolean ccc = true;

    public AnnotationAndReflectionHelper(boolean convertCamelCase) {
        this.ccc = convertCamelCase;
        this.lifeCycleMethods = new ConcurrentHashMap();
        this.hasAdditionalData = new ConcurrentHashMap();
        this.annotationCache = new ConcurrentHashMap();
        this.fieldNameCache = new ConcurrentHashMap();
    }

    public <T extends Annotation> boolean isAnnotationPresentInHierarchy(Class<?> cls, Class<? extends T> anCls) {
        return this.getAnnotationFromHierarchy(cls, anCls) != null;
    }

    public <T> Class<? extends T> getRealClass(Class<? extends T> sc) {
        if (this.realClassCache.containsKey(sc)) {
            return this.realClassCache.get(sc);
        }
        if (sc.getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                Class<?> ret = Class.forName(sc.getName().substring(0, sc.getName().indexOf("$$")));
                this.realClassCache.put(sc, ret);
                sc = ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sc;
    }

    public boolean isBufferedWrite(Class<?> cls) {
        WriteBuffer wb = this.getAnnotationFromHierarchy(cls, WriteBuffer.class);
        return wb != null && wb.value();
    }

    public <T extends Annotation> T getAnnotationFromHierarchy(Class<?> cls, Class<? extends T> anCls) {
        if (this.annotationCache.get(cls = this.getRealClass(cls)) != null && this.annotationCache.get(cls).get(anCls) != null) {
            if (this.annotationCache.get(cls).get(anCls).equals(this.annotationNotPresent)) {
                return null;
            }
            return (T)this.annotationCache.get(cls).get(anCls);
        }
        this.annotationCache.putIfAbsent(cls, new HashMap());
        T ret = cls.getAnnotation(anCls);
        if (ret == null) {
            Class<?> z = cls;
            while (!z.equals(Object.class)) {
                if (z.isAnnotationPresent(anCls)) {
                    ret = z.getAnnotation(anCls);
                    break;
                }
                if ((z = z.getSuperclass()) != null) continue;
            }
            if (ret == null) {
                LinkedList interfaces = new LinkedList();
                Collections.addAll(interfaces, cls.getInterfaces());
                while (!interfaces.isEmpty()) {
                    Class iface = (Class)interfaces.poll();
                    if (iface.isAnnotationPresent(anCls)) {
                        ret = iface.getAnnotation(anCls);
                        break;
                    }
                    interfaces.addAll(Arrays.asList(iface.getInterfaces()));
                }
            }
        }
        if (ret == null) {
            this.annotationCache.get(cls).put(anCls, this.annotationNotPresent);
        } else {
            this.annotationCache.get(cls).put((Class<? extends Annotation>)anCls, (Annotation)ret);
        }
        return ret;
    }

    public boolean hasAdditionalData(Class clz) {
        if (this.hasAdditionalData.get(clz) == null) {
            List<String> lst = this.getFields(clz, AdditionalData.class);
            Map<Class<?>, Boolean> m = this.hasAdditionalData;
            m.put(clz, lst != null && !lst.isEmpty());
            this.hasAdditionalData = m;
        }
        return this.hasAdditionalData.get(clz);
    }

    public String getFieldName(Class clz, String field) {
        Map<Class<?>, Map<String, String>> m;
        Class cls = this.getRealClass(clz);
        if (field.contains(".") || field.contains("(") || field.contains("$")) {
            return field;
        }
        if (this.fieldNameCache.containsKey(clz) && this.fieldNameCache.get(clz).get(field) != null) {
            return this.fieldNameCache.get(clz).get(field);
        }
        String ret = field;
        List<Class<?>> inf = Arrays.asList(clz.getInterfaces());
        if (!(inf.contains(List.class) || inf.contains(Map.class) || inf.contains(Collection.class) || inf.contains(Set.class) || clz.isArray())) {
            Annotation p;
            Field f = this.getField(cls, field);
            if (f == null && this.hasAdditionalData(clz)) {
                return field;
            }
            if (f == null) {
                throw new RuntimeException("Field not found " + field + " in cls: " + clz.getName());
            }
            if (f.isAnnotationPresent(Property.class) && !(p = f.getAnnotation(Property.class)).fieldName().equals(".")) {
                return p.fieldName();
            }
            if (f.isAnnotationPresent(Reference.class) && !(p = f.getAnnotation(Reference.class)).fieldName().equals(".")) {
                return p.fieldName();
            }
            if (f.isAnnotationPresent(Id.class)) {
                return "_id";
            }
            ret = f.getName();
            Entity ent = this.getAnnotationFromHierarchy(cls, Entity.class);
            Embedded emb = this.getAnnotationFromHierarchy(cls, Embedded.class);
            if (this.ccc && ent != null && ent.translateCamelCase() || this.ccc && emb != null && emb.translateCamelCase()) {
                ret = this.convertCamelCase(ret);
            }
        }
        if (!(m = this.fieldNameCache).containsKey(cls)) {
            m.put(cls, new HashMap());
        }
        m.get(cls).put(field, ret);
        return ret;
    }

    public String createCamelCase(String n, boolean capitalize) {
        n = n.toLowerCase();
        String[] f = n.split("_");
        StringBuilder sb = new StringBuilder(f[0].substring(0, 1).toLowerCase());
        sb.append(f[0].substring(1));
        for (int i = 1; i < f.length; ++i) {
            sb.append(f[i].substring(0, 1).toUpperCase());
            sb.append(f[i].substring(1));
        }
        String ret = sb.toString();
        if (capitalize) {
            ret = ret.substring(0, 1).toUpperCase() + ret.substring(1);
        }
        return ret;
    }

    public String convertCamelCase(String n) {
        if (!this.ccc) {
            return n;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n.length() - 1; ++i) {
            if (Character.isUpperCase(n.charAt(i)) && i > 0) {
                b.append("_");
            }
            b.append(n.substring(i, i + 1).toLowerCase());
        }
        b.append(n.substring(n.length() - 1));
        return b.toString();
    }

    public List<Field> getAllFields(Class clz) {
        if (this.fieldListCache.containsKey(clz)) {
            return this.fieldListCache.get(clz);
        }
        Class cls = this.getRealClass(clz);
        ArrayList<Field> ret = new ArrayList<Field>();
        Class sc = cls;
        ArrayList hierachy = new ArrayList();
        while (!sc.equals(Object.class)) {
            hierachy.add(sc);
            sc = sc.getSuperclass();
        }
        Collections.addAll(hierachy, cls.getInterfaces());
        for (Class clazz : hierachy) {
            Collections.addAll(ret, clazz.getDeclaredFields());
        }
        this.fieldListCache.put(clz, ret);
        return ret;
    }

    public Field getField(Class clz, String fld) {
        String key = clz.toString() + "->" + fld;
        Field val = this.fieldCache.get(key);
        if (val != null) {
            return val;
        }
        Map<String, Field> fc = this.fieldCache;
        Class cls = this.getRealClass(clz);
        List<Field> flds = this.getAllFields(cls);
        Field ret = null;
        for (Field f : flds) {
            if (f.isAnnotationPresent(Property.class) && !".".equals(f.getAnnotation(Property.class).fieldName()) && f.getAnnotation(Property.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && f.isAnnotationPresent(Reference.class) && !".".equals(f.getAnnotation(Reference.class).fieldName()) && f.getAnnotation(Reference.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && f.isAnnotationPresent(Aliases.class)) {
                String[] v;
                Aliases aliases = f.getAnnotation(Aliases.class);
                for (String field : v = aliases.value()) {
                    if (!field.equals(fld)) continue;
                    f.setAccessible(true);
                    fc.put(key, f);
                    ret = f;
                }
            }
            if (ret == null && fld.equals("_id") && f.isAnnotationPresent(Id.class)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && f.getName().equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && this.ccc && this.convertCamelCase(f.getName()).equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null) continue;
            break;
        }
        this.fieldCache = fc;
        return ret;
    }

    public boolean isEntity(Object o) {
        if (o == null) {
            return false;
        }
        Class<Object> cls = o instanceof Class ? this.getRealClass((Class)o) : this.getRealClass(o.getClass());
        return this.isAnnotationPresentInHierarchy(cls, Entity.class) || this.isAnnotationPresentInHierarchy(cls, Embedded.class);
    }

    public Object getValue(Object o, String fld) {
        if (o == null) {
            return null;
        }
        try {
            Field f = this.getField(o.getClass(), fld);
            if (!Modifier.isStatic(f.getModifiers())) {
                o = this.getRealObject(o);
                return f.get(o);
            }
        }
        catch (IllegalAccessException e) {
            this.log.fatal("Illegal access to field " + fld + " of type " + o.getClass().getSimpleName());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object o, Object value, String fld) {
        if (o == null) {
            return;
        }
        try {
            Field f = this.getField(this.getRealClass(o.getClass()), fld);
            if (Modifier.isStatic(f.getModifiers())) return;
            o = this.getRealObject(o);
            try {
                f.set(o, value);
                return;
            }
            catch (Exception e) {
                if (value != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Setting of value (" + value.getClass().getSimpleName() + ") failed for field " + f.getName() + "- trying type-conversion");
                    }
                    if (value instanceof Double) {
                        Double d = (Double)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, d.intValue());
                        } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.longValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(d.longValue()));
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(d.floatValue()));
                        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, d == 1.0);
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, d.toString());
                        }
                    } else if (value instanceof Float) {
                        Float d = (Float)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, d.intValue());
                        } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.longValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(d.longValue()));
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, d);
                        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, d.floatValue() == 1.0f);
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, d.toString());
                        }
                    } else if (value instanceof Date) {
                        Date d = (Date)value;
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.getTime());
                        } else if (f.getType().equals(GregorianCalendar.class)) {
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTimeInMillis(d.getTime());
                            f.set(o, cal);
                        } else if (f.getType().equals(String.class)) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                            f.set(o, df.format(d));
                        }
                    } else if (value instanceof String) {
                        try {
                            String s = (String)value;
                            if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                                f.set(o, Long.parseLong(s));
                            }
                            if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                                f.set(o, Integer.parseInt(s));
                            }
                            if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                                f.set(o, Double.parseDouble(s));
                            }
                            if (f.getType().equals(Date.class)) {
                                if (s.length() == 8) {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                                    f.set(o, df.parse(s));
                                }
                                if (s.indexOf("-") > 0) {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                                    f.set(o, df.parse(s));
                                }
                                if (s.indexOf(".") > 0) {
                                    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
                                    f.set(o, df.parse(s));
                                }
                                f.set(o, new Date(Long.parseLong(s)));
                            }
                            if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                                f.set(o, s.equalsIgnoreCase("true"));
                            }
                            if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                                f.set(o, Float.valueOf(Float.parseFloat(s)));
                            }
                            if (!f.getType().equals(MorphiumId.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, new MorphiumId(s));
                        }
                        catch (ParseException e1) {
                            throw new RuntimeException(e1);
                        }
                    } else if (value instanceof Integer) {
                        Integer i = (Integer)value;
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, i.longValue());
                        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, i.doubleValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(i.longValue()));
                        } else if (f.getType().equals(String.class)) {
                            f.set(o, i.toString());
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(i.floatValue()));
                        } else {
                            if (!f.getType().equals(Boolean.class) && !f.getType().equals(Boolean.TYPE)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, i == 1);
                        }
                    } else if (value instanceof Long) {
                        Long l = (Long)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, l.intValue());
                        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, l.doubleValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(l));
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(l.floatValue()));
                        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, l == 1L);
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, l.toString());
                        }
                    } else if (value instanceof Boolean) {
                        Boolean b = (Boolean)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, b != false ? 1 : 0);
                        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, b != false ? 1.0 : 0.0);
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(b != false ? 1.0f : 0.0f));
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, b != false ? "true" : "false");
                        }
                    } else if (f.getType().isArray() && value instanceof List) {
                        Object arr = Array.newInstance(f.getType(), ((List)value).size());
                        int idx = 0;
                        for (Object io : (List)value) {
                            try {
                                Array.set(arr, idx, io);
                            }
                            catch (Exception e1) {
                                Array.set(arr, idx, ((Integer)io).byteValue());
                            }
                        }
                        f.set(o, arr);
                    } else {
                        this.log.error("Could not set value!!!");
                    }
                }
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Type conversion was successful");
            }
            return;
        }
        catch (IllegalAccessException e) {
            this.log.fatal("Illegal access to field " + fld + " of toype " + o.getClass().getSimpleName());
        }
    }

    public Object getId(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Field f = this.getIdField(o);
        if (f == null) {
            throw new IllegalArgumentException("Object ID field not found " + o.getClass().getSimpleName());
        }
        try {
            o = this.getRealObject(o);
            if (o != null) {
                return f.get(o);
            }
            this.log.warn("Illegal reference?");
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIdFieldName(Object o) {
        Class<?> cls = this.getRealClass(o.getClass());
        List<String> flds = this.getFields(cls, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new IllegalArgumentException("Object has no id defined: " + o.getClass().getSimpleName());
        }
        return flds.get(0);
    }

    public Field getIdField(Object o) {
        Class<Object> cls = o instanceof Class ? this.getRealClass((Class)o) : this.getRealClass(o.getClass());
        List<String> flds = this.getFields(cls, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new IllegalArgumentException("Object has no id defined: " + o.getClass().getSimpleName());
        }
        return this.getField(cls, flds.get(0));
    }

    public List<String> getFields(Class cls, Class<? extends Annotation> ... annotations) {
        StringBuilder stringBuilder = new StringBuilder(cls.toString());
        for (Class<? extends Annotation> a : annotations) {
            stringBuilder.append("/");
            stringBuilder.append(a.toString());
        }
        List<String> strings = this.fieldAnnotationListCache.get(stringBuilder.toString());
        if (strings != null) {
            return strings;
        }
        Map<String, List<String>> fa = this.fieldAnnotationListCache;
        ArrayList<String> ret = new ArrayList<String>();
        Class sc = cls;
        sc = this.getRealClass(sc);
        Entity entity = this.getAnnotationFromHierarchy(sc, Entity.class);
        Embedded embedded = this.getAnnotationFromHierarchy(sc, Embedded.class);
        if (embedded != null && entity != null) {
            this.log.warn("Class " + cls.getName() + " does have both @Entity and @Embedded Annotations - not allowed! Assuming @Entity is right");
        }
        if (embedded == null && entity == null) {
            throw new IllegalArgumentException("This class " + cls.getName() + " does not have @Entity or @Embedded set, not even in hierachy - illegal!");
        }
        boolean tcc = entity == null ? embedded.translateCamelCase() : entity.translateCamelCase();
        IgnoreFields ignoreFields = this.getAnnotationFromHierarchy(sc, IgnoreFields.class);
        LimitToFields limitToFields = this.getAnnotationFromHierarchy(sc, LimitToFields.class);
        ArrayList<String> fieldsToIgnore = new ArrayList<String>();
        ArrayList<String> ignoreContains = new ArrayList<String>();
        ArrayList<Pattern> ignoreRexex = new ArrayList<Pattern>();
        if (ignoreFields != null && ignoreFields.value().length != 0) {
            for (String string : ignoreFields.value()) {
                if (string.startsWith("~")) {
                    ignoreContains.add(string.substring(1));
                    continue;
                }
                if (string.startsWith("/") && string.endsWith("/")) {
                    ignoreRexex.add(Pattern.compile(string.substring(1).substring(0, string.length() - 2)));
                    continue;
                }
                fieldsToIgnore.add(string);
            }
        }
        ArrayList<String> fieldsToLimitTo = new ArrayList<String>();
        if (limitToFields != null && limitToFields.value().length != 0) {
            fieldsToLimitTo.addAll(Arrays.asList(limitToFields.value()));
        }
        if (limitToFields != null && !limitToFields.type().equals(Object.class)) {
            List<Field> flds = this.getAllFields(limitToFields.type());
            for (Field field : flds) {
                fieldsToLimitTo.add(this.getFieldName(limitToFields.type(), field.getName()));
            }
        }
        List<Field> fld = this.getAllFields(cls);
        for (Field field : fld) {
            if (annotations.length > 0) {
                boolean found = false;
                for (Class<? extends Annotation> a : annotations) {
                    if (!field.isAnnotationPresent(a)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (field.isAnnotationPresent(Reference.class) && !".".equals(field.getAnnotation(Reference.class).fieldName())) {
                ret.add(field.getAnnotation(Reference.class).fieldName());
                continue;
            }
            if (field.isAnnotationPresent(Property.class) && !".".equals(field.getAnnotation(Property.class).fieldName())) {
                ret.add(field.getAnnotation(Property.class).fieldName());
                continue;
            }
            if (field.isAnnotationPresent(Transient.class)) continue;
            boolean ignore = false;
            String conv = field.getName();
            if (tcc && this.ccc) {
                conv = this.convertCamelCase(field.getName());
            }
            if (fieldsToIgnore.contains(conv) || fieldsToIgnore.contains(field.getName())) {
                ignore = true;
            }
            if (!ignore) {
                for (String ign : ignoreContains) {
                    if (!field.getName().contains(ign) && !conv.contains(ign)) continue;
                    ignore = true;
                }
            }
            if (!ignore) {
                for (Pattern reg : ignoreRexex) {
                    if (!reg.matcher(field.getName()).matches() && !reg.matcher(conv).matches()) continue;
                    ignore = true;
                }
            }
            if (!(ignore || fieldsToLimitTo.isEmpty() || fieldsToLimitTo.contains(conv) || fieldsToLimitTo.contains(field.getName()))) {
                ignore = true;
            }
            if (ignore) continue;
            ret.add(conv);
        }
        fa.put(stringBuilder.toString(), ret);
        this.fieldAnnotationListCache = fa;
        return ret;
    }

    public <T> T getRealObject(T o) {
        if (o.getClass().getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                Field f1 = o.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                f1.setAccessible(true);
                Object delegate = f1.get(o);
                Method m = delegate.getClass().getMethod("__getDeref", new Class[0]);
                o = m.invoke(delegate, new Object[0]);
            }
            catch (Exception e) {
                this.log.error("Exception: ", e);
            }
        }
        return o;
    }

    public final Class getTypeOfField(Class<?> cls, String fld) {
        Field f = this.getField(cls, fld);
        if (f == null) {
            return null;
        }
        return f.getType();
    }

    public boolean storesLastChange(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastChange.class);
    }

    public boolean storesLastAccess(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastAccess.class);
    }

    public boolean storesCreation(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, CreationTime.class);
    }

    public Long getLongValue(Object o, String fld) {
        return (Long)this.getValue(o, fld);
    }

    public String getStringValue(Object o, String fld) {
        return (String)this.getValue(o, fld);
    }

    public Date getDateValue(Object o, String fld) {
        return (Date)this.getValue(o, fld);
    }

    public Double getDoubleValue(Object o, String fld) {
        return (Double)this.getValue(o, fld);
    }

    public List<Annotation> getAllAnnotationsFromHierachy(Class<?> cls, Class<? extends Annotation> ... anCls) {
        cls = this.getRealClass(cls);
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        Class<?> z = cls;
        while (!z.equals(Object.class)) {
            if (z.getAnnotations() != null && z.getAnnotations().length != 0) {
                if (anCls.length == 0) {
                    ret.addAll(Arrays.asList(z.getAnnotations()));
                } else {
                    for (Annotation a : z.getAnnotations()) {
                        for (Class<? extends Annotation> ac : anCls) {
                            if (!a.annotationType().equals(ac)) continue;
                            ret.add(a);
                        }
                    }
                }
            }
            if ((z = z.getSuperclass()) != null) continue;
            break;
        }
        return ret;
    }

    public String getLastChangeField(Class<?> cls) {
        if (!this.storesLastChange(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, LastChange.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getLastAccessField(Class<?> cls) {
        if (!this.storesLastAccess(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, LastAccess.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getCreationTimeField(Class<?> cls) {
        if (!this.storesCreation(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, CreationTime.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public void callLifecycleMethod(Class<? extends Annotation> type, Object on) {
        this.callLifecycleMethod(type, on, new ArrayList());
    }

    private void callLifecycleMethod(Class<? extends Annotation> type, Object on, List calledOn) {
        if (on == null) {
            return;
        }
        if (on.getClass().getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                Field f1 = on.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                f1.setAccessible(true);
                Object delegate = f1.get(on);
                Method m = delegate.getClass().getMethod("__getPureDeref", new Class[0]);
                on = m.invoke(delegate, new Object[0]);
                if (on == null) {
                    return;
                }
            }
            catch (Exception e) {
                this.log.error("Exception: ", e);
            }
        }
        if (calledOn.contains(on)) {
            return;
        }
        calledOn.add(on);
        Class<?> cls = on.getClass();
        if (!this.isAnnotationPresentInHierarchy(cls, Lifecycle.class)) {
            return;
        }
        List<String> flds = this.getFields(on.getClass(), new Class[0]);
        for (String string : flds) {
            Field field = this.getField(on.getClass(), string);
            if (!this.isAnnotationPresentInHierarchy(field.getType(), Entity.class) && !this.isAnnotationPresentInHierarchy(field.getType(), Embedded.class) || !this.isAnnotationPresentInHierarchy(field.getType(), Lifecycle.class)) continue;
            field.setAccessible(true);
            try {
                this.callLifecycleMethod(type, field.get(on), calledOn);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.lifeCycleMethods.get(cls) != null) {
            if (this.lifeCycleMethods.get(cls).get(type) != null) {
                try {
                    this.lifeCycleMethods.get(cls).get(type).invoke(on, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause().getClass().equals(MorphiumAccessVetoException.class)) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        HashMap<Class<? extends Annotation>, Method> methods = new HashMap<Class<? extends Annotation>, Method>();
        for (Method m : cls.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                methods.put(a.annotationType(), m);
            }
        }
        Map<Class<?>, Map<Class<Annotation>, Method>> map = this.lifeCycleMethods;
        map.put(cls, methods);
        if (methods.get(type) != null) {
            try {
                ((Method)methods.get(type)).invoke(on, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.lifeCycleMethods = map;
    }

    public boolean isAsyncWrite(Class<?> cls) {
        AsyncWrites wb = this.getAnnotationFromHierarchy(cls, AsyncWrites.class);
        return wb != null && wb.value();
    }
}

