/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.singleconnect;

import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bson.MorphiumId;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.singleconnect.DriverBase;
import de.caluga.morphium.driver.singleconnect.NetworkCallHelper;
import de.caluga.morphium.driver.singleconnect.SingleConnectCursor;
import de.caluga.morphium.driver.wireprotocol.OpQuery;
import de.caluga.morphium.driver.wireprotocol.OpReply;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SingleConnectThreaddedDriver
extends DriverBase {
    private final List<OpReply> replies = Collections.synchronizedList(new ArrayList());
    private final Logger log = new Logger(SingleConnectThreaddedDriver.class);
    private Socket s;
    private OutputStream out;
    private InputStream in;
    private volatile int waitingForReply = 0;

    private void reconnect() throws MorphiumDriverException {
        try {
            this.out.close();
            this.in.close();
            this.s.close();
        }
        catch (Exception e) {
            this.s = null;
            this.in = null;
            this.out = null;
        }
        this.connect();
    }

    @Override
    public void connect(String replSet) throws MorphiumDriverException {
        if (this.s != null && this.s.isConnected() && !this.s.isClosed()) {
            this.log.error("Already connected! not reconnecting!");
            return;
        }
        try {
            String host = this.getHostSeed()[0];
            String[] h = host.split(":");
            int port = 27017;
            if (h.length > 1) {
                port = Integer.parseInt(h[1]);
            }
            this.s = new Socket(h[0], port);
            this.s.setKeepAlive(this.isSocketKeepAlive());
            this.s.setSoTimeout(this.getSocketTimeout());
            this.out = this.s.getOutputStream();
            this.in = this.s.getInputStream();
            Thread reader = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.setName("singleconnecthreaddeddriver_thread");
                    byte[] inBuffer = new byte[16];
                    int errorcount = 0;
                    while (SingleConnectThreaddedDriver.this.s != null && SingleConnectThreaddedDriver.this.s.isConnected()) {
                        try {
                            int numRead;
                            for (numRead = SingleConnectThreaddedDriver.this.in.read(inBuffer, 0, 16); numRead < 16; numRead += SingleConnectThreaddedDriver.this.in.read(inBuffer, numRead, 16 - numRead)) {
                            }
                            int size = OpReply.readInt(inBuffer, 0);
                            if (size == 0) {
                                SingleConnectThreaddedDriver.this.log.error("Error - null size! closing connection");
                                System.exit(1);
                                break;
                            }
                            if (size > 0x1000000) {
                                SingleConnectThreaddedDriver.this.log.error("Error - size too big! " + size);
                                System.exit(1);
                                break;
                            }
                            int opcode = OpReply.readInt(inBuffer, 12);
                            if (opcode != 1) {
                                SingleConnectThreaddedDriver.this.log.error("illegal opcode! " + opcode);
                                System.exit(1);
                                break;
                            }
                            byte[] buf = new byte[size];
                            System.arraycopy(inBuffer, 0, buf, 0, 16);
                            for (numRead = SingleConnectThreaddedDriver.this.in.read(buf, 16, size - 16); numRead < size - 16; numRead += SingleConnectThreaddedDriver.this.in.read(buf, 16 + numRead, size - numRead - 16)) {
                            }
                            OpReply reply = new OpReply();
                            try {
                                reply.parse(buf);
                                if (reply.getDocuments() == null || reply.getDocuments().isEmpty()) {
                                    SingleConnectThreaddedDriver.this.log.error("did not get any data... slowing down");
                                    if (++errorcount > 10) {
                                        SingleConnectThreaddedDriver.this.log.error("Could not recover... exiting!");
                                        try {
                                            SingleConnectThreaddedDriver.this.close();
                                            break;
                                        }
                                        catch (MorphiumDriverException morphiumDriverException) {
                                            // empty catch block
                                        }
                                    }
                                    Thread.sleep(500L);
                                    continue;
                                }
                                if (reply.getDocuments() == null || reply.getDocuments().isEmpty()) {
                                    SingleConnectThreaddedDriver.this.log.error("did not get a valid reply!");
                                    Thread.sleep(500L);
                                    continue;
                                }
                                if (reply.getDocuments().get(0).get("ok") == null) {
                                    SingleConnectThreaddedDriver.this.log.error("Weird result! " + reply.getInReplyTo());
                                    SingleConnectThreaddedDriver.this.log.error(Utils.toJsonString(reply.getDocuments().get(0)));
                                    System.exit(1);
                                    continue;
                                }
                                if (!reply.getDocuments().get(0).get("ok").equals(1) && reply.getDocuments().get(0).get("code") != null) {
                                    SingleConnectThreaddedDriver.this.log.debug("Error " + reply.getDocuments().get(0).get("code"));
                                    SingleConnectThreaddedDriver.this.log.debug("Error " + reply.getDocuments().get(0).get("errmsg"));
                                }
                                List list = SingleConnectThreaddedDriver.this.replies;
                                synchronized (list) {
                                    SingleConnectThreaddedDriver.this.replies.add(reply);
                                    ArrayList toRemove = SingleConnectThreaddedDriver.this.replies.stream().filter(r -> System.currentTimeMillis() - r.timestamp > (long)SingleConnectThreaddedDriver.this.getHeartbeatSocketTimeout()).collect(Collectors.toCollection(ArrayList::new));
                                    toRemove.forEach(SingleConnectThreaddedDriver.this.replies::remove);
                                }
                            }
                            catch (Exception e) {
                                SingleConnectThreaddedDriver.this.log.error("Could not read", e);
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                            break;
                        }
                    }
                    try {
                        SingleConnectThreaddedDriver.this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SingleConnectThreaddedDriver.this.log.debug("reply-thread terminated!");
                }
            };
            reader.setDaemon(true);
            reader.start();
            try {
                Map<String, Object> result = this.runCommand("local", Utils.getMap("isMaster", true));
                if (result == null) {
                    this.log.fatal("Could not run ismaster!!!! result is null");
                    throw new RuntimeException("Connect failed!");
                }
                this.setReplicaSetName((String)result.get("setName"));
                if (replSet != null && !replSet.equals(this.getReplicaSetName())) {
                    throw new MorphiumDriverException("Replicaset name is wrong - connected to " + this.getReplicaSetName() + " should be " + replSet);
                }
                this.setMaxBsonObjectSize((Integer)result.get("maxBsonObjectSize"));
                this.setMaxMessageSize((Integer)result.get("maxMessageSizeBytes"));
                this.setMaxWriteBatchSize((Integer)result.get("maxWriteBatchSize"));
            }
            catch (MorphiumDriverException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            throw new MorphiumDriverNetworkException("connection failed", e);
        }
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    @Override
    public boolean isConnected() {
        return this.s != null && this.s.isConnected();
    }

    @Override
    public void close() throws MorphiumDriverException {
        try {
            this.s.close();
            this.out.close();
            this.in.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.s = null;
        }
    }

    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        return new NetworkCallHelper().doCall(() -> {
            Map<String, Object> ret = this.runCommand("admin", Utils.getMap("replSetGetStatus", 1));
            List mem = (List)ret.get("members");
            if (mem == null) {
                return null;
            }
            mem.stream().filter(d -> d.get("optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get("optime")).get("ts")));
            return ret;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        return this.runCommand(db, Utils.getMap("dbstats", 1));
    }

    @Override
    public Map<String, Object> getOps(long threshold) throws MorphiumDriverException {
        return null;
    }

    @Override
    public Map<String, Object> runCommand(String db, Map<String, Object> cmd) throws MorphiumDriverException {
        return new NetworkCallHelper().doCall(() -> {
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setLimit(1);
            q.setSkip(0);
            q.setReqId(this.getNextId());
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            doc.putAll(cmd);
            q.setDoc(doc);
            q.setInReplyTo(0);
            OpReply rep = null;
            this.sendQuery(q);
            try {
                rep = this.waitForReply(db, null, null, q.getReqId());
            }
            catch (MorphiumDriverException e) {
                e.printStackTrace();
            }
            if (rep == null || rep.getDocuments() == null) {
                return null;
            }
            return rep.getDocuments().get(0);
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Map<String, Object> findMetaData) throws MorphiumDriverException {
        if (sort == null) {
            sort = new HashMap<String, Integer>();
        }
        OpQuery q = new OpQuery();
        q.setDb(db);
        q.setColl("$cmd");
        q.setLimit(1);
        q.setSkip(0);
        q.setReqId(this.getNextId());
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        doc.put("find", collection);
        if (limit > 0) {
            doc.put("limit", limit);
        }
        doc.put("skip", skip);
        if (!query.isEmpty()) {
            doc.put("filter", query);
        }
        doc.put("sort", sort);
        doc.put("batchSize", batchSize);
        q.setDoc(doc);
        q.setFlags(0);
        q.setInReplyTo(0);
        this.sendQuery(q);
        int waitingfor = q.getReqId();
        OpReply reply = this.getReply(waitingfor);
        if (reply.getInReplyTo() != waitingfor) {
            throw new MorphiumDriverNetworkException("Got wrong answser. Request: " + waitingfor + " got answer for " + reply.getInReplyTo());
        }
        MorphiumCursor<SingleConnectCursor> crs = new MorphiumCursor<SingleConnectCursor>();
        Map cursor = (Map)reply.getDocuments().get(0).get("cursor");
        if (cursor != null && cursor.get("id") != null) {
            crs.setCursorId((Long)cursor.get("id"));
        }
        if (cursor == null) {
            return null;
        }
        if (cursor.get("firstBatch") != null) {
            crs.setBatch((List)cursor.get("firstBatch"));
        } else if (cursor.get("nextBatch") != null) {
            crs.setBatch((List)cursor.get("nextBatch"));
        }
        SingleConnectCursor internalCursorData = new SingleConnectCursor(this);
        internalCursorData.setBatchSize(batchSize);
        internalCursorData.setCollection(collection);
        internalCursorData.setDb(db);
        crs.setInternalCursorObject(internalCursorData);
        return crs;
    }

    @Override
    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        long cursorId = crs.getCursorId();
        SingleConnectCursor internalCursorData = (SingleConnectCursor)crs.getInternalCursorObject();
        if (cursorId == 0L) {
            return null;
        }
        OpQuery q = new OpQuery();
        q.setColl("$cmd");
        q.setDb(internalCursorData.getDb());
        q.setReqId(this.getNextId());
        q.setSkip(0);
        q.setLimit(1);
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        doc.put("getMore", cursorId);
        doc.put("collection", internalCursorData.getCollection());
        doc.put("batchSize", internalCursorData.getBatchSize());
        q.setDoc(doc);
        this.sendQuery(q);
        OpReply reply = this.getReply(q.getReqId());
        crs = new MorphiumCursor<SingleConnectCursor>();
        crs.setInternalCursorObject(internalCursorData);
        Map cursor = (Map)reply.getDocuments().get(0).get("cursor");
        if (cursor == null) {
            throw new MorphiumDriverException("Iteration failed! Error: " + reply.getDocuments().get(0).get("code") + "  Message: " + reply.getDocuments().get(0).get("errmsg"));
        }
        if (cursor.get("id") != null) {
            crs.setCursorId((Long)cursor.get("id"));
        }
        if (cursor.get("firstBatch") != null) {
            crs.setBatch((List)cursor.get("firstBatch"));
        } else if (cursor.get("nextBatch") != null) {
            crs.setBatch((List)cursor.get("nextBatch"));
        }
        return crs;
    }

    @Override
    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        SingleConnectCursor internalCursor = (SingleConnectCursor)crs.getInternalCursorObject();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("killCursors", internalCursor.getCollection());
        ArrayList<Long> cursors = new ArrayList<Long>();
        cursors.add(crs.getCursorId());
        m.put("cursors", cursors);
        this.runCommand(internalCursor.getDb(), m);
    }

    @Override
    public List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Integer> s, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference rp, Map<String, Object> findMetaData) throws MorphiumDriverException {
        if (s == null) {
            s = new HashMap<String, Integer>();
        }
        Map<String, Integer> sort = s;
        return (List)new NetworkCallHelper().doCall(() -> {
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setLimit(1);
            q.setSkip(0);
            q.setReqId(this.getNextId());
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            doc.put("find", collection);
            if (limit > 0) {
                doc.put("limit", limit);
            }
            doc.put("skip", skip);
            if (!query.isEmpty()) {
                doc.put("filter", query);
            }
            if (projection != null) {
                doc.put("projection", projection);
            }
            doc.put("sort", sort);
            q.setDoc(doc);
            q.setInReplyTo(0);
            List<Map<String, Object>> ret = null;
            this.sendQuery(q);
            Object reply = null;
            int waitingfor = q.getReqId();
            ret = this.readBatches(waitingfor, db, collection, batchSize);
            return Utils.getMap("values", ret);
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries()).get("values");
    }

    private List<Map<String, Object>> readBatches(int waitingfor, String db, String collection, int batchSize) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        while (true) {
            OpReply reply;
            if ((reply = this.getReply(waitingfor)).getInReplyTo() != waitingfor) {
                throw new MorphiumDriverNetworkException("Wrong answer - waiting for " + waitingfor + " but got " + reply.getInReplyTo());
            }
            Map cursor = (Map)reply.getDocuments().get(0).get("cursor");
            if (cursor == null) {
                if (reply.getDocuments().get(0).get("result") != null) {
                    return (List)reply.getDocuments().get(0).get("result");
                }
                this.log.error("did not get cursor. Data: " + Utils.toJsonString(reply.getDocuments().get(0)));
                throw new MorphiumDriverException("did not get any data, cursor == null!");
            }
            if (cursor.get("firstBatch") != null) {
                ret.addAll((List)cursor.get("firstBatch"));
            } else if (cursor.get("nextBatch") != null) {
                ret.addAll((List)cursor.get("nextBatch"));
            }
            if ((Long)cursor.get("id") == 0L) break;
            OpQuery q = new OpQuery();
            q.setColl("$cmd");
            q.setDb(db);
            q.setReqId(this.getNextId());
            q.setSkip(0);
            q.setLimit(1);
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            doc.put("getMore", cursor.get("id"));
            doc.put("collection", collection);
            doc.put("batchSize", batchSize);
            q.setDoc(doc);
            waitingfor = q.getReqId();
            this.sendQuery(q);
        }
        return ret;
    }

    protected OpReply getReply(long waitingfor) throws MorphiumDriverException {
        return this.getReply(waitingfor, this.getMaxWaitTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected OpReply getReply(long waitingfor, int maxWait) throws MorphiumDriverException {
        ++this.waitingForReply;
        try {
            long start = System.currentTimeMillis();
            while (true) {
                List<OpReply> list = this.replies;
                synchronized (list) {
                    for (int i = 0; i < this.replies.size(); ++i) {
                        if ((long)this.replies.get(i).getInReplyTo() != waitingfor) continue;
                        OpReply opReply = this.replies.remove(i);
                        return opReply;
                    }
                    if (System.currentTimeMillis() - start > (long)maxWait) {
                        throw new MorphiumDriverNetworkException("could not get reply in time");
                    }
                }
                Thread.yield();
            }
        }
        finally {
            --this.waitingForReply;
        }
    }

    @Override
    protected void sendQuery(OpQuery q) throws MorphiumDriverException {
        boolean retry = true;
        if (q.getDb() == null) {
            throw new IllegalArgumentException("cannot send command without db");
        }
        if (this.isSlaveOk()) {
            q.setFlags(4);
        }
        long start = System.currentTimeMillis();
        while (retry) {
            if (this.s == null || !this.s.isConnected()) {
                this.log.debug("Not connected - reconnecting");
                this.connect();
            }
            try {
                if (System.currentTimeMillis() - start > (long)this.getMaxWaitTime()) {
                    throw new MorphiumDriverException("Could not send message! Timeout!");
                }
                this.out.write(q.bytes());
                this.out.flush();
                retry = false;
            }
            catch (IOException e) {
                this.log.error("Error sending request - reconnecting", e);
                this.reconnect();
            }
        }
    }

    @Override
    public long count(String db, String collection, Map<String, Object> query, ReadPreference rp) throws MorphiumDriverException {
        Map<String, Object> ret = new NetworkCallHelper().doCall(() -> {
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setLimit(1);
            q.setSkip(0);
            q.setReqId(this.getNextId());
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            doc.put("count", collection);
            doc.put("query", query);
            q.setDoc(doc);
            q.setInReplyTo(0);
            OpReply rep = null;
            this.sendQuery(q);
            rep = this.waitForReply(db, collection, query, q.getReqId());
            Integer n = (Integer)rep.getDocuments().get(0).get("n");
            return Utils.getMap("count", n == null ? 0 : n);
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
        return ((Integer)ret.get("count")).intValue();
    }

    @Override
    public void insert(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        new NetworkCallHelper().doCall(() -> {
            int idx = 0;
            for (Map o : objs) {
                o.putIfAbsent("_id", new MorphiumId());
            }
            while (idx < objs.size()) {
                OpQuery op = new OpQuery();
                op.setInReplyTo(0);
                op.setReqId(this.getNextId());
                op.setDb(db);
                op.setColl("$cmd");
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("insert", collection);
                ArrayList docs = new ArrayList();
                for (int i = idx; i < idx + 1000 && i < objs.size(); ++i) {
                    docs.add(objs.get(i));
                }
                idx += docs.size();
                map.put("documents", docs);
                map.put("ordered", false);
                map.put("writeConcern", new HashMap());
                op.setDoc(map);
                this.sendQuery(op);
                this.waitForReply(db, collection, null, op.getReqId());
            }
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public void store(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        new NetworkCallHelper().doCall(() -> {
            ArrayList<Map<String, Object>> toInsert = new ArrayList<Map<String, Object>>();
            ArrayList<Map> toUpdate = new ArrayList<Map>();
            ArrayList update = new ArrayList();
            for (Map o : objs) {
                if (o.get("_id") == null) {
                    toInsert.add(o);
                    continue;
                }
                toUpdate.add(o);
            }
            ArrayList<Map<String, Object>> updateCmd = new ArrayList<Map<String, Object>>();
            for (Map obj : toUpdate) {
                HashMap<String, Object> up = new HashMap<String, Object>();
                up.put("q", Utils.getMap("_id", obj.get("_id")));
                up.put("u", obj);
                up.put("upsert", true);
                up.put("multi", false);
                updateCmd.add(up);
            }
            if (!updateCmd.isEmpty()) {
                this.update(db, collection, updateCmd, false, wc);
            }
            if (!toInsert.isEmpty()) {
                this.insert(db, collection, toInsert, wc);
            }
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> ops, boolean multiple, boolean upsert, WriteConcern wc) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> opsLst = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> up = new HashMap<String, Object>();
        up.put("q", query);
        up.put("u", ops);
        up.put("upsert", upsert);
        up.put("multi", multiple);
        opsLst.add(up);
        return this.update(db, collection, opsLst, false, wc);
    }

    @Override
    public Map<String, Object> update(String db, String collection, List<Map<String, Object>> updateCommand, boolean ordered, WriteConcern wc) throws MorphiumDriverException {
        return new NetworkCallHelper().doCall(() -> {
            int idx;
            for (int i = idx = 0; i < updateCommand.size() - idx; i += this.getMaxWriteBatchSize()) {
                int end = idx + this.getMaxWriteBatchSize();
                if (end > updateCommand.size()) {
                    end = updateCommand.size();
                }
                OpQuery op = new OpQuery();
                op.setInReplyTo(0);
                op.setReqId(this.getNextId());
                op.setDb(db);
                op.setColl("$cmd");
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("update", collection);
                map.put("updates", updateCommand.subList(idx, end));
                map.put("ordered", false);
                map.put("writeConcern", new HashMap());
                op.setDoc(map);
                this.sendQuery(op);
                if (wc == null) continue;
                OpReply res = this.waitForReply(db, collection, null, op.getReqId());
                return res.getDocuments().get(0);
            }
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public Map<String, Object> delete(String db, String collection, Map<String, Object> query, boolean multiple, WriteConcern wc) throws MorphiumDriverException {
        return new NetworkCallHelper().doCall(() -> {
            OpQuery op = new OpQuery();
            op.setColl("$cmd");
            op.setDb(db);
            op.setReqId(this.getNextId());
            op.setLimit(-1);
            LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
            o.put("delete", collection);
            o.put("ordered", false);
            LinkedHashMap<String, Constable> wrc = new LinkedHashMap<String, Constable>();
            wrc.put("w", Integer.valueOf(1));
            wrc.put("wtimeout", Integer.valueOf(1000));
            wrc.put("fsync", Boolean.valueOf(false));
            wrc.put("j", Boolean.valueOf(true));
            o.put("writeConcern", wrc);
            LinkedHashMap<String, Object> q = new LinkedHashMap<String, Object>();
            q.put("q", query);
            q.put("limit", 0);
            ArrayList<LinkedHashMap<String, Object>> del = new ArrayList<LinkedHashMap<String, Object>>();
            del.add(q);
            o.put("deletes", del);
            op.setDoc(o);
            this.sendQuery(op);
            OpReply reply = null;
            int waitingfor = op.getReqId();
            reply = this.waitForReply(db, collection, query, waitingfor);
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    private OpReply waitForReply(String db, String collection, Map<String, Object> query, int waitingfor) throws MorphiumDriverException {
        OpReply reply = this.getReply(waitingfor);
        if (!reply.getDocuments().get(0).get("ok").equals(1) && !reply.getDocuments().get(0).get("ok").equals(1.0)) {
            Object code = reply.getDocuments().get(0).get("code");
            Object errmsg = reply.getDocuments().get(0).get("errmsg");
            MorphiumDriverException mde = new MorphiumDriverException("Operation failed on " + this.getHostSeed()[0] + " - error: " + code + " - " + errmsg, null, collection, db, query);
            mde.setMongoCode(code);
            mde.setMongoReason(errmsg);
            throw mde;
        }
        return reply;
    }

    @Override
    public void drop(String db, String collection, WriteConcern wc) throws MorphiumDriverException {
        new NetworkCallHelper().doCall(() -> {
            OpQuery op = new OpQuery();
            op.setInReplyTo(0);
            op.setReqId(this.getNextId());
            op.setDb(db);
            op.setColl("$cmd");
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("drop", collection);
            op.setDoc(map);
            this.sendQuery(op);
            try {
                this.waitForReply(db, collection, null, op.getReqId());
            }
            catch (Exception e) {
                if (e instanceof MorphiumDriverException && e.getMessage().contains("ns not found")) {
                    this.log.debug("Drop failed, non existent collection");
                }
                this.log.debug("Drop failed! " + e.getMessage(), e);
            }
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public void drop(String db, WriteConcern wc) throws MorphiumDriverException {
        new NetworkCallHelper().doCall(() -> {
            OpQuery op = new OpQuery();
            op.setInReplyTo(0);
            op.setReqId(this.getNextId());
            op.setDb(db);
            op.setColl("$cmd");
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("drop", 1);
            op.setDoc(map);
            this.sendQuery(op);
            try {
                this.waitForReply(db, null, null, op.getReqId());
            }
            catch (Exception e) {
                this.log.error("Drop failed! " + e.getMessage());
            }
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public boolean exists(String db) throws MorphiumDriverException {
        try {
            this.getDBStats(db);
            return true;
        }
        catch (MorphiumDriverException morphiumDriverException) {
            return false;
        }
    }

    @Override
    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, ReadPreference rp) throws MorphiumDriverException {
        Map<String, Object> ret = new NetworkCallHelper().doCall(() -> {
            OpQuery op = new OpQuery();
            op.setColl("$cmd");
            op.setLimit(1);
            op.setReqId(this.getNextId());
            op.setSkip(0);
            op.setDb(db);
            LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
            cmd.put("distinct", collection);
            cmd.put("key", field);
            cmd.put("query", filter);
            op.setDoc(cmd);
            this.sendQuery(op);
            try {
                OpReply res = this.waitForReply(db, null, null, op.getReqId());
                return Utils.getMap("result", res.getDocuments().get(0).get("values"));
            }
            catch (Exception e) {
                this.log.fatal("did not get result", e);
                return null;
            }
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
        return (List)ret.get("result");
    }

    @Override
    public boolean exists(String db, String collection) throws MorphiumDriverException {
        List<Map<String, Object>> ret = this.getCollectionInfo(db, collection);
        for (Map<String, Object> c : ret) {
            if (!c.get("name").equals(collection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Map<String, Object>> getIndexes(String db, String collection) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
            cmd.put("listIndexes", collection);
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setLimit(1);
            q.setSkip(0);
            q.setReqId(this.getNextId());
            q.setDoc(cmd);
            q.setInReplyTo(0);
            this.sendQuery(q);
            List<Map<String, Object>> ret = this.readBatches(q.getReqId(), db, null, this.getMaxWriteBatchSize());
            return Utils.getMap("result", ret);
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries()).get("result");
    }

    @Override
    public List<String> getCollectionNames(String db) throws MorphiumDriverException {
        List<Map<String, Object>> ret = this.getCollectionInfo(db, null);
        return ret.stream().map(c -> (String)c.get("name")).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getCollectionInfo(String db, String collection) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
            cmd.put("listCollections", 1);
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setLimit(1);
            q.setSkip(0);
            q.setReqId(this.getNextId());
            if (collection != null) {
                cmd.put("filter", Utils.getMap("name", collection));
            }
            q.setDoc(cmd);
            q.setInReplyTo(0);
            this.sendQuery(q);
            List<Map<String, Object>> ret = this.readBatches(q.getReqId(), db, null, this.getMaxWriteBatchSize());
            return Utils.getMap("result", ret);
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries()).get("result");
    }

    @Override
    public Map<String, Object> group(String db, String coll, Map<String, Object> query, Map<String, Object> initial, String jsReduce, String jsFinalize, ReadPreference rp, String ... keys) throws MorphiumDriverException {
        return new NetworkCallHelper().doCall(() -> {
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setReqId(this.getNextId());
            q.setSkip(0);
            q.setLimit(1);
            LinkedHashMap<String, Map<String, String>> cmd = new LinkedHashMap<String, Map<String, String>>();
            Map<String, String> map = Utils.getMap("ns", coll);
            HashMap<String, Integer> key = new HashMap<String, Integer>();
            for (String k : keys) {
                key.put(k, 1);
            }
            map.put("key", (String)((Object)key));
            if (jsReduce != null) {
                map.put("$reduce", jsReduce);
            }
            if (jsFinalize != null) {
                map.put("finalize", jsFinalize);
            }
            if (initial != null) {
                map.put("initial", (String)((Object)initial));
            }
            if (query != null) {
                map.put("cond", (String)((Object)query));
            }
            cmd.put("group", map);
            try {
                this.sendQuery(q);
            }
            catch (MorphiumDriverException morphiumDriverException) {
                this.log.error("Sending of message failed: ", morphiumDriverException);
                return null;
            }
            try {
                OpReply morphiumDriverException = this.waitForReply(db, coll, query, q.getReqId());
            }
            catch (MorphiumDriverException morphiumDriverException) {
                // empty catch block
            }
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public List<Map<String, Object>> aggregate(String db, String collection, List<Map<String, Object>> pipeline, boolean explain, boolean allowDiskUse, ReadPreference readPreference) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            OpQuery q = new OpQuery();
            q.setDb(db);
            q.setColl("$cmd");
            q.setReqId(this.getNextId());
            q.setSkip(0);
            q.setLimit(1);
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            doc.put("aggregate", collection);
            doc.put("pipeline", pipeline);
            doc.put("explain", explain);
            doc.put("allowDiskUse", allowDiskUse);
            q.setDoc(doc);
            this.sendQuery(q);
            List<Map<String, Object>> lst = this.readBatches(q.getReqId(), db, collection, this.getMaxWriteBatchSize());
            return Utils.getMap("result", lst);
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries()).get("result");
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.getCollectionInfo(db, coll);
        try {
            if (!lst.isEmpty() && lst.get(0).get("name").equals(coll)) {
                Object capped = ((Map)lst.get(0).get("options")).get("capped");
                return capped != null && capped.equals(true);
            }
        }
        catch (Exception e) {
            this.log.error(e);
        }
        return false;
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, String db, String collection, boolean ordered, WriteConcern wc) {
        return null;
    }

    @Override
    public void createIndex(String db, String collection, Map<String, Object> index, Map<String, Object> options) throws MorphiumDriverException {
        new NetworkCallHelper().doCall(() -> {
            LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
            cmd.put("createIndexes", collection);
            ArrayList lst = new ArrayList();
            HashMap<String, Object> idx = new HashMap<String, Object>();
            idx.put("key", index);
            StringBuilder stringBuilder = new StringBuilder();
            for (String k : index.keySet()) {
                stringBuilder.append(k);
                stringBuilder.append("-");
                stringBuilder.append(index.get(k));
            }
            idx.put("name", "idx_" + stringBuilder.toString());
            if (options != null) {
                idx.putAll(options);
            }
            lst.add(idx);
            cmd.put("indexes", lst);
            this.runCommand(db, cmd);
            return null;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }
}

