/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.meta;

import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.Utils;
import de.caluga.morphium.constants.RunCommand;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.singleconnect.BulkContext;
import de.caluga.morphium.driver.singleconnect.DriverBase;
import de.caluga.morphium.driver.singleconnect.SingleConnectCursor;
import de.caluga.morphium.driver.singleconnect.SingleConnectThreaddedDriver;
import de.caluga.morphium.driver.wireprotocol.OpQuery;
import de.caluga.morphium.driver.wireprotocol.OpReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class MetaDriver
extends DriverBase {
    private static final ReadPreference primary = ReadPreference.primary();
    private static final ReadPreference secondaryPreferred = ReadPreference.secondaryPreferred();
    private static final ReadPreference primaryPreferred = ReadPreference.primaryPreferred();
    private static volatile long seq;
    private final Logger log = new Logger(MetaDriver.class);
    private final Map<String, List<Connection>> connectionPool = new ConcurrentHashMap<String, List<Connection>>();
    private final Map<String, List<Connection>> connectionsInUse = new ConcurrentHashMap<String, List<Connection>>();
    private final List<String> secondaries = Collections.synchronizedList(new ArrayList());
    private final List<String> arbiters = Collections.synchronizedList(new ArrayList());
    private final List<String> tempBlockedHosts = Collections.synchronizedList(new ArrayList());
    private final Map<String, Integer> errorCountByHost = new ConcurrentHashMap<String, Integer>();
    private String currentMaster;
    private long fastestAnswer = 10000000L;
    private String fastestHost = null;
    private boolean connected = false;
    private long fastestHostTimestamp = System.currentTimeMillis();

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    @Override
    public void connect(String replicasetName) throws MorphiumDriverException {
        this.connected = true;
        for (String h : this.getHostSeed()) {
            this.createConnectionsForPool(h);
        }
        new Thread(){

            @Override
            public void run() {
                this.setName("MetaDriver-housekeeping");
                while (MetaDriver.this.isConnected()) {
                    String sec;
                    int i;
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (i = MetaDriver.this.secondaries.size() - 1; i >= 0; --i) {
                        MetaDriver.this.errorCountByHost.putIfAbsent(MetaDriver.this.secondaries.get(i), 0);
                        if ((Integer)MetaDriver.this.errorCountByHost.get(MetaDriver.this.secondaries.get(i)) > 10) {
                            sec = (String)MetaDriver.this.secondaries.remove(i);
                            MetaDriver.this.tempBlockedHosts.add(sec);
                            continue;
                        }
                        MetaDriver.this.decErrorCount((String)MetaDriver.this.secondaries.get(i));
                    }
                    for (i = 0; i < MetaDriver.this.tempBlockedHosts.size(); ++i) {
                        if ((Integer)MetaDriver.this.errorCountByHost.get(MetaDriver.this.tempBlockedHosts.get(i)) == 0) {
                            sec = (String)MetaDriver.this.tempBlockedHosts.remove(i);
                            MetaDriver.this.secondaries.add(sec);
                            continue;
                        }
                        MetaDriver.this.decErrorCount((String)MetaDriver.this.tempBlockedHosts.get(i));
                    }
                    for (String h : MetaDriver.this.getHostSeed()) {
                        if (MetaDriver.this.arbiters.contains(h)) continue;
                        for (int i2 = MetaDriver.this.getTotalConnectionsForHost(h); i2 < MetaDriver.this.getMinConnectionsPerHost() && MetaDriver.this.connected; ++i2) {
                            try {
                                DriverBase d = MetaDriver.this.createAndConnectDriver(h);
                                MetaDriver.this.getConnections(h).add(new Connection(d));
                                continue;
                            }
                            catch (MorphiumDriverException e) {
                                MetaDriver.this.log.error("Could not connect to host " + h, e);
                            }
                        }
                    }
                    MetaDriver.this.log.debug("total connections: " + MetaDriver.this.getTotalConnectionCount() + " / " + MetaDriver.this.getMaxConnectionsPerHost() * MetaDriver.this.connectionPool.size());
                    for (String s : MetaDriver.this.connectionPool.keySet()) {
                        int inUse = 0;
                        if (MetaDriver.this.connectionsInUse.get(s) != null) {
                            inUse = ((List)MetaDriver.this.connectionsInUse.get(s)).size();
                        }
                        MetaDriver.this.log.debug("  Host: " + s + "   " + MetaDriver.this.getTotalConnectionsForHost(s) + " / " + MetaDriver.this.getMaxConnectionsPerHost() + "   in Use: " + inUse);
                    }
                    MetaDriver.this.log.debug("Fastest host: " + MetaDriver.this.fastestHost + " with " + MetaDriver.this.fastestAnswer + "ms");
                    MetaDriver.this.log.debug("current master: " + MetaDriver.this.currentMaster);
                }
                MetaDriver.this.log.debug("Metadriver killed - terminating housekeeping thread");
            }
        }.start();
        this.connected = true;
        Thread t = new Thread(){

            @Override
            public void run() {
                while (MetaDriver.this.connected) {
                    try {
                        for (String host : MetaDriver.this.connectionPool.keySet()) {
                            for (int i = 0; i < ((List)MetaDriver.this.connectionPool.get(host)).size() && i <= ((List)MetaDriver.this.connectionPool.get(host)).size(); ++i) {
                                Connection c = (Connection)((List)MetaDriver.this.connectionPool.get(host)).get(i);
                                this.housekeep(c);
                                if (MetaDriver.this.connectionsInUse.get(c.getHost()) != null) {
                                    ((List)MetaDriver.this.connectionsInUse.get(c.getHost())).remove(c);
                                }
                                if (MetaDriver.this.connectionPool.get(c.getHost()) == null) continue;
                                ((List)MetaDriver.this.connectionPool.get(c.getHost())).remove(c);
                            }
                        }
                    }
                    catch (Exception e) {
                        MetaDriver.this.log.error("Exception during houskeeping", e);
                    }
                    try {
                        2.sleep(MetaDriver.this.getHeartbeatFrequency());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public void housekeep(Connection c) {
                block41: {
                    if (c.getD() == null) {
                        return;
                    }
                    if (!c.getD().isConnected()) {
                        MetaDriver.this.log.error("Not connected!!!!");
                        return;
                    }
                    try {
                        Map<String, Object> reply;
                        if (!c.inUse && System.currentTimeMillis() - c.created > (long)MetaDriver.this.getMaxConnectionLifetime()) {
                            ((List)MetaDriver.this.connectionPool.get(c.getHost())).remove(c);
                            if (c.inUse) {
                                return;
                            }
                            MetaDriver.this.log.debug("Maximum life time reached, killing myself");
                            try {
                                c.close();
                            }
                            catch (MorphiumDriverException morphiumDriverException) {
                                // empty catch block
                            }
                            return;
                        }
                        if (!c.inUse && System.currentTimeMillis() - c.lru > (long)MetaDriver.this.getMaxConnectionIdleTime() && ((List)MetaDriver.this.connectionPool.get(c.getHost())).size() > MetaDriver.this.getMinConnectionsPerHost()) {
                            ((List)MetaDriver.this.connectionPool.get(c.getHost())).remove(c);
                            if (c.inUse) {
                                return;
                            }
                            try {
                                c.close();
                            }
                            catch (MorphiumDriverException morphiumDriverException) {
                                // empty catch block
                            }
                            return;
                        }
                        try {
                            c.answerTime = 99999L;
                            long start = System.currentTimeMillis();
                            reply = c.getD().runCommand(RunCommand.Command.local.name(), Utils.getMap(RunCommand.Response.ismaster.name(), true));
                            c.answerTime = System.currentTimeMillis() - start;
                            MetaDriver.this.setReplicaSet(c.getFromReply(reply, RunCommand.Response.setName) != null && c.getFromReply(reply, RunCommand.Response.primary) != null);
                        }
                        catch (MorphiumDriverException e) {
                            if (e.getMongoCode() != null && e.getMongoCode().toString().equals(RunCommand.ErrorCode.UNABLE_TO_CONNECT.getCode())) {
                                c.ok = true;
                                return;
                            }
                            MetaDriver.this.log.error("Error with connection - exiting", e);
                            c.ok = false;
                            try {
                                c.close();
                            }
                            catch (MorphiumDriverException morphiumDriverException) {
                                // empty catch block
                            }
                            return;
                        }
                        if (!c.arbiter && c.getFromReply(reply, RunCommand.Response.arbiterOnly) != null && c.getFromReply(reply, RunCommand.Response.arbiterOnly).equals(true)) {
                            if (!MetaDriver.this.arbiters.contains(c.getHost())) {
                                MetaDriver.this.arbiters.add(c.getHost());
                            }
                            if (MetaDriver.this.secondaries.contains(c.getHost())) {
                                MetaDriver.this.secondaries.remove(c.getHost());
                            }
                            c.arbiter = true;
                        }
                        if (!c.arbiter && c.getFromReply(reply, RunCommand.Response.ismaster).equals(true)) {
                            c.master = true;
                            MetaDriver.this.currentMaster = c.getHost();
                        } else if (!c.arbiter && c.getFromReply(reply, RunCommand.Response.secondary).equals(true)) {
                            c.master = false;
                            if (MetaDriver.this.currentMaster == null) {
                                MetaDriver.this.currentMaster = (String)c.getFromReply(reply, RunCommand.Response.primary);
                            }
                            if (MetaDriver.this.currentMaster == null) {
                                MetaDriver.this.log.error("No master in replicaset!");
                            }
                            if (!MetaDriver.this.secondaries.contains(c.getHost()) && !MetaDriver.this.tempBlockedHosts.contains(c.getHost())) {
                                MetaDriver.this.secondaries.add(c.getHost());
                            }
                        } else {
                            c.master = false;
                            if (MetaDriver.this.currentMaster == null) {
                                MetaDriver.this.currentMaster = (String)c.getFromReply(reply, RunCommand.Response.primary);
                            }
                        }
                        if (MetaDriver.this.isReplicaset()) {
                            if (c.getFromReply(reply, RunCommand.Response.secondary).equals(false) && c.getFromReply(reply, RunCommand.Response.ismaster).equals(false)) {
                                MetaDriver.this.secondaries.remove(c.getHost());
                            } else {
                                if (!c.arbiter && (MetaDriver.this.fastestAnswer > c.answerTime || c.getD().getHostSeed()[0].equals(MetaDriver.this.fastestHost))) {
                                    long timeout;
                                    long tm = System.currentTimeMillis() - MetaDriver.this.fastestHostTimestamp;
                                    if (tm < (timeout = (long)(2000.0 * Math.random() + 100.0))) {
                                        MetaDriver.this.fastestAnswer = c.answerTime;
                                        MetaDriver.this.fastestHost = c.getD().getHostSeed()[0];
                                        MetaDriver.this.fastestHostTimestamp = System.currentTimeMillis();
                                    } else if (tm > timeout && MetaDriver.this.fastestHost != null && MetaDriver.this.fastestHost.equals(c.getHost())) {
                                        MetaDriver.this.fastestHost = null;
                                        MetaDriver.this.fastestAnswer = 99999999L;
                                    }
                                }
                                if (c.getFromReply(reply, RunCommand.Response.hosts) != null && MetaDriver.this.secondaries.isEmpty()) {
                                    Vector s = new Vector((List)c.getFromReply(reply, RunCommand.Response.hosts));
                                    for (int i = 0; i < s.size(); ++i) {
                                        String hn = (String)s.get(i);
                                        String adr = MetaDriver.this.getHostAdress(hn);
                                        MetaDriver.this.secondaries.add(adr);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        MetaDriver.this.log.error("Connection broken!" + c.getD().getHostSeed()[0], e);
                        try {
                            c.getD().close();
                        }
                        catch (MorphiumDriverException morphiumDriverException) {
                            // empty catch block
                        }
                        try {
                            MetaDriver.this.getConnections(c.getD().getHostSeed()[0]).remove(c);
                            ((List)MetaDriver.this.connectionsInUse.get(c.getD().getHostSeed()[0])).remove(c);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!c.getD().getHostSeed()[0].equals(MetaDriver.this.fastestHost)) break block41;
                        MetaDriver.this.fastestHost = null;
                        MetaDriver.this.fastestAnswer = 1000000L;
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
        while (this.currentMaster == null) {
            this.log.debug("Waiting for master...");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (this.connectionPool.get(this.currentMaster) == null || this.getTotalConnectionsForHost(this.currentMaster) < this.getMinConnectionsPerHost()) {
            this.log.debug("no connection to current master yet! Retrying...");
            try {
                DriverBase d = this.createAndConnectDriver(this.currentMaster);
                this.getConnections(this.currentMaster).add(new Connection(d));
            }
            catch (MorphiumDriverException e) {
                this.log.error("Could not connect to master " + this.currentMaster, e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (this.getHostSeed().length < this.secondaries.size()) {
            this.log.debug("There are more nodes in replicaset than defined in seed...");
            for (int i = 0; i < this.secondaries.size(); ++i) {
                String h = this.secondaries.get(i);
                if (!this.getConnections(h).isEmpty()) continue;
                try {
                    this.createConnectionsForPool(h);
                    continue;
                }
                catch (Exception e) {
                    this.log.info("Exception during creation of connection for pool", e);
                }
            }
        } else if (this.getHostSeed().length > this.secondaries.size()) {
            this.log.info("some seed hosts were not reachable!");
        }
        if (this.connectionPool.isEmpty()) {
            throw new MorphiumDriverException("Could not connect");
        }
        if (this.getTotalConnectionCount() == 0) {
            throw new MorphiumDriverException("Connection failed!");
        }
        this.connected = true;
    }

    private int getTotalConnectionsForHost(String h) {
        int inUse = this.getConnectionsInUse(h) == null ? 0 : this.getConnectionsInUse(h).size();
        int avail = this.getConnections(h) == null ? 0 : this.getConnections(h).size();
        return inUse + avail;
    }

    private void createConnectionsForPool(String h) {
        for (int i = this.getTotalConnectionsForHost(h); i < this.getMinConnectionsPerHost(); ++i) {
            try {
                DriverBase d = this.createAndConnectDriver(h);
                this.getConnections(h).add(new Connection(d));
                continue;
            }
            catch (MorphiumDriverException e) {
                this.log.error("Could not connect to host " + h, e);
            }
        }
    }

    private int getTotalConnectionCount() {
        int c = 0;
        for (String k : this.connectionPool.keySet()) {
            c += this.connectionPool.get(k).size();
        }
        for (String k : this.connectionsInUse.keySet()) {
            c += this.connectionsInUse.get(k).size();
        }
        return c;
    }

    private List<Connection> getConnectionsInUse(String h) {
        this.connectionsInUse.putIfAbsent(h, Collections.synchronizedList(new ArrayList()));
        return this.connectionsInUse.get(h);
    }

    private List<Connection> getConnections(String h) {
        this.connectionPool.putIfAbsent(h, Collections.synchronizedList(new ArrayList()));
        return this.connectionPool.get(h);
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.getTotalConnectionCount() != 0;
    }

    @Override
    public void close() throws MorphiumDriverException {
        this.connected = false;
        this.closeConnections(this.connectionPool);
        this.closeConnections(this.connectionsInUse);
        while (this.getTotalConnectionCount() > 0) {
            this.log.error("Still connected?!?!? " + this.getTotalConnectionCount());
            this.close();
        }
    }

    private void closeConnections(Map<String, List<Connection>> pool) {
        for (String h : pool.keySet()) {
            while (!pool.get(h).isEmpty()) {
                try {
                    Connection c = pool.get(h).remove(0);
                    c.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            Map<String, Object> map = c.getD().getReplsetStatus();
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            Map<String, Object> map = c.getD().getDBStats(db);
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public Map<String, Object> getOps(long threshold) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            Map<String, Object> map = c.getD().getOps(threshold);
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public Map<String, Object> runCommand(String db, Map<String, Object> cmd) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            Map<String, Object> map = c.getD().runCommand(db, cmd);
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Map<String, Object> findMetaData) throws MorphiumDriverException {
        Connection c = this.getConnection(readPreference);
        return c.getD().initIteration(db, collection, query, sort, projection, skip, limit, batchSize, readPreference, findMetaData);
    }

    @Override
    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        SingleConnectCursor c = (SingleConnectCursor)crs.getInternalCursorObject();
        return c.getDriver().nextIteration(crs);
    }

    @Override
    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        SingleConnectCursor internalCursor = (SingleConnectCursor)crs.getInternalCursorObject();
        internalCursor.getDriver().closeIteration(crs);
        for (String srv : this.connectionsInUse.keySet()) {
            for (Connection c : this.connectionsInUse.get(srv)) {
                if (!c.getD().equals(internalCursor.getDriver())) continue;
                this.freeConnection(c);
                return;
            }
        }
        throw new MorphiumDriverException("Could not free connection - not in use or closed");
    }

    @Override
    public List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference rp, Map<String, Object> findMetaData) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(rp);
            List<Map<String, Object>> list = c.getD().find(db, collection, query, sort, projection, skip, limit, batchSize, rp, findMetaData);
            return list;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public long count(String db, String collection, Map<String, Object> query, ReadPreference rp) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(rp);
            long l = c.getD().count(db, collection, query, rp);
            return l;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public void insert(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            c.getD().insert(db, collection, objs, wc);
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public void store(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            c.getD().store(db, collection, objs, wc);
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public Map<String, Object> update(String db, String collection, List<Map<String, Object>> updateCommand, boolean ordered, WriteConcern wc) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            Map<String, Object> map = ((DriverBase)c.getD()).update(db, collection, updateCommand, ordered, wc);
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> op, boolean multiple, boolean upsert, WriteConcern wc) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            Map<String, Object> map = c.getD().update(db, collection, query, op, multiple, upsert, wc);
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public Map<String, Object> delete(String db, String collection, Map<String, Object> query, boolean multiple, WriteConcern wc) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            Map<String, Object> map = c.getD().delete(db, collection, query, multiple, wc);
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public void drop(String db, String collection, WriteConcern wc) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            c.getD().drop(db, collection, wc);
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public void drop(String db, WriteConcern wc) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            c.getD().drop(db, wc);
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public boolean exists(String db) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            boolean bl = c.getD().exists(db);
            return bl;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, ReadPreference rp) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            List<Object> list = c.getD().distinct(db, collection, field, filter, rp);
            return list;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public boolean exists(String db, String collection) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            boolean bl = c.getD().exists(db, collection);
            return bl;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public List<Map<String, Object>> getIndexes(String db, String collection) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            List<Map<String, Object>> list = c.getD().getIndexes(db, collection);
            return list;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public List<String> getCollectionNames(String db) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            List<String> list = c.getD().getCollectionNames(db);
            return list;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public Map<String, Object> group(String db, String coll, Map<String, Object> query, Map<String, Object> initial, String jsReduce, String jsFinalize, ReadPreference rp, String ... keys) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(rp);
            Map<String, Object> map = c.getD().group(db, coll, query, initial, jsReduce, jsFinalize, rp, keys);
            return map;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(readPreference);
            c.getD().tailableIteration(db, collection, query, sort, projection, skip, limit, batchSize, readPreference, timeout, cb);
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public List<Map<String, Object>> aggregate(String db, String collection, List<Map<String, Object>> pipeline, boolean explain, boolean allowDiskUse, ReadPreference readPreference) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(readPreference);
            List<Map<String, Object>> list = c.getD().aggregate(db, collection, pipeline, explain, allowDiskUse, readPreference);
            return list;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primaryPreferred);
            boolean bl = c.getD().isCapped(db, coll);
            return bl;
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, String db, String collection, boolean ordered, WriteConcern wc) {
        return new BulkContext(m, db, collection, this, ordered, this.getMaxWriteBatchSize(), wc);
    }

    @Override
    public void createIndex(String db, String collection, Map<String, Object> index, Map<String, Object> options) throws MorphiumDriverException {
        Connection c = null;
        try {
            c = this.getConnection(primary);
            c.getD().createIndex(db, collection, index, options);
        }
        catch (MorphiumDriverNetworkException ex) {
            if (c != null) {
                this.incErrorCount(c.getHost());
            }
            throw ex;
        }
        finally {
            this.freeConnection(c);
        }
    }

    private DriverBase createAndConnectDriver(String host) throws MorphiumDriverException {
        SingleConnectThreaddedDriver d = new SingleConnectThreaddedDriver();
        d.setHostSeed(host);
        d.setSocketKeepAlive(this.isSocketKeepAlive());
        d.setSocketTimeout(this.getSocketTimeout());
        d.setConnectionTimeout(this.getConnectionTimeout());
        d.setDefaultWriteTimeout(this.getDefaultWriteTimeout());
        d.setSleepBetweenErrorRetries(this.getSleepBetweenErrorRetries());
        d.setRetriesOnNetworkError(this.getRetriesOnNetworkError());
        d.setLocalThreshold(this.getLocalThreshold());
        d.setMaxWaitTime(this.getMaxWaitTime());
        d.setReplicaSetName(this.getReplicaSetName());
        d.setDefaultW(this.getDefaultW());
        d.setDefaultReadPreference(this.getDefaultReadPreference());
        if (!this.connected) {
            return null;
        }
        d.connect(this.getReplicaSetName());
        d.setSlaveOk(true);
        return d;
    }

    private Connection getConnection(String host) throws MorphiumDriverException {
        Connection c;
        long start = System.currentTimeMillis();
        block6: while (true) {
            try {
                if (!this.getConnections(host).isEmpty()) {
                    c = this.getConnections(host).remove(0);
                    if (c != null) break;
                    this.log.fatal("H\u00e4? could not get connection from pool");
                }
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.getConnections(host).isEmpty() && this.getTotalConnectionsForHost(host) < this.getMaxConnectionsPerHost()) {
                c = new Connection(this.createAndConnectDriver(host));
                break;
            }
            while (true) {
                if (!this.getConnections(host).isEmpty() || this.getTotalConnectionsForHost(host) < this.getMaxConnectionsPerHost()) continue block6;
                if (System.currentTimeMillis() - start > (long)this.getMaxWaitTime()) {
                    throw new MorphiumDriverNetworkException("could not get Connection! Waited >" + this.getMaxWaitTime() + "ms");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            break;
        }
        c.setInUse(true);
        c.touch();
        this.getConnectionsInUse(host).add(c);
        return c;
    }

    private Connection getSecondaryConnection() throws MorphiumDriverException {
        String least = null;
        int min = 9999;
        for (String h : this.secondaries) {
            if (this.connectionsInUse.get(h) == null) {
                min = 0;
                least = h;
                continue;
            }
            if (this.connectionsInUse.get(h).size() >= min) continue;
            least = h;
            min = this.connectionPool.get(h).size();
        }
        return this.getConnection(least);
    }

    private Connection getConnection(ReadPreference rp) throws MorphiumDriverException {
        if (rp == null) {
            rp = secondaryPreferred;
        }
        switch (rp.getType()) {
            case PRIMARY: {
                return this.getMasterConnection();
            }
            case PRIMARY_PREFERRED: {
                try {
                    return this.getMasterConnection();
                }
                catch (Exception e) {
                    this.log.warn("could not get master connection...", e);
                }
            }
            case NEAREST: {
                if (this.fastestHost != null) {
                    return this.getConnection(this.fastestHost);
                }
            }
            case SECONDARY: {
                return this.getSecondaryConnection();
            }
            case SECONDARY_PREFERRED: {
                try {
                    return this.getSecondaryConnection();
                }
                catch (Exception e) {
                    return this.getMasterConnection();
                }
            }
        }
        this.log.fatal("Unknown read preference type! returning master!");
        return this.getMasterConnection();
    }

    private Connection getMasterConnection() throws MorphiumDriverException {
        long start = System.currentTimeMillis();
        while (this.currentMaster == null) {
            if (System.currentTimeMillis() - start > (long)this.getMaxWaitTime()) {
                throw new MorphiumDriverNetworkException("could not get Master!");
            }
            Thread.yield();
        }
        return this.getConnection(this.currentMaster);
    }

    private void freeConnection(Connection c) {
        if (c == null) {
            return;
        }
        this.getConnectionsInUse(c.getHost()).remove(c);
        c.setInUse(false);
        this.getConnections(c.getHost()).add(c);
    }

    private void incErrorCount(String host) {
        if (this.errorCountByHost.get(host) == null) {
            this.errorCountByHost.put(host, 1);
        } else {
            this.errorCountByHost.put(host, this.errorCountByHost.get(host) + 1);
        }
    }

    private void decErrorCount(String host) {
        if (this.errorCountByHost.get(host) == null) {
            this.errorCountByHost.put(host, 0);
        } else {
            this.errorCountByHost.put(host, this.errorCountByHost.get(host) - 1);
        }
    }

    @Override
    protected void sendQuery(OpQuery q) throws MorphiumDriverException {
    }

    @Override
    protected OpReply getReply(long waitingFor, int timeout) throws MorphiumDriverException {
        return null;
    }

    private class Connection {
        private DriverBase d;
        private long created;
        private long lru;
        private long id;
        private long optime;
        private boolean inUse = false;
        private boolean master = false;
        private boolean ok = true;
        private long answerTime;
        private boolean arbiter = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection(DriverBase dr) throws MorphiumDriverException {
            if (dr == null) {
                throw new IllegalArgumentException("Cannot create connection to null");
            }
            this.d = dr;
            this.created = this.lru = System.currentTimeMillis();
            Class<Connection> clazz = Connection.class;
            synchronized (Connection.class) {
                this.id = ++seq;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private Object getFromReply(Map<String, Object> reply, RunCommand.Response response) {
            return reply.get(response.name());
        }

        public String getHost() {
            return this.d.getHostSeed()[0];
        }

        public void close() throws MorphiumDriverException {
            this.d.close();
        }

        public boolean isOk() {
            return this.ok;
        }

        public boolean isMaster() {
            return this.master;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public void setInUse(boolean inUse) {
            if (inUse && this.inUse) {
                throw new ConcurrentModificationException("Already in use!");
            }
            this.inUse = inUse;
        }

        public MorphiumDriver getD() {
            return this.d;
        }

        public void setD(DriverBase d) {
            this.d = d;
        }

        public long getCreated() {
            return this.created;
        }

        public void setCreated(long created) {
            this.created = created;
        }

        public long getLru() {
            return this.lru;
        }

        public void setLru(long lru) {
            this.lru = lru;
        }

        public long getOptime() {
            return this.optime;
        }

        public void setOptime(long optime) {
            this.optime = optime;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Connection that = (Connection)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        public void touch() {
            this.lru = System.currentTimeMillis();
        }
    }
}

