/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RSMonitor {
    private static final Logger logger = new Logger(RSMonitor.class);
    private final ScheduledThreadPoolExecutor executorService;
    private final Morphium morphium;
    private ReplicaSetStatus currentStatus;
    private int nullcounter = 0;

    public RSMonitor(Morphium morphium) {
        this.morphium = morphium;
        this.executorService = new ScheduledThreadPoolExecutor(1);
        this.executorService.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread ret = new Thread(r, "rsMonitor " + this.num);
                this.num.set(this.num.get() + 1);
                ret.setDaemon(true);
                return ret;
            }
        });
    }

    public void start() {
        this.execute();
        this.executorService.scheduleWithFixedDelay(this::execute, 1000L, this.morphium.getConfig().getReplicaSetMonitoringTimeout(), TimeUnit.MILLISECONDS);
    }

    public void terminate() {
        this.executorService.shutdownNow();
    }

    public void execute() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Getting RS-Status...");
            }
            this.currentStatus = this.getReplicaSetStatus(true);
            if (this.currentStatus == null) {
                ++this.nullcounter;
                if (logger.isDebugEnabled()) {
                    logger.debug("RS status is null! Counter " + this.nullcounter);
                }
            } else {
                this.nullcounter = 0;
            }
            if (this.nullcounter > 10) {
                logger.error("Getting ReplicasetStatus failed 10 times... will gracefully exit thread");
                this.executorService.shutdownNow();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReplicaSetStatus getReplicaSetStatus(boolean full) {
        if (this.morphium.isReplicaSet()) {
            try {
                Map<String, Object> res = this.morphium.getDriver().getReplsetStatus();
                ReplicaSetStatus status = this.morphium.getMapper().unmarshall(ReplicaSetStatus.class, res);
                if (full) {
                    HashMap<String, Object> findMetaData = new HashMap<String, Object>();
                    List<Map<String, Object>> stats = this.morphium.getDriver().find("local", "system.replset", new HashMap<String, Object>(), null, null, 0, 10, 10, null, findMetaData);
                    if (stats == null || stats.isEmpty()) {
                        logger.debug("could not get replicaset status");
                    } else {
                        Map<String, Object> stat = stats.get(0);
                        ReplicaSetConf cfg = this.morphium.getMapper().unmarshall(ReplicaSetConf.class, stat);
                        List mem = cfg.getMemberList();
                        ArrayList<ConfNode> cmembers = new ArrayList<ConfNode>();
                        for (Object o : mem) {
                            ConfNode cn = (ConfNode)o;
                            cmembers.add(cn);
                        }
                        cfg.setMembers(cmembers);
                        status.setConfig(cfg);
                    }
                }
                List<ReplicaSetNode> lst = status.getMembers();
                ArrayList<ReplicaSetNode> members = new ArrayList<ReplicaSetNode>();
                if (lst != null) {
                    Iterator<ReplicaSetNode> iterator = lst.iterator();
                    while (iterator.hasNext()) {
                        ReplicaSetNode l;
                        ReplicaSetNode n = l = iterator.next();
                        members.add(n);
                    }
                }
                status.setMembers(members);
                return status;
            }
            catch (Exception e) {
                logger.warn("Could not get Replicaset status: " + e.getMessage(), e);
                logger.warn("Tried connection to: ");
                for (String adr : this.morphium.getConfig().getHostSeed()) {
                    logger.warn("   " + adr);
                }
            }
        }
        return null;
    }

    public ReplicaSetStatus getCurrentStatus() {
        return this.currentStatus;
    }
}

