/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.Logger;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultMorphiumIterator<T>
implements MorphiumIterator<T> {
    private final Logger log = new Logger(DefaultMorphiumIterator.class);
    private int windowSize = 1;
    private Query<T> theQuery;
    private List<T> buffer;
    private int cursor = 0;
    private long count = 0L;
    private Map<String, Object> lastValues = new HashMap<String, Object>();
    private long limit;

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return (long)this.cursor < this.count && (long)this.cursor < this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        if (this.isMultithreaddedAccess()) {
            DefaultMorphiumIterator defaultMorphiumIterator = this;
            synchronized (defaultMorphiumIterator) {
                return this.donext();
            }
        }
        return this.donext();
    }

    private T donext() {
        if ((long)this.cursor > this.count || (long)this.cursor > this.limit) {
            return null;
        }
        int idx = this.cursor % this.windowSize;
        if (this.buffer == null || idx == 0) {
            if (this.theQuery.getSort() == null || this.theQuery.getSort().isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No sort parameter given - sorting by _id");
                }
                this.theQuery.sort("_id");
            }
            Query<T> q = this.getLimitedQuery(this.theQuery);
            if (this.count - (long)this.cursor < (long)this.windowSize) {
                q.limit((int)(this.count - (long)this.cursor));
            } else if (this.limit - (long)this.cursor < (long)this.windowSize) {
                q.limit((int)(this.limit - (long)this.cursor));
            } else {
                q.limit(this.windowSize);
            }
            this.buffer = q.asList();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reached window boundary - read in: " + this.buffer.size() + " limit:" + this.windowSize + " pos: " + this.cursor);
            }
            if (this.buffer == null || this.buffer.isEmpty()) {
                this.log.fatal("Buffer is empty!?!?!?! cursor: " + this.cursor + " cnt: " + this.count + " window: " + this.windowSize + " query: " + q.toQueryObject().toString());
            } else {
                this.updateLastValues(q, this.buffer);
            }
        }
        if (this.buffer != null) {
            ++this.cursor;
            if (idx >= this.buffer.size()) {
                this.log.debug("Trying to read past end of buffer - automatic deletion?");
                return null;
            }
            return this.buffer.get(idx);
        }
        return null;
    }

    private void updateLastValues(Query<T> q, List<T> buffer) {
        try {
            Map<String, Integer> sort = q.getSort();
            for (Map.Entry<String, Integer> e : sort.entrySet()) {
                this.lastValues.put(e.getKey(), q.getMorphium().getARHelper().getValue(buffer.get(buffer.size() - 1), e.getKey()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Query<T> getLimitedQuery(Query<T> q) {
        try {
            Map<String, Integer> sort = q.getSort();
            Query<T> ret = q.clone();
            for (Map.Entry<String, Integer> e : sort.entrySet()) {
                if (this.lastValues.get(e.getKey()) == null) continue;
                if (e.getValue().equals(-1)) {
                    ret.f(e.getKey()).lt(this.lastValues.get(e.getKey()));
                    continue;
                }
                ret.f(e.getKey()).gt(this.lastValues.get(e.getKey()));
            }
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not possible on MorphiumIterators");
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setWindowSize(int sz) {
        this.windowSize = sz;
    }

    @Override
    public Query<T> getQuery() {
        return this.theQuery;
    }

    @Override
    public void setQuery(Query<T> q) {
        try {
            this.theQuery = q.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.count = this.theQuery.countAll();
        this.limit = this.theQuery.getLimit();
        if (this.limit <= 0L) {
            this.limit = this.count;
        }
    }

    @Override
    public int getCurrentBufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.size();
    }

    @Override
    public List<T> getCurrentBuffer() {
        return this.buffer;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public void ahead(int jump) {
        for (int i = 0; i < jump && this.hasNext(); ++i) {
            this.next();
        }
    }

    @Override
    public void back(int jump) {
        int newCursor = this.cursor - jump;
        this.lastValues.clear();
        this.cursor = 0;
        this.buffer = null;
        if (newCursor < 0) {
            return;
        }
        for (int i = 0; i < newCursor && this.hasNext(); ++i) {
            this.next();
        }
    }

    @Override
    public void setNumberOfPrefetchWindows(int n) {
        throw new IllegalArgumentException("prefetch not possible in Default iterator");
    }

    @Override
    public int getNumberOfAvailableThreads() {
        return 1;
    }

    @Override
    public int getNumberOfThreads() {
        return 1;
    }

    @Override
    public boolean isMultithreaddedAccess() {
        return this.lastValues instanceof ConcurrentHashMap;
    }

    @Override
    public void setMultithreaddedAccess(boolean mu) {
        this.lastValues = new ConcurrentHashMap<String, Object>(this.lastValues);
    }
}

