/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.singleconnect;

import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.mongodb.Maximums;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class DriverBase
implements MorphiumDriver {
    private volatile int rqid = 10000;
    private int maxWait = 1000;
    private boolean keepAlive = true;
    private int soTimeout = 1000;
    private Map<String, Map<String, char[]>> credentials;
    private int maxBsonObjectSize;
    private int maxMessageSize = 0x1000000;
    private int maxWriteBatchSize = 1000;
    private ReadPreference defaultRP;
    private boolean replicaSet = false;
    private String replicaSetName = null;
    private int retriesOnNetworkError = 5;
    private int sleepBetweenRetries = 100;
    private boolean defaultJ = false;
    private int localThreshold = 0;
    private int heartbeatConnectionTimeout = 1000;
    private List<String> hostSeed;
    private int heartbeatSocketTimeout = 1000;
    private int heartbeatFrequency = 2000;
    private boolean useSSL = false;
    private int maxBlockingThreadsMultiplier = 5;
    private int defaultW = 1;
    private int connectionTimeout = 1000;
    private int maxConnectionIdleTime = 100000;
    private int maxConnectionLifetime = 600000;
    private int minConnectionsPerHost = 1;
    private int maxConnectionsPerHost = 100;
    private int defaultWriteTimeout = 10000;
    private boolean slaveOk = true;

    public boolean isSlaveOk() {
        return this.slaveOk;
    }

    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    @Override
    public void setCredentials(String db, String login, char[] pwd) {
        if (this.credentials == null) {
            this.credentials = new HashMap<String, Map<String, char[]>>();
        }
        HashMap<String, char[]> cred = new HashMap<String, char[]>();
        cred.put(login, pwd);
        this.credentials.put(db, cred);
    }

    @Override
    public boolean isReplicaset() {
        return this.replicaSet;
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public void setReplicaSetName(String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    public Map<String, Map<String, char[]>> getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(Map<String, String[]> credentials) {
    }

    @Override
    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    @Override
    public void setRetriesOnNetworkError(int r) {
        if (r < 1) {
            r = 1;
        }
        this.retriesOnNetworkError = r;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return this.sleepBetweenRetries;
    }

    @Override
    public void setSleepBetweenErrorRetries(int s) {
        if (s < 100) {
            s = 100;
        }
        this.sleepBetweenRetries = s;
    }

    public int getMaxBsonObjectSize() {
        return this.maxBsonObjectSize;
    }

    public void setMaxBsonObjectSize(int maxBsonObjectSize) {
        this.maxBsonObjectSize = maxBsonObjectSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxWriteBatchSize() {
        return this.maxWriteBatchSize;
    }

    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
        this.maxWriteBatchSize = maxWriteBatchSize;
    }

    public boolean isReplicaSet() {
        return this.replicaSet;
    }

    public void setReplicaSet(boolean replicaSet) {
        this.replicaSet = replicaSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        Class<DriverBase> clazz = DriverBase.class;
        synchronized (DriverBase.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ++this.rqid;
        }
    }

    @Override
    public int getDefaultWriteTimeout() {
        return this.defaultWriteTimeout;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
        this.defaultWriteTimeout = wt;
    }

    @Override
    public int getHeartbeatConnectTimeout() {
        return this.heartbeatConnectionTimeout;
    }

    @Override
    public void setHeartbeatConnectTimeout(int heartbeatConnectTimeout) {
        this.heartbeatConnectionTimeout = heartbeatConnectTimeout;
    }

    @Override
    public int getMaxWaitTime() {
        return this.maxWait;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWait = maxWaitTime;
    }

    @Override
    public boolean isSocketKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.keepAlive = socketKeepAlive;
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public boolean isDefaultFsync() {
        return false;
    }

    @Override
    public void setDefaultFsync(boolean j) {
    }

    @Override
    public String[] getHostSeed() {
        if (this.hostSeed == null) {
            return null;
        }
        return this.hostSeed.toArray(new String[this.hostSeed.size()]);
    }

    @Override
    public void setHostSeed(String ... host) {
        if (this.hostSeed == null) {
            this.hostSeed = new Vector<String>();
        }
        for (String h : host) {
            try {
                this.hostSeed.add(this.getHostAdress(h));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Could not add host", e);
            }
        }
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public void setMaxConnectionsPerHost(int mx) {
        this.maxConnectionsPerHost = mx;
    }

    @Override
    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Override
    public void setMinConnectionsPerHost(int mx) {
        this.minConnectionsPerHost = mx;
    }

    @Override
    public int getMaxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
        this.maxConnectionLifetime = timeout;
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
        this.maxConnectionIdleTime = time;
    }

    @Override
    public int getSocketTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setSocketTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public int getDefaultW() {
        return this.defaultW;
    }

    @Override
    public void setDefaultW(int w) {
        this.defaultW = w;
    }

    @Override
    public int getMaxBlockintThreadMultiplier() {
        return this.maxBlockingThreadsMultiplier;
    }

    @Override
    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
    }

    public abstract Map<String, Object> update(String var1, String var2, List<Map<String, Object>> var3, boolean var4, WriteConcern var5) throws MorphiumDriverException;

    @Override
    public Maximums getMaximums() {
        Maximums max = new Maximums();
        max.setMaxBsonSize(this.maxBsonObjectSize);
        max.setMaxMessageSize(this.maxMessageSize);
        max.setMaxWriteBatchSize(this.maxWriteBatchSize);
        return max;
    }

    public ReadPreference getDefaultReadPreference() {
        return this.defaultRP;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
        this.defaultRP = rp;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
    }

    @Override
    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    @Override
    public void setHeartbeatSocketTimeout(int heartbeatSocketTimeout) {
        this.heartbeatSocketTimeout = heartbeatSocketTimeout;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
    }

    @Override
    public boolean isDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public void setDefaultJ(boolean j) {
        this.defaultJ = j;
    }

    @Override
    public int getWriteTimeout() {
        return this.defaultWriteTimeout;
    }

    @Override
    public void setWriteTimeout(int writeTimeout) {
    }

    @Override
    public int getLocalThreshold() {
        return this.localThreshold;
    }

    @Override
    public void setLocalThreshold(int thr) {
        this.localThreshold = thr;
    }

    @Override
    public void setMaxBlockingThreadMultiplier(int m) {
        this.maxBlockingThreadsMultiplier = m;
    }

    @Override
    public void heartBeatFrequency(int t) {
        this.heartbeatFrequency = t;
    }

    @Override
    public void heartBeatSocketTimeout(int t) {
        this.heartbeatSocketTimeout = t;
    }

    @Override
    public void useSsl(boolean ssl) {
        this.useSSL = ssl;
    }

    public String getHostAdress(String hn) throws UnknownHostException {
        String[] hst = hn.split(":");
        String h = hst[0];
        int port = 27017;
        if (hst.length > 1) {
            port = Integer.valueOf(hst[1]);
        }
        InetAddress in = InetAddress.getByName(h);
        return in.getHostAddress() + ":" + port;
    }
}

