/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.bson;

import de.caluga.morphium.driver.bson.MongoBob;
import de.caluga.morphium.driver.bson.MongoJSScript;
import de.caluga.morphium.driver.bson.MongoMinKey;
import de.caluga.morphium.driver.bson.MorphiumId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BsonEncoder {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    public static byte[] encodeDocument(Map<String, Object> m) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            BsonEncoder enc = new BsonEncoder();
            enc.encodeObject(e.getKey(), e.getValue());
            try {
                o.write(enc.getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        for (int i = 3; i >= 0; --i) {
            o2.write((byte)(o.size() + 4 + 1 >> (7 - i) * 8 & 0xFF));
        }
        try {
            o2.write(o.toByteArray());
            o2.write(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return o2.toByteArray();
    }

    private BsonEncoder string(String s) {
        try {
            byte[] b = s.getBytes("UTF-8");
            this.writeInt(b.length + 1);
            this.writeBytes(b);
            this.out.write(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    private BsonEncoder cString(String s) {
        try {
            byte[] b = s.getBytes("UTF-8");
            this.writeBytes(b);
            this.out.write(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public byte[] getBytes() {
        return this.out.toByteArray();
    }

    private BsonEncoder encodeObject(String n, Object v) {
        if (v == null) {
            this.writeByte(10).cString(n);
        } else if (v instanceof Double) {
            this.writeByte(1).cString(n);
            long lng = Double.doubleToLongBits((Double)v);
            this.writeLong(lng);
        } else if (v instanceof String) {
            this.writeByte(2);
            this.cString(n);
            this.string((String)v);
        } else if (v instanceof List || List.class.isAssignableFrom(v.getClass()) || Collection.class.isAssignableFrom(v.getClass())) {
            this.writeByte(4);
            this.cString(n);
            HashMap<String, Object> doc = new HashMap<String, Object>();
            int cnt = 0;
            if (Collection.class.isAssignableFrom(v.getClass())) {
                ArrayList l = new ArrayList();
                l.addAll((Collection)v);
                v = l;
            }
            for (Object o : (List)v) {
                doc.put("" + cnt++, o);
            }
            this.writeBytes(BsonEncoder.encodeDocument(doc));
        } else if (v instanceof Map || Map.class.isAssignableFrom(v.getClass())) {
            this.writeByte(3);
            this.cString(n);
            byte[] b = BsonEncoder.encodeDocument((Map)v);
            this.writeBytes(b);
        } else if (v instanceof MongoBob) {
            this.writeByte(5);
            this.cString(n);
            MongoBob b = (MongoBob)v;
            byte[] data = b.getData();
            if (data == null) {
                data = new byte[]{};
            }
            this.writeInt(data.length);
            this.writeByte(0);
            this.writeBytes(data);
        } else if (MorphiumId.class.isAssignableFrom(v.getClass())) {
            this.writeByte(7);
            this.cString(n);
            this.writeBytes(((MorphiumId)v).getBytes());
        } else if (v.getClass().isAssignableFrom(Boolean.class)) {
            boolean b = (Boolean)v;
            this.writeByte(8);
            this.cString(n);
            if (b) {
                this.writeByte(1);
            } else {
                this.writeByte(0);
            }
        } else if (v.getClass().isAssignableFrom(Date.class)) {
            this.writeByte(9);
            this.cString(n);
            this.writeLong(((Date)v).getTime());
        } else if (v.getClass().isAssignableFrom(Calendar.class)) {
            this.writeByte(9);
            this.cString(n);
            this.writeLong(((Calendar)v).getTimeInMillis());
        } else if (v.getClass().isAssignableFrom(Pattern.class)) {
            Pattern p = (Pattern)v;
            String flags = "";
            int f = p.flags();
            if ((f & 8) != 0) {
                flags = flags + "m";
            } else if ((f & 2) != 0) {
                flags = flags + "i";
            } else if ((f & 0x20) != 0) {
                flags = flags + "s";
            }
            this.writeByte(11);
            this.cString(n);
            this.cString(p.pattern());
            this.cString(flags);
        } else if (v.getClass().isAssignableFrom(MongoJSScript.class)) {
            MongoJSScript s = (MongoJSScript)v;
            if (s.getContext() != null) {
                this.writeByte(15);
                byte[] b = BsonEncoder.encodeDocument(s.getContext());
                this.string(n);
                this.writeBytes(b);
            }
        } else if (v.getClass().isAssignableFrom(Integer.class)) {
            this.writeByte(16);
            this.cString(n);
            int val = (Integer)v;
            this.writeInt(val);
        } else if (v.getClass().isAssignableFrom(Long.class)) {
            this.writeByte(18);
            this.cString(n);
            long val = (Long)v;
            this.writeLong(val);
        } else if (v.getClass().isAssignableFrom(MongoMinKey.class)) {
            this.writeByte(255);
            this.cString(n);
        }
        return this;
    }

    private void writeBytes(byte[] data) {
        try {
            this.out.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeInt(int val) {
        for (int i = 3; i >= 0; --i) {
            this.writeByte((byte)(val >> (7 - i) * 8 & 0xFF));
        }
    }

    private void writeLong(long lng) {
        for (int i = 7; i >= 0; --i) {
            this.writeByte((byte)(lng >> (7 - i) * 8 & 0xFFL));
        }
    }

    private BsonEncoder writeByte(int v) {
        this.out.write((byte)v);
        return this;
    }
}

