/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.aggregation.Aggregator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Group<T, R> {
    private Aggregator<T, R> aggregator;
    private Map<String, Object> id;
    private List<Map<String, Object>> operators = new ArrayList<Map<String, Object>>();

    public Group(Aggregator<T, R> ag, String id) {
        this.aggregator = ag;
        this.id = this.getMap("_id", id);
    }

    public Group(Aggregator<T, R> ag, Map<String, Object> id) {
        this.aggregator = ag;
        this.id = this.getMap("_id", id);
    }

    private Map<String, Object> getMap(String key, Object value) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(key, value);
        return ret;
    }

    public Group<T, R> addToSet(Map<String, Object> param) {
        Map<String, Object> o = this.getMap("$addToSet", param);
        this.operators.add(o);
        return this;
    }

    public Group<T, R> first(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$first", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> last(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$last", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> max(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$max", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> min(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$min", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> avg(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$avg", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> push(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$push", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> sum(String name, int p) {
        return this.sum(name, (Object)p);
    }

    public Group<T, R> sum(String name, long p) {
        return this.sum(name, (Object)p);
    }

    public Group<T, R> sum(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$sum", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> sum(String name, String p) {
        return this.sum(name, (Object)p);
    }

    public Aggregator<T, R> end() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.id);
        this.operators.forEach(params::putAll);
        Map<String, Object> obj = this.getMap("$group", params);
        this.aggregator.addOperator(obj);
        return this.aggregator;
    }

    public List<Map<String, Object>> getOperators() {
        return this.operators;
    }
}

