/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    public static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static String toJsonString(Object o) {
        StringBuilder b = new StringBuilder();
        boolean comma = false;
        if (o instanceof Collection) {
            b.append(" [ ");
            for (Object obj : (Collection)o) {
                if (comma) {
                    b.append(", ");
                }
                comma = true;
                b.append(Utils.toJsonString(obj));
            }
            b.append("]");
            return b.toString();
        }
        if (o instanceof String) {
            return "\"" + o.toString() + "\"";
        }
        if (!(o instanceof Map)) {
            return o.toString();
        }
        Map db = (Map)o;
        b.append("{ ");
        comma = false;
        for (Map.Entry e : db.entrySet()) {
            if (comma) {
                b.append(", ");
            }
            comma = true;
            b.append("\"");
            b.append((String)e.getKey());
            b.append("\"");
            b.append(" : ");
            if (e.getValue() == null) {
                b.append(" null");
                continue;
            }
            if (e.getValue() instanceof String) {
                b.append("\"");
                b.append(e.getValue());
                b.append("\"");
                continue;
            }
            if (e.getValue().getClass().isEnum()) {
                b.append("\"");
                b.append(e.getValue().toString());
                b.append("\"");
                continue;
            }
            b.append(Utils.toJsonString(e.getValue()));
        }
        b.append(" } ");
        return b.toString();
    }

    public static <K, V> Map<K, V> getMap(K key, V value) {
        HashMap<K, V> ret = new HashMap<K, V>();
        ret.put(key, value);
        return ret;
    }

    public static Map<String, Integer> getIntMap(String key, Integer value) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put(key, value);
        return ret;
    }

    public static String getHex(long i) {
        return Utils.getHex((byte)(i >> 56 & 0xFFL)) + Utils.getHex((byte)(i >> 48 & 0xFFL)) + Utils.getHex((byte)(i >> 40 & 0xFFL)) + Utils.getHex((byte)(i >> 32 & 0xFFL)) + Utils.getHex((byte)(i >> 24 & 0xFFL)) + Utils.getHex((byte)(i >> 16 & 0xFFL)) + Utils.getHex((byte)(i >> 8 & 0xFFL)) + Utils.getHex((byte)(i & 0xFFL));
    }

    public static String getHex(int i) {
        return Utils.getHex((byte)(i >> 24 & 0xFF)) + Utils.getHex((byte)(i >> 16 & 0xFF)) + Utils.getHex((byte)(i >> 8 & 0xFF)) + Utils.getHex((byte)(i & 0xFF));
    }

    public static String getHex(byte[] b) {
        return Utils.getHex(b, -1);
    }

    public static String getHex(byte[] b, int sz) {
        StringBuilder sb = new StringBuilder();
        int mainIdx = 0;
        int end = b.length;
        if (sz > 0 && sz < b.length) {
            end = sz;
        }
        while (mainIdx < end) {
            sb.append(Utils.getHex((byte)(mainIdx >> 24 & 0xFF)));
            sb.append(Utils.getHex((byte)(mainIdx >> 16 & 0xFF)));
            sb.append(Utils.getHex((byte)(mainIdx >> 8 & 0xFF)));
            sb.append(Utils.getHex((byte)(mainIdx & 0xFF)));
            sb.append(":  ");
            for (int i = mainIdx; i < mainIdx + 16 && i < b.length; ++i) {
                byte by = b[i];
                sb.append(Utils.getHex(by));
                sb.append(" ");
            }
            try {
                int l = 16;
                if (mainIdx + 16 > b.length) {
                    l = b.length - mainIdx;
                }
                byte[] sr = new byte[l];
                int n = 0;
                for (int j = mainIdx; j < mainIdx + l; ++j) {
                    sr[n] = b[j] < 128 && b[j] > 63 ? b[j] : (b[j] == 0 ? 45 : 46);
                    ++n;
                }
                String str = new String(sr, 0, l, "UTF-8");
                sb.append("    ");
                sb.append(str);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            sb.append("\n");
            mainIdx += 16;
        }
        return sb.toString();
    }

    public static String getHex(byte by) {
        String ret = "";
        int idx = by >>> 4 & 0xF;
        ret = ret + hexChars[idx];
        idx = by & 0xF;
        ret = ret + hexChars[idx];
        return ret;
    }
}

