/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.FilterExpression;
import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.ReadAccessType;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.query.DefaultMorphiumIterator;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MorphiumDriverIterator;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.PrefetchingDriverIterator;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

public class QueryImpl<T>
implements Query<T>,
Cloneable {
    private static final Logger log = new Logger(Query.class);
    private String where;
    private Class<? extends T> type;
    private List<FilterExpression> andExpr;
    private List<Query<T>> orQueries;
    private List<Query<T>> norQueries;
    private ReadPreferenceLevel readPreferenceLevel;
    private boolean additionalDataPresent = false;
    private int limit = 0;
    private int skip = 0;
    private Map<String, Integer> sort;
    private Morphium morphium;
    private ThreadPoolExecutor executor;
    private String collectionName;
    private String srv = null;
    private Map<String, Object> fieldList;
    private boolean autoValuesEnabled = true;
    private Map<String, Object> additionalFields;
    private String tags;
    private AnnotationAndReflectionHelper arHelper;

    public QueryImpl() {
    }

    public QueryImpl(Morphium m, Class<? extends T> type, ThreadPoolExecutor executor) {
        this(m);
        this.setType(type);
        this.executor = executor;
        if (m.getConfig().getDefaultTagSet() != null) {
            this.tags = m.getConfig().getDefaultTags();
        }
    }

    public QueryImpl(Morphium m) {
        this.setMorphium(m);
    }

    @Override
    public String[] getTags() {
        if (this.tags == null) {
            return new String[0];
        }
        return this.tags.split(",");
    }

    @Override
    public Query<T> addTag(String name, String value) {
        this.tags = this.tags != null ? this.tags + "," : "";
        this.tags = this.tags + name + ":" + value;
        return this;
    }

    @Override
    public Query<T> disableAutoValues() {
        this.autoValuesEnabled = false;
        return this;
    }

    @Override
    public Query<T> enableAutoValues() {
        this.autoValuesEnabled = true;
        return this;
    }

    @Override
    public boolean isAutoValuesEnabled() {
        return this.autoValuesEnabled;
    }

    @Override
    public Query<T> setAutoValuesEnabled(boolean autoValuesEnabled) {
        this.autoValuesEnabled = autoValuesEnabled;
        return this;
    }

    @Override
    public String getServer() {
        return this.srv;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.setARHelpter(m.getARHelper());
        this.andExpr = new ArrayList<FilterExpression>();
        this.orQueries = new ArrayList<Query<T>>();
        this.norQueries = new ArrayList<Query<T>>();
    }

    @Override
    public ReadPreferenceLevel getReadPreferenceLevel() {
        return this.readPreferenceLevel;
    }

    @Override
    public void setReadPreferenceLevel(ReadPreferenceLevel readPreferenceLevel) {
        this.readPreferenceLevel = readPreferenceLevel;
    }

    @Override
    public Query<T> q() {
        QueryImpl<T> q = new QueryImpl<T>(this.morphium, this.type, this.executor);
        q.setCollectionName(this.getCollectionName());
        return q;
    }

    @Override
    public List<T> complexQuery(Map<String, Object> query) {
        return this.complexQuery(query, (String)null, 0, 0);
    }

    @Override
    public List<T> complexQuery(Map<String, Object> query, String sort, int skip, int limit) {
        HashMap<String, Integer> srt = new HashMap<String, Integer>();
        if (sort != null) {
            String[] tok;
            for (String t : tok = sort.split(",")) {
                if (t.startsWith("-")) {
                    srt.put(t.substring(1), -1);
                    continue;
                }
                if (t.startsWith("+")) {
                    srt.put(t.substring(1), 1);
                    continue;
                }
                srt.put(t, 1);
            }
        }
        return this.complexQuery(query, srt, skip, limit);
    }

    @Override
    public AnnotationAndReflectionHelper getARHelper() {
        if (this.arHelper == null) {
            this.arHelper = this.morphium.getARHelper();
        }
        return this.arHelper;
    }

    @Override
    public void setARHelpter(AnnotationAndReflectionHelper ar) {
        this.arHelper = ar;
    }

    @Override
    public List<T> complexQuery(Map<String, Object> query, Map<String, Integer> sort, int skip, int limit) {
        List<Map<String, Object>> obj;
        Cache ca = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = ca != null && ca.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(query, sort, this.getCollectionName(), skip, limit);
        if (useCache && this.morphium.getCache().isCached(this.type, ck)) {
            return this.morphium.getCache().getFromCache(this.type, ck);
        }
        long start = System.currentTimeMillis();
        Map<String, Object> lst = this.getFieldListForQuery();
        ArrayList<T> ret = new ArrayList<T>();
        HashMap<String, Object> findMetaData = new HashMap<String, Object>();
        try {
            obj = this.morphium.getDriver().find(this.morphium.getConfig().getDatabase(), this.getCollectionName(), query, sort, lst, skip, limit, 100, this.getRP(), findMetaData);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        for (Map<String, Object> in : obj) {
            T unmarshall = this.morphium.getMapper().unmarshall(this.type, in);
            if (unmarshall == null) continue;
            ret.add(unmarshall);
        }
        this.srv = (String)findMetaData.get("server");
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.AS_LIST);
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        return ret;
    }

    @Override
    public Map<String, Object> getFieldListForQuery() {
        List<Field> fldlst = this.getARHelper().getAllFields(this.type);
        HashMap<String, Object> lst = new HashMap<String, Object>();
        lst.put("_id", 1);
        Entity e = this.getARHelper().getAnnotationFromHierarchy(this.type, Entity.class);
        if (e.polymorph()) {
            return new HashMap<String, Object>();
        }
        if (this.fieldList != null) {
            lst.putAll(this.fieldList);
        } else {
            for (Field f : fldlst) {
                if (f.isAnnotationPresent(AdditionalData.class)) {
                    lst = new HashMap();
                    break;
                }
                String n = this.getARHelper().getFieldName(this.type, f.getName());
                lst.put(n, 1);
            }
        }
        if (this.additionalFields != null) {
            lst.putAll(this.additionalFields);
        }
        return lst;
    }

    @Override
    public List distinct(String field) {
        try {
            return this.morphium.getDriver().distinct(this.morphium.getConfig().getDatabase(), this.getCollectionName(), field, this.toQueryObject(), this.morphium.getReadPreferenceForClass(this.getType()));
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T complexQueryOne(Map<String, Object> query) {
        return this.complexQueryOne(query, null, 0);
    }

    @Override
    public T complexQueryOne(Map<String, Object> query, Map<String, Integer> sort, int skip) {
        List<T> ret = this.complexQuery(query, sort, skip, 1);
        if (ret != null && !ret.isEmpty()) {
            return ret.get(0);
        }
        return null;
    }

    @Override
    public T complexQueryOne(Map<String, Object> query, Map<String, Integer> sort) {
        return this.complexQueryOne(query, sort, 0);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSkip() {
        return this.skip;
    }

    @Override
    public Map<String, Integer> getSort() {
        return this.sort;
    }

    @Override
    public Query<T> addChild(FilterExpression ex) {
        this.andExpr.add(ex);
        return this;
    }

    @Override
    public Query<T> where(String wh) {
        this.where = wh;
        return this;
    }

    @Override
    public MongoField<T> f(Enum f) {
        return this.f(f.name());
    }

    @Override
    public MongoField<T> f(String ... f) {
        StringBuilder b = new StringBuilder();
        for (String e : f) {
            b.append(e);
            b.append(".");
        }
        b.deleteCharAt(b.length());
        return this.f(b.toString());
    }

    @Override
    public MongoField<T> f(Enum ... f) {
        StringBuilder b = new StringBuilder();
        for (Enum e : f) {
            b.append(e.name());
            b.append(".");
        }
        b.deleteCharAt(b.length());
        return this.f(b.toString());
    }

    @Override
    public MongoField<T> f(String f) {
        String cf;
        StringBuilder fieldPath = new StringBuilder();
        Class<Object> clz = this.type;
        if (f.contains(".")) {
            String[] fieldNames;
            for (String fieldName : fieldNames = f.split("\\.")) {
                String fieldNameInstance = this.getARHelper().getFieldName(clz, fieldName);
                Field field = this.getARHelper().getField(clz, fieldNameInstance);
                if (field == null) {
                    throw new IllegalArgumentException("Field " + fieldNameInstance + " not found!");
                }
                fieldPath.append(fieldNameInstance);
                fieldPath.append('.');
                clz = field.getType();
                if (clz.equals(List.class) || clz.equals(Collection.class) || clz.equals(Array.class) || clz.equals(Set.class) || clz.equals(Map.class)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Cannot check fields in generic lists or maps");
                    }
                    clz = Object.class;
                }
                if (clz.equals(Object.class)) break;
            }
            cf = clz.equals(Object.class) ? f : fieldPath.substring(0, fieldPath.length() - 1);
        } else {
            cf = this.getARHelper().getFieldName(clz, f);
        }
        if (this.additionalDataPresent) {
            log.debug("Additional data is available, not checking field");
        }
        MongoField fld = this.morphium.createMongoField();
        fld.setFieldString(cf);
        fld.setMapper(this.morphium.getMapper());
        fld.setQuery(this);
        return fld;
    }

    @Override
    @SafeVarargs
    public final Query<T> or(Query<T> ... qs) {
        this.orQueries.addAll(Arrays.asList(qs));
        return this;
    }

    @Override
    public Query<T> or(List<Query<T>> qs) {
        this.orQueries.addAll(qs);
        return this;
    }

    private Query<T> getClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("Clone not supported?!?!?!");
            throw new RuntimeException(e);
        }
    }

    @Override
    @SafeVarargs
    public final Query<T> nor(Query<T> ... qs) {
        this.norQueries.addAll(Arrays.asList(qs));
        return this;
    }

    @Override
    public Query<T> limit(int i) {
        this.limit = i;
        return this;
    }

    @Override
    public Query<T> skip(int i) {
        this.skip = i;
        return this;
    }

    @Override
    public Query<T> sort(Map<String, Integer> n) {
        this.sort = n;
        return this;
    }

    @Override
    public Query<T> sort(String ... prefixedString) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] stringArray = prefixedString;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String i2;
            String fld = i2 = stringArray[i];
            int val = 1;
            if (i2.startsWith("-")) {
                fld = i2.substring(1);
                val = -1;
            } else if (i2.startsWith("+")) {
                fld = i2.substring(1);
                val = 1;
            }
            if (!fld.contains(".") && !fld.startsWith("$")) {
                fld = this.getARHelper().getFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        return this.sort(m);
    }

    @Override
    public Query<T> sort(Enum ... naturalOrder) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        for (Enum i : naturalOrder) {
            String fld = this.getARHelper().getFieldName(this.type, i.name());
            m.put(fld, 1);
        }
        return this.sort(m);
    }

    @Override
    public void countAll(AsyncOperationCallback<T> c) {
        if (c == null) {
            throw new IllegalArgumentException("Not really useful to read from db and not use the result");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                long ret = this.countAll();
                c.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, null, null, ret);
            }
            catch (Exception e) {
                c.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public long countAll() {
        long ret;
        this.morphium.inc(StatisticKeys.READS);
        long start = System.currentTimeMillis();
        try {
            ret = this.morphium.getDriver().count(this.morphium.getConfig().getDatabase(), this.getCollectionName(), this.toQueryObject(), this.getRP());
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.COUNT);
        return ret;
    }

    private ReadPreference getRP() {
        if (this.readPreferenceLevel == null) {
            return null;
        }
        switch (this.readPreferenceLevel) {
            case PRIMARY: {
                return ReadPreference.primary();
            }
            case PRIMARY_PREFERRED: {
                return ReadPreference.primaryPreferred();
            }
            case SECONDARY: {
                return ReadPreference.secondary();
            }
            case SECONDARY_PREFERRED: {
                return ReadPreference.secondaryPreferred();
            }
            case NEAREST: {
                return ReadPreference.nearest();
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> toQueryObject() {
        boolean onlyAnd;
        HashMap<String, Object> o = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
        boolean bl = onlyAnd = this.orQueries.isEmpty() && this.norQueries.isEmpty() && this.where == null;
        if (this.where != null) {
            o.put("$where", this.where);
        }
        if (this.andExpr.size() == 1 && onlyAnd) {
            return this.andExpr.get(0).dbObject();
        }
        if (this.andExpr.size() == 1 && onlyAnd) {
            return this.andExpr.get(0).dbObject();
        }
        if (this.andExpr.isEmpty() && onlyAnd) {
            return o;
        }
        if (!this.andExpr.isEmpty()) {
            for (FilterExpression filterExpression : this.andExpr) {
                lst.add(filterExpression.dbObject());
            }
            o.put("$and", lst);
            lst = new ArrayList();
        }
        if (!this.orQueries.isEmpty()) {
            for (Query query : this.orQueries) {
                lst.add(query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((List)o.get("$and")).add(Utils.getMap("$or", lst));
            } else {
                o.put("$or", lst);
            }
        }
        if (!this.norQueries.isEmpty()) {
            for (Query query : this.norQueries) {
                lst.add(query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((List)o.get("$and")).add(Utils.getMap("$nor", lst));
            } else {
                o.put("$nor", lst);
            }
        }
        return o;
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public void setType(Class<? extends T> type) {
        List<String> fields;
        this.type = type;
        DefaultReadPreference pr = this.getARHelper().getAnnotationFromHierarchy(type, DefaultReadPreference.class);
        if (pr != null) {
            this.setReadPreferenceLevel(pr.value());
        }
        this.additionalDataPresent = (fields = this.getARHelper().getFields(type, AdditionalData.class)) != null && !fields.isEmpty();
    }

    @Override
    public void asList(AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                List<T> lst = this.asList();
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, lst, null, new Object[0]);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public List<T> asList() {
        this.morphium.inc(StatisticKeys.READS);
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        Map<String, Object> lst = this.getFieldListForQuery();
        ArrayList<T> ret = new ArrayList<T>();
        ret.clear();
        try {
            HashMap<String, Object> findMetaData = new HashMap<String, Object>();
            List<Map<String, Object>> query = this.morphium.getDriver().find(this.morphium.getConfig().getDatabase(), this.getCollectionName(), this.toQueryObject(), this.sort, lst, this.skip, this.limit, this.morphium.getConfig().getCursorBatchSize(), this.getRP(), findMetaData);
            this.srv = (String)findMetaData.get("server");
            for (Map<String, Object> o : query) {
                T unmarshall = this.morphium.getMapper().unmarshall(this.type, o);
                if (unmarshall == null) continue;
                ret.add(unmarshall);
                this.updateLastAccess(unmarshall);
                this.morphium.firePostLoadEvent(unmarshall);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.AS_LIST);
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        this.morphium.firePostLoad(ret);
        return ret;
    }

    @Override
    public MorphiumIterator<T> asIterable() {
        MorphiumDriverIterator it = new MorphiumDriverIterator();
        it.setQuery(this);
        return it;
    }

    @Override
    public MorphiumIterator<T> asIterable(int windowSize, Class<? extends MorphiumIterator<T>> it) {
        try {
            MorphiumIterator<T> ret = it.newInstance();
            return this.asIterable(windowSize, ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MorphiumIterator<T> asIterable(int windowSize, MorphiumIterator<T> ret) {
        try {
            ret.setQuery(this);
            ret.setWindowSize(windowSize);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MorphiumIterator<T> asIterable(int windowSize) {
        if (log.isDebugEnabled()) {
            log.debug("creating iterable for query - windowsize " + windowSize);
        }
        MorphiumDriverIterator it = new MorphiumDriverIterator();
        it.setQuery(this);
        it.setWindowSize(windowSize);
        return it;
    }

    @Override
    public MorphiumIterator<T> asIterable(int windowSize, int prefixWindows) {
        MorphiumIterator it;
        if (log.isDebugEnabled()) {
            log.debug("creating iterable for query - windowsize " + windowSize);
        }
        if (prefixWindows == 1) {
            it = new DefaultMorphiumIterator();
        } else {
            it = new PrefetchingDriverIterator();
            it.setNumberOfPrefetchWindows(prefixWindows);
        }
        it.setQuery(this);
        it.setWindowSize(windowSize);
        return it;
    }

    private void updateLastAccess(T unmarshall) {
        if (!this.autoValuesEnabled) {
            return;
        }
        if (!this.morphium.isAutoValuesEnabledForThread()) {
            return;
        }
        if (this.getARHelper().isAnnotationPresentInHierarchy(this.type, LastAccess.class)) {
            List<String> lst = this.getARHelper().getFields(this.type, LastAccess.class);
            for (String ctf : lst) {
                Field f = this.getARHelper().getField(this.type, ctf);
                if (f == null) continue;
                try {
                    long currentTime = System.currentTimeMillis();
                    if (f.getType().equals(Date.class)) {
                        f.set(unmarshall, new Date());
                    } else if (f.getType().equals(String.class)) {
                        LastAccess ctField = f.getAnnotation(LastAccess.class);
                        SimpleDateFormat df = new SimpleDateFormat(ctField.dateFormat());
                        f.set(unmarshall, df.format(currentTime));
                    } else {
                        f.set(unmarshall, currentTime);
                    }
                    ObjectMapper mapper = this.morphium.getMapper();
                    Object id = this.getARHelper().getId(unmarshall);
                    this.morphium.getDriver().update(this.morphium.getConfig().getDatabase(), this.getCollectionName(), Utils.getMap("_id", id), Utils.getMap("$set", Utils.getMap(ctf, currentTime)), false, false, null);
                }
                catch (Exception e) {
                    log.error("Could not set modification time");
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void getById(Object id, AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable c = () -> {
            long start = System.currentTimeMillis();
            try {
                T res = this.getById(id);
                ArrayList<T> result = new ArrayList<T>();
                result.add(res);
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, result, res, new Object[0]);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(c);
    }

    @Override
    public T getById(Object id) {
        List<String> flds = this.getARHelper().getFields(this.type, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new RuntimeException("Type does not have an ID-Field? " + this.type.getSimpleName());
        }
        String f = flds.get(0);
        Query<T> q = this.q().f(f).eq(id);
        return q.get();
    }

    @Override
    public void get(AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                ArrayList<T> ret = new ArrayList<T>();
                T ent = this.get();
                ret.add(ent);
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, ret, ent, new Object[0]);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public T get() {
        List<Map<String, Object>> srch;
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                List<T> lst = this.morphium.getCache().getFromCache(this.type, ck);
                if (lst == null || lst.isEmpty()) {
                    return null;
                }
                return lst.get(0);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        Map<String, Object> fl = this.getFieldListForQuery();
        HashMap<String, Object> findMetaData = new HashMap<String, Object>();
        try {
            srch = this.morphium.getDriver().find(this.morphium.getConfig().getDatabase(), this.getCollectionName(), this.toQueryObject(), this.getSort(), fl, this.getSkip(), this.getLimit(), 1, this.getRP(), findMetaData);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        if (srch.isEmpty()) {
            ArrayList lst = new ArrayList(0);
            if (useCache) {
                this.morphium.getCache().addToCache(ck, this.type, lst);
            }
            return null;
        }
        Map<String, Object> ret = srch.get(0);
        this.srv = (String)findMetaData.get("server");
        ArrayList<T> lst = new ArrayList<T>(1);
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingReadEvent(this, dur, ReadAccessType.GET);
        if (ret != null) {
            T unmarshall = this.morphium.getMapper().unmarshall(this.type, ret);
            if (unmarshall != null) {
                this.morphium.firePostLoadEvent(unmarshall);
                this.updateLastAccess(unmarshall);
                lst.add(unmarshall);
                if (useCache) {
                    this.morphium.getCache().addToCache(ck, this.type, lst);
                }
            }
            return unmarshall;
        }
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, lst);
        }
        return null;
    }

    @Override
    public void idList(AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callable is null?");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                List ret = this.idList();
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, null, null, ret);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public <R> List<R> idList() {
        List<Map<String, Object>> query;
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        ArrayList ret = new ArrayList();
        String ck = this.morphium.getCache().getCacheKey(this);
        ck = ck + " idlist";
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        HashMap<String, Object> findMetadata = new HashMap<String, Object>();
        try {
            query = this.morphium.getDriver().find(this.morphium.getConfig().getDatabase(), this.getCollectionName(), this.toQueryObject(), null, Utils.getMap("_id", 1), this.skip, this.limit, 1, this.getRP(), findMetadata);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        ret.addAll(query.stream().map(o -> o.get("_id")).collect(Collectors.toList()));
        this.srv = (String)findMetadata.get("server");
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingReadEvent(this, dur, ReadAccessType.ID_LIST);
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        return ret;
    }

    @Override
    public Query<T> clone() throws CloneNotSupportedException {
        try {
            QueryImpl ret = (QueryImpl)super.clone();
            if (this.andExpr != null) {
                ret.andExpr = new ArrayList<FilterExpression>();
                ret.andExpr.addAll(this.andExpr);
            }
            if (this.norQueries != null) {
                ret.norQueries = new ArrayList<Query<T>>();
                ret.norQueries.addAll(this.norQueries);
            }
            if (this.sort != null) {
                ret.sort = new HashMap<String, Integer>();
                ret.sort.putAll(this.sort);
            }
            if (this.orQueries != null) {
                ret.orQueries = new ArrayList<Query<T>>();
                ret.orQueries.addAll(this.orQueries);
            }
            if (this.readPreferenceLevel != null) {
                ret.readPreferenceLevel = this.readPreferenceLevel;
            }
            if (this.where != null) {
                ret.where = this.where;
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() {
        this.morphium.delete(this);
    }

    @Override
    public int getNumberOfPendingRequests() {
        return this.getExecutor().getActiveCount();
    }

    @Override
    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    @Override
    public Query<T> setCollectionName(String n) {
        this.collectionName = n;
        return this;
    }

    @Override
    public Query<T> text(String ... text) {
        return this.text((String)null, (Query.TextSearchLanguages)null, text);
    }

    @Override
    public Query<T> text(Query.TextSearchLanguages lang, String ... text) {
        return this.text(null, lang, text);
    }

    @Override
    public Query<T> text(String metaScoreField, Query.TextSearchLanguages lang, String ... text) {
        FilterExpression f = new FilterExpression();
        f.setField("$text");
        StringBuilder b = new StringBuilder();
        for (String t : text) {
            b.append(t);
            b.append(" ");
        }
        f.setValue(Utils.getMap("$search", b.toString()));
        if (lang != null) {
            ((Map)f.getValue()).put("$language", lang.toString());
        }
        this.addChild(f);
        if (metaScoreField != null) {
            this.additionalFields = Utils.getMap(metaScoreField, Utils.getMap("$meta", "textScore"));
        }
        return this;
    }

    @Override
    @Deprecated
    public List<T> textSearch(String ... texts) {
        return this.textSearch(Query.TextSearchLanguages.mongo_default, texts);
    }

    @Override
    @Deprecated
    public List<T> textSearch(Query.TextSearchLanguages lang, String ... texts) {
        Map<String, Object> result;
        if (texts.length == 0) {
            return new ArrayList();
        }
        HashMap<String, Object> txt = new HashMap<String, Object>();
        txt.put("text", this.getCollectionName());
        StringBuilder b = new StringBuilder();
        for (String t : texts) {
            b.append(t);
            b.append(" ");
        }
        txt.put("search", b.toString());
        txt.put("filter", this.toQueryObject());
        if (this.getLimit() > 0) {
            txt.put("limit", this.limit);
        }
        if (!lang.equals((Object)Query.TextSearchLanguages.mongo_default)) {
            txt.put("language", lang.name());
        }
        try {
            result = this.morphium.getDriver().runCommand(this.morphium.getConfig().getDatabase(), txt);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        List lst = (List)result.get("results");
        ArrayList<T> ret = new ArrayList<T>();
        for (Object o : lst) {
            Map obj = (Map)o;
            T unmarshall = this.morphium.getMapper().unmarshall(this.getType(), obj);
            if (unmarshall == null) continue;
            ret.add(unmarshall);
        }
        return ret;
    }

    @Override
    public Query<T> setProjection(Enum ... fl) {
        for (Enum f : fl) {
            this.addProjection(f);
        }
        return this;
    }

    @Override
    public Query<T> setProjection(String ... fl) {
        this.fieldList = new HashMap<String, Object>();
        for (String f : fl) {
            this.addProjection(f);
        }
        return this;
    }

    @Override
    public Query<T> addProjection(Enum f, String projectOperator) {
        this.addProjection(f.name(), projectOperator);
        return this;
    }

    @Override
    public Query<T> addProjection(Enum f) {
        this.addProjection(f.name());
        return this;
    }

    @Override
    public Query<T> addProjection(String f) {
        if (this.fieldList == null) {
            this.fieldList = new HashMap<String, Object>();
        }
        String n = this.getARHelper().getFieldName(this.type, f);
        this.fieldList.put(n, 1);
        return this;
    }

    @Override
    public Query<T> addProjection(String f, String projectOperator) {
        if (this.fieldList == null) {
            this.fieldList = new HashMap<String, Object>();
        }
        String n = this.getARHelper().getFieldName(this.type, f);
        this.fieldList.put(n, projectOperator);
        return this;
    }

    @Override
    public Query<T> hideFieldInProjection(String f) {
        if (this.fieldList == null) {
            this.fieldList = new HashMap<String, Object>();
        }
        this.fieldList.put(this.getARHelper().getFieldName(this.type, f), 0);
        return this;
    }

    @Override
    public Query<T> hideFieldInProjection(Enum f) {
        return this.hideFieldInProjection(f.name());
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var4_12;
        StringBuilder and = new StringBuilder();
        if (this.andExpr != null && !this.andExpr.isEmpty()) {
            and.append("[");
            for (FilterExpression filterExpression : this.andExpr) {
                and.append(filterExpression.toString());
                and.append(", ");
            }
            and.deleteCharAt(and.length() - 1);
            and.deleteCharAt(and.length() - 1);
            and.append(" ]");
        }
        StringBuilder ors = new StringBuilder();
        if (this.orQueries != null && !this.orQueries.isEmpty()) {
            ors.append("[ ");
            for (Query<T> query : this.orQueries) {
                ors.append(query.toString());
                ors.append(", ");
            }
            ors.deleteCharAt(ors.length() - 1);
            ors.deleteCharAt(ors.length() - 1);
            ors.append(" ]");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.norQueries != null && !this.norQueries.isEmpty()) {
            stringBuilder.append("[ ");
            for (Query<T> query : this.norQueries) {
                stringBuilder.append(query.toString());
                stringBuilder.append(", ");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(" ]");
        }
        String string = "Query{ collectionName='" + this.collectionName + '\'' + ", type=" + this.type.getName() + ", skip=" + this.skip + ", limit=" + this.limit + ", andExpr=" + and.toString() + ", orQueries=" + ors + ", norQueries=" + stringBuilder + ", sort=" + this.sort + ", readPreferenceLevel=" + (Object)((Object)this.readPreferenceLevel) + ", additionalDataPresent=" + this.additionalDataPresent + ", where='" + this.where + '\'' + '}';
        if (this.fieldList != null) {
            String string2 = string + " Fields " + this.fieldList.toString();
        }
        return var4_12;
    }
}

