/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumConfig;

public class MorphiumSingleton {
    private static MorphiumConfig config;
    private static volatile Morphium instance;

    public static void setConfig(MorphiumConfig cfg) {
        if (config != null) {
            throw new RuntimeException("Morphium already configured!");
        }
        config = cfg;
    }

    public static boolean isConfigured() {
        return config != null;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static MorphiumConfig getConfig() {
        return config;
    }

    public static void reset() {
        config = null;
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Morphium get() {
        if (instance != null) return instance;
        if (config == null) {
            throw new RuntimeException("MongoDbLayer not configured!");
        }
        Class<Morphium> clazz = Morphium.class;
        synchronized (Morphium.class) {
            if (instance != null) return instance;
            instance = new Morphium(config);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void set(Morphium m) {
        config = m.getConfig();
        instance = m;
    }
}

