/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.query.QueryFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class QueryFactoryImpl
implements QueryFactory {
    private Class<? extends Query> queryImpl;
    private ThreadPoolExecutor executor = null;

    public QueryFactoryImpl() {
    }

    @Override
    public void setExecutor(ThreadPoolExecutor ex) {
        this.executor = ex;
    }

    public QueryFactoryImpl(Class<? extends Query> qi) {
        this.queryImpl = qi;
    }

    @Override
    public ThreadPoolExecutor getExecutor(Morphium m) {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(m.getConfig().getMaxConnections() / 2, (int)((double)(m.getConfig().getMaxConnections() * m.getConfig().getBlockingThreadsMultiplier()) * 0.9), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        return this.executor;
    }

    @Override
    public Class<? extends Query> getQueryImpl() {
        return this.queryImpl;
    }

    @Override
    public void setQueryImpl(Class<? extends Query> queryImpl) {
        this.queryImpl = queryImpl;
    }

    @Override
    public <T> Query<T> createQuery(Morphium m, Class<? extends T> type) {
        try {
            Query q = this.queryImpl.newInstance();
            q.setMorphium(m);
            q.setType(type);
            q.setExecutor(this.getExecutor(m));
            return q;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

