/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumSingleton;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.messaging.MessageListener;
import de.caluga.morphium.messaging.Msg;
import de.caluga.morphium.messaging.MsgType;
import de.caluga.morphium.query.Query;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Messaging
extends Thread {
    private static Logger log = Logger.getLogger(Messaging.class);
    private Morphium morphium;
    private boolean running;
    private int pause = 5000;
    private String id;
    private boolean autoAnswer = false;
    private String hostname;
    private boolean processMultiple = false;
    private List<MessageListener> listeners;
    private Map<String, List<MessageListener>> listenerByName;
    private String queueName;

    public Messaging(Morphium m, int pause, boolean processMultiple) {
        this(m, null, pause, processMultiple);
    }

    public long getMessageCount() {
        return this.morphium.createQueryFor(Msg.class).countAll();
    }

    public Messaging(Morphium m, String queueName, int pause, boolean processMultiple) {
        this.queueName = queueName;
        this.morphium = m;
        this.running = true;
        this.pause = pause;
        this.processMultiple = processMultiple;
        this.id = UUID.randomUUID().toString();
        this.hostname = System.getenv("HOSTNAME");
        if (this.hostname == null) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if (this.hostname == null) {
            this.hostname = "unknown host";
        }
        m.ensureIndicesFor(Msg.class, queueName);
        this.listeners = new Vector<MessageListener>();
        this.listenerByName = new Hashtable<String, List<MessageListener>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Messaging " + this.id + " started"));
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        while (this.running) {
            try {
                Query<Msg> q = this.morphium.createQueryFor(Msg.class);
                q.setCollectionName(this.getCollectionName());
                q.or(q.q().f((Enum)Msg.Fields.sender).ne(this.id).f((Enum)Msg.Fields.lockedBy).eq(null).f((Enum)Msg.Fields.processedBy).ne(this.id).f((Enum)Msg.Fields.recipient).eq(null), q.q().f((Enum)Msg.Fields.sender).ne(this.id).f((Enum)Msg.Fields.lockedBy).eq(null).f((Enum)Msg.Fields.processedBy).ne(this.id).f((Enum)Msg.Fields.recipient).eq(this.id));
                values.put("locked_by", this.id);
                values.put("locked", System.currentTimeMillis());
                this.morphium.set(q, values, false, this.processMultiple);
                q = q.q();
                q.or(q.q().f((Enum)Msg.Fields.lockedBy).eq(this.id), q.q().f((Enum)Msg.Fields.lockedBy).eq("ALL").f((Enum)Msg.Fields.processedBy).ne(this.id).f((Enum)Msg.Fields.recipient).eq(this.id), q.q().f((Enum)Msg.Fields.lockedBy).eq("ALL").f((Enum)Msg.Fields.processedBy).ne(this.id).f((Enum)Msg.Fields.recipient).eq(null));
                q.sort(Msg.Fields.timestamp);
                List<Msg> messagesList = q.asList();
                ArrayList<Msg> toStore = new ArrayList<Msg>();
                for (Msg msg : messagesList) {
                    if ((msg = this.morphium.reread(msg, this.getCollectionName())) == null || !msg.getLockedBy().equals(this.id) && !msg.getLockedBy().equals("ALL")) continue;
                    if (msg.getTtl() < System.currentTimeMillis() - msg.getTimestamp()) {
                        log.info((Object)"Found outdated message - deleting it!");
                        this.morphium.delete(msg, this.getCollectionName());
                        continue;
                    }
                    try {
                        Msg answer;
                        for (MessageListener l : this.listeners) {
                            answer = l.onMessage(this, msg);
                            if (this.autoAnswer && answer == null) {
                                answer = new Msg(msg.getName(), "received", "");
                            }
                            if (answer == null) continue;
                            msg.sendAnswer(this, answer);
                        }
                        if (this.listenerByName.get(msg.getName()) != null) {
                            for (MessageListener l : this.listenerByName.get(msg.getName())) {
                                answer = l.onMessage(this, msg);
                                if (this.autoAnswer && answer == null) {
                                    answer = new Msg(msg.getName(), "received", "");
                                }
                                if (answer == null) continue;
                                msg.setDeleteAt(new Date(System.currentTimeMillis() + msg.getTtl()));
                                msg.sendAnswer(this, answer);
                            }
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)"Processing failed", t);
                    }
                    if (msg.getType().equals((Object)MsgType.SINGLE)) {
                        this.morphium.delete(msg, this.getCollectionName());
                    }
                    if (msg.getLockedBy().equals("ALL")) {
                        Query<Msg> idq = MorphiumSingleton.get().createQueryFor(Msg.class);
                        idq.setCollectionName(this.getCollectionName());
                        idq.f((Enum)Msg.Fields.msgId).eq(msg.getMsgId());
                        MorphiumSingleton.get().push(idq, Msg.Fields.processedBy, (Object)this.id);
                        continue;
                    }
                    msg.addProcessedId(this.id);
                    msg.setLockedBy(null);
                    msg.setLocked(0L);
                    toStore.add(msg);
                }
                this.morphium.storeList(toStore, this.getCollectionName());
                while (this.morphium.getWriteBufferCount() > 0) {
                    Thread.sleep(100L);
                }
            }
            catch (Throwable e) {
                log.error((Object)("Unhandled exception " + e.getMessage()), e);
            }
            finally {
                try {
                    Messaging.sleep(this.pause);
                }
                catch (InterruptedException ignored) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Messaging " + this.id + " stopped!"));
        }
        if (!this.running) {
            this.listeners.clear();
            this.listenerByName.clear();
        }
    }

    public String getCollectionName() {
        if (this.queueName == null || this.queueName.isEmpty()) {
            return "msg";
        }
        return "mmsg_" + this.queueName;
    }

    public void addListenerForMessageNamed(String n, MessageListener l) {
        if (this.listenerByName.get(n) == null) {
            this.listenerByName.put(n, new ArrayList());
        }
        this.listenerByName.get(n).add(l);
    }

    public void removeListenerForMessageNamed(String n, MessageListener l) {
        if (this.listenerByName.get(n) == null) {
            return;
        }
        this.listenerByName.get(n).remove(l);
    }

    public String getSenderId() {
        return this.id;
    }

    public void setSenderId(String id) {
        this.id = id;
    }

    public int getPause() {
        return this.pause;
    }

    public void setPause(int pause) {
        this.pause = pause;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void addMessageListener(MessageListener l) {
        this.listeners.add(l);
    }

    public void removeMessageListener(MessageListener l) {
        this.listeners.remove(l);
    }

    public void queueMessage(Msg m) {
        this.storeMsg(m, true);
    }

    public void storeMessage(Msg m) {
        this.storeMsg(m, false);
    }

    private void storeMsg(Msg m, boolean async) {
        AsyncOperationCallback cb = null;
        if (async) {
            cb = new AsyncOperationCallback(){

                public void onOperationSucceeded(AsyncOperationType type, Query q, long duration, List result, Object entity, Object ... param) {
                }

                public void onOperationError(AsyncOperationType type, Query q, long duration, String error, Throwable t, Object entity, Object ... param) {
                }
            };
        }
        m.setDeleteAt(new Date(System.currentTimeMillis() + m.getTtl()));
        m.setSender(this.id);
        m.addProcessedId(this.id);
        m.setLockedBy(null);
        m.setLocked(0L);
        m.setSenderHost(this.hostname);
        if (m.getTo() != null && m.getTo().size() > 0) {
            for (String recipient : m.getTo()) {
                Msg msg = m.getCopy();
                msg.setRecipient(recipient);
                this.morphium.storeNoCache(msg, this.getCollectionName(), cb);
            }
        } else {
            this.morphium.storeNoCache(m, this.getCollectionName(), cb);
        }
    }

    public boolean isAutoAnswer() {
        return this.autoAnswer;
    }

    public void setAutoAnswer(boolean autoAnswer) {
        this.autoAnswer = autoAnswer;
    }
}

