/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Aliases;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.Property;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.annotations.caching.AsyncWrites;
import de.caluga.morphium.annotations.caching.WriteBuffer;
import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AnnotationAndReflectionHelper {
    private Logger log = Logger.getLogger(AnnotationAndReflectionHelper.class);
    private Map<String, Field> fieldCache = new Hashtable<String, Field>();
    private Map<Class<?>, Class<?>> realClassCache = new Hashtable();
    private Map<Class<?>, List<Field>> fieldListCache = new Hashtable();
    private Map<String, List<String>> fieldAnnotationListCache = new HashMap<String, List<String>>();
    private Map<Class<?>, Map<Class<? extends Annotation>, Method>> lifeCycleMethods = new Hashtable();
    private Map<Class<?>, Boolean> hasAdditionalData = new Hashtable();

    public <T extends Annotation> boolean isAnnotationPresentInHierarchy(Class<?> cls, Class<? extends T> anCls) {
        return this.getAnnotationFromHierarchy(cls, anCls) != null;
    }

    public <T> Class<? extends T> getRealClass(Class<? extends T> sc) {
        if (this.realClassCache.containsKey(sc)) {
            return this.realClassCache.get(sc);
        }
        if (sc.getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                Class<?> ret = Class.forName(sc.getName().substring(0, sc.getName().indexOf("$$")));
                this.realClassCache.put(sc, ret);
                sc = ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sc;
    }

    public boolean isBufferedWrite(Class<?> cls) {
        WriteBuffer wb = this.getAnnotationFromHierarchy(cls, WriteBuffer.class);
        return wb != null && wb.value();
    }

    public <T extends Annotation> T getAnnotationFromHierarchy(Class<?> cls, Class<? extends T> anCls) {
        if ((cls = this.getRealClass(cls)).isAnnotationPresent(anCls)) {
            return cls.getAnnotation(anCls);
        }
        Class<?> z = cls;
        while (!z.equals(Object.class)) {
            if (z.isAnnotationPresent(anCls)) {
                return z.getAnnotation(anCls);
            }
            if ((z = z.getSuperclass()) != null) continue;
            break;
        }
        return null;
    }

    public boolean hasAdditionalData(Class clz) {
        if (this.hasAdditionalData.get(clz) == null) {
            List<String> lst = this.getFields(clz, AdditionalData.class);
            this.hasAdditionalData.put(clz, lst != null && lst.size() > 0);
        }
        return this.hasAdditionalData.get(clz);
    }

    public String getFieldName(Class clz, String field) {
        Annotation p;
        Class cls = this.getRealClass(clz);
        if (field.contains(".")) {
            return field;
        }
        Field f = this.getField(cls, field);
        if (f == null && this.hasAdditionalData(clz)) {
            return field;
        }
        if (f == null) {
            throw new RuntimeException("Field not found " + field + " in cls: " + clz.getName());
        }
        if (f.isAnnotationPresent(Property.class) && (p = f.getAnnotation(Property.class)).fieldName() != null && !p.fieldName().equals(".")) {
            return p.fieldName();
        }
        if (f.isAnnotationPresent(Reference.class) && (p = f.getAnnotation(Reference.class)).fieldName() != null && !p.fieldName().equals(".")) {
            return p.fieldName();
        }
        if (f.isAnnotationPresent(Id.class)) {
            return "_id";
        }
        String fieldName = f.getName();
        Entity ent = this.getAnnotationFromHierarchy(cls, Entity.class);
        Embedded emb = this.getAnnotationFromHierarchy(cls, Embedded.class);
        if (ent != null && ent.translateCamelCase()) {
            fieldName = this.convertCamelCase(fieldName);
        } else if (emb != null && emb.translateCamelCase()) {
            fieldName = this.convertCamelCase(fieldName);
        }
        return fieldName;
    }

    public String createCamelCase(String n, boolean capitalize) {
        n = n.toLowerCase();
        String[] f = n.split("_");
        StringBuilder sb = new StringBuilder(f[0].substring(0, 1).toLowerCase());
        sb.append(f[0].substring(1));
        for (int i = 1; i < f.length; ++i) {
            sb.append(f[i].substring(0, 1).toUpperCase());
            sb.append(f[i].substring(1));
        }
        String ret = sb.toString();
        if (capitalize) {
            ret = ret.substring(0, 1).toUpperCase() + ret.substring(1);
        }
        return ret;
    }

    public String convertCamelCase(String n) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < n.length() - 1; ++i) {
            if (Character.isUpperCase(n.charAt(i)) && i > 0) {
                b.append("_");
            }
            b.append(n.substring(i, i + 1).toLowerCase());
        }
        b.append(n.substring(n.length() - 1));
        return b.toString();
    }

    public List<Field> getAllFields(Class clz) {
        if (this.fieldListCache.containsKey(clz)) {
            return this.fieldListCache.get(clz);
        }
        Class cls = this.getRealClass(clz);
        Vector<Field> ret = new Vector<Field>();
        Class sc = cls;
        Vector hierachy = new Vector();
        while (!sc.equals(Object.class)) {
            hierachy.add(sc);
            sc = sc.getSuperclass();
        }
        Collections.addAll(hierachy, cls.getInterfaces());
        for (int i = hierachy.size() - 1; i >= 0; --i) {
            Class c = (Class)hierachy.get(i);
            Collections.addAll(ret, c.getDeclaredFields());
        }
        this.fieldListCache.put(clz, ret);
        return ret;
    }

    public Field getField(Class clz, String fld) {
        String key = clz.toString() + "->" + fld;
        if (this.fieldCache.containsKey(key)) {
            return this.fieldCache.get(key);
        }
        Class cls = this.getRealClass(clz);
        List<Field> flds = this.getAllFields(cls);
        for (Field f : flds) {
            if (f.isAnnotationPresent(Property.class) && f.getAnnotation(Property.class).fieldName() != null && !".".equals(f.getAnnotation(Property.class).fieldName()) && f.getAnnotation(Property.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                this.fieldCache.put(key, f);
                return f;
            }
            if (f.isAnnotationPresent(Reference.class) && f.getAnnotation(Reference.class).fieldName() != null && !".".equals(f.getAnnotation(Reference.class).fieldName()) && f.getAnnotation(Reference.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                this.fieldCache.put(key, f);
                return f;
            }
            if (f.isAnnotationPresent(Aliases.class)) {
                String[] v;
                Aliases aliases = f.getAnnotation(Aliases.class);
                for (String field : v = aliases.value()) {
                    if (!field.equals(fld)) continue;
                    f.setAccessible(true);
                    this.fieldCache.put(key, f);
                    return f;
                }
            }
            if (fld.equals("_id") && f.isAnnotationPresent(Id.class)) {
                f.setAccessible(true);
                this.fieldCache.put(key, f);
                return f;
            }
            if (f.getName().equals(fld)) {
                f.setAccessible(true);
                this.fieldCache.put(key, f);
                return f;
            }
            if (!this.convertCamelCase(f.getName()).equals(fld)) continue;
            f.setAccessible(true);
            this.fieldCache.put(key, f);
            return f;
        }
        return null;
    }

    public boolean isEntity(Object o) {
        if (o == null) {
            return false;
        }
        Class<Object> cls = o instanceof Class ? this.getRealClass((Class)o) : this.getRealClass(o.getClass());
        return this.isAnnotationPresentInHierarchy(cls, Entity.class) || this.isAnnotationPresentInHierarchy(cls, Embedded.class);
    }

    public Object getValue(Object o, String fld) {
        if (o == null) {
            return null;
        }
        try {
            Field f = this.getField(o.getClass(), fld);
            if (!Modifier.isStatic(f.getModifiers())) {
                o = this.getRealObject(o);
                return f.get(o);
            }
        }
        catch (IllegalAccessException e) {
            this.log.fatal((Object)("Illegal access to field " + fld + " of type " + o.getClass().getSimpleName()));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object o, Object value, String fld) {
        if (o == null) {
            return;
        }
        try {
            Field f = this.getField(this.getRealClass(o.getClass()), fld);
            if (Modifier.isStatic(f.getModifiers())) return;
            o = this.getRealObject(o);
            try {
                f.set(o, value);
                return;
            }
            catch (Exception e) {
                if (value != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Setting of value (" + value.getClass().getSimpleName() + ") failed for field " + f.getName() + "- trying type-conversion"));
                    }
                    if (value instanceof Double) {
                        Double d = (Double)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, d.intValue());
                        } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.longValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(d.longValue()));
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(d.floatValue()));
                        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, d == 1.0);
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, d.toString());
                        }
                    } else if (value instanceof Float) {
                        Float d = (Float)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, d.intValue());
                        } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.longValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(d.longValue()));
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, d);
                        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, d.floatValue() == 1.0f);
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, d.toString());
                        }
                    } else if (value instanceof Date) {
                        Date d = (Date)value;
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.getTime());
                        } else if (f.getType().equals(GregorianCalendar.class)) {
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTimeInMillis(d.getTime());
                            f.set(o, cal);
                        } else if (f.getType().equals(String.class)) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                            f.set(o, df.format(d));
                        }
                    } else if (value instanceof String) {
                        try {
                            String s = (String)value;
                            if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                                f.set(o, Long.parseLong(s));
                            }
                            if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                                f.set(o, Integer.parseInt(s));
                            }
                            if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                                f.set(o, Double.parseDouble(s));
                            }
                            if (f.getType().equals(Date.class)) {
                                if (s.length() == 8) {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                                    f.set(o, df.parse(s));
                                }
                                if (s.indexOf("-") > 0) {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                                    f.set(o, df.parse(s));
                                }
                                if (s.indexOf(".") > 0) {
                                    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
                                    f.set(o, df.parse(s));
                                }
                                f.set(o, new Date(Long.parseLong(s)));
                            }
                            if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                                f.set(o, s.equalsIgnoreCase("true"));
                            }
                            if (!f.getType().equals(Float.class) && !f.getType().equals(Float.TYPE)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, Float.valueOf(Float.parseFloat(s)));
                        }
                        catch (ParseException e1) {
                            throw new RuntimeException(e1);
                        }
                    } else if (value instanceof Integer) {
                        Integer i = (Integer)value;
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, i.longValue());
                        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, i.doubleValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(i.longValue()));
                        } else if (f.getType().equals(String.class)) {
                            f.set(o, i.toString());
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(i.floatValue()));
                        } else {
                            if (!f.getType().equals(Boolean.class) && !f.getType().equals(Boolean.TYPE)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, i == 1);
                        }
                    } else if (value instanceof Long) {
                        Long l = (Long)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, l.intValue());
                        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, l.doubleValue());
                        } else if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(l));
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(l.floatValue()));
                        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, l == 1L);
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, l.toString());
                        }
                    } else if (value instanceof Boolean) {
                        Boolean b = (Boolean)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, b != false ? 1 : 0);
                        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, b != false ? 1.0 : 0.0);
                        } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(b != false ? 1.0f : 0.0f));
                        } else {
                            if (!f.getType().equals(String.class)) throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                            f.set(o, b != false ? "true" : "false");
                        }
                    }
                }
                if (!this.log.isDebugEnabled()) return;
                this.log.debug((Object)"Type conversion was successful");
            }
            return;
        }
        catch (IllegalAccessException e) {
            this.log.fatal((Object)("Illegal access to field " + fld + " of toype " + o.getClass().getSimpleName()));
        }
    }

    public Object getId(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Field f = this.getIdField(o);
        if (f == null) {
            throw new IllegalArgumentException("Object ID field not found " + o.getClass().getSimpleName());
        }
        try {
            o = this.getRealObject(o);
            if (o != null) {
                return f.get(o);
            }
            this.log.warn((Object)"Illegal reference?");
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIdFieldName(Object o) {
        Class<?> cls = this.getRealClass(o.getClass());
        List<String> flds = this.getFields(cls, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new IllegalArgumentException("Object has no id defined: " + o.getClass().getSimpleName());
        }
        return flds.get(0);
    }

    public Field getIdField(Object o) {
        Class<?> cls = this.getRealClass(o.getClass());
        List<String> flds = this.getFields(cls, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new IllegalArgumentException("Object has no id defined: " + o.getClass().getSimpleName());
        }
        return this.getField(cls, flds.get(0));
    }

    public List<String> getFields(Class cls, Class<? extends Annotation> ... annotations) {
        String k = cls.toString();
        for (Class<? extends Annotation> a : annotations) {
            k = k + "/" + a.toString();
        }
        if (this.fieldAnnotationListCache.containsKey(k)) {
            return this.fieldAnnotationListCache.get(k);
        }
        Vector<String> ret = new Vector<String>();
        Class sc = cls;
        sc = this.getRealClass(sc);
        Entity entity = this.getAnnotationFromHierarchy(sc, Entity.class);
        Embedded embedded = this.getAnnotationFromHierarchy(sc, Embedded.class);
        if (embedded != null && entity != null) {
            this.log.warn((Object)("Class " + cls.getName() + " does have both @Entity and @Embedded Annotations - not allowed! Assuming @Entity is right"));
        }
        if (embedded == null && entity == null) {
            throw new IllegalArgumentException("This class " + cls.getName() + " does not have @Entity or @Embedded set, not even in hierachy - illegal!");
        }
        boolean tcc = entity == null ? embedded.translateCamelCase() : entity.translateCamelCase();
        List<Field> fld = this.getAllFields(cls);
        for (Field f : fld) {
            if (annotations.length > 0) {
                boolean found = false;
                for (Class<? extends Annotation> a : annotations) {
                    if (!f.isAnnotationPresent(a)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (f.isAnnotationPresent(Reference.class) && !".".equals(f.getAnnotation(Reference.class).fieldName())) {
                ret.add(f.getAnnotation(Reference.class).fieldName());
                continue;
            }
            if (f.isAnnotationPresent(Property.class) && !".".equals(f.getAnnotation(Property.class).fieldName())) {
                ret.add(f.getAnnotation(Property.class).fieldName());
                continue;
            }
            if (f.isAnnotationPresent(Transient.class)) continue;
            if (tcc) {
                ret.add(this.convertCamelCase(f.getName()));
                continue;
            }
            ret.add(f.getName());
        }
        this.fieldAnnotationListCache.put(k, ret);
        return ret;
    }

    public <T> T getRealObject(T o) {
        if (o.getClass().getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                Field f1 = o.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                f1.setAccessible(true);
                Object delegate = f1.get(o);
                Method m = delegate.getClass().getMethod("__getDeref", new Class[0]);
                o = m.invoke(delegate, new Object[0]);
            }
            catch (Exception e) {
                this.log.error((Object)"Exception: ", (Throwable)e);
            }
        }
        return o;
    }

    public final Class getTypeOfField(Class<?> cls, String fld) {
        Field f = this.getField(cls, fld);
        if (f == null) {
            return null;
        }
        return f.getType();
    }

    public boolean storesLastChange(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastChange.class);
    }

    public boolean storesLastAccess(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastAccess.class);
    }

    public boolean storesCreation(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, CreationTime.class);
    }

    public Long getLongValue(Object o, String fld) {
        return (Long)this.getValue(o, fld);
    }

    public String getStringValue(Object o, String fld) {
        return (String)this.getValue(o, fld);
    }

    public Date getDateValue(Object o, String fld) {
        return (Date)this.getValue(o, fld);
    }

    public Double getDoubleValue(Object o, String fld) {
        return (Double)this.getValue(o, fld);
    }

    public List<Annotation> getAllAnnotationsFromHierachy(Class<?> cls, Class<? extends Annotation> ... anCls) {
        cls = this.getRealClass(cls);
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        Class<?> z = cls;
        while (!z.equals(Object.class)) {
            if (z.getAnnotations() != null && z.getAnnotations().length != 0) {
                if (anCls.length == 0) {
                    ret.addAll(Arrays.asList(z.getAnnotations()));
                } else {
                    for (Annotation a : z.getAnnotations()) {
                        for (Class<? extends Annotation> ac : anCls) {
                            if (!a.annotationType().equals(ac)) continue;
                            ret.add(a);
                        }
                    }
                }
            }
            if ((z = z.getSuperclass()) != null) continue;
            break;
        }
        return ret;
    }

    public String getLastChangeField(Class<?> cls) {
        if (!this.storesLastChange(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, LastChange.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getLastAccessField(Class<?> cls) {
        if (!this.storesLastAccess(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, LastAccess.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getCreationTimeField(Class<?> cls) {
        if (!this.storesCreation(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, CreationTime.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public void callLifecycleMethod(Class<? extends Annotation> type, Object on) {
        if (on == null) {
            return;
        }
        Class<?> cls = on.getClass();
        if (!this.isAnnotationPresentInHierarchy(cls, Lifecycle.class)) {
            return;
        }
        if (this.lifeCycleMethods.get(cls) != null) {
            if (this.lifeCycleMethods.get(cls).get(type) != null) {
                try {
                    this.lifeCycleMethods.get(cls).get(type).invoke(on, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        HashMap<Class<? extends Annotation>, Method> methods = new HashMap<Class<? extends Annotation>, Method>();
        for (Method m : cls.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                methods.put(a.annotationType(), m);
            }
        }
        this.lifeCycleMethods.put(cls, methods);
        if (methods.get(type) != null) {
            try {
                ((Method)methods.get(type)).invoke(on, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isAsyncWrite(Class<?> cls) {
        AsyncWrites wb = this.getAnnotationFromHierarchy(cls, AsyncWrites.class);
        return wb != null && wb.value();
    }
}

