/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.logging;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    private final Date date = new Date();
    private final DateFormat dateformater = DateFormat.getDateTimeInstance(3, 2);

    @Override
    public String format(LogRecord record) {
        this.date.setTime(record.getMillis());
        StringBuilder sb = new StringBuilder();
        sb.append(this.dateformater.format(this.date));
        sb.append(" - ");
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append("@");
            sb.append(record.getSourceMethodName());
            sb.append("() ");
        }
        sb.append(": ");
        sb.append(record.getLevel().getName());
        sb.append(" - ");
        sb.append(record.getMessage());
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }
}

