/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Aliases;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.PartialUpdate;
import de.caluga.morphium.annotations.Property;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.query.Query;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class ObjectMapperImpl
implements ObjectMapper {
    private static Logger log = Logger.getLogger(ObjectMapperImpl.class);
    private static volatile Map<Class<?>, List<Field>> fieldCache = new Hashtable();
    public volatile Morphium morphium;
    private volatile Hashtable<Class<?>, NameProvider> nameProviders;

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium morphium) {
        this.morphium = morphium;
    }

    public ObjectMapperImpl(Morphium m) {
        this.morphium = m;
        this.nameProviders = new Hashtable();
    }

    public ObjectMapperImpl() {
        this(null);
    }

    @Override
    public String createCamelCase(String n, boolean capitalize) {
        n = n.toLowerCase();
        String[] f = n.split("_");
        StringBuilder sb = new StringBuilder(f[0].substring(0, 1).toLowerCase());
        sb.append(f[0].substring(1));
        for (int i = 1; i < f.length; ++i) {
            sb.append(f[i].substring(0, 1).toUpperCase());
            sb.append(f[i].substring(1));
        }
        String ret = sb.toString();
        if (capitalize) {
            ret = ret.substring(0, 1).toUpperCase() + ret.substring(1);
        }
        return ret;
    }

    @Override
    public String convertCamelCase(String n) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < n.length() - 1; ++i) {
            if (Character.isUpperCase(n.charAt(i)) && i > 0) {
                b.append("_");
            }
            b.append(n.substring(i, i + 1).toLowerCase());
        }
        b.append(n.substring(n.length() - 1));
        return b.toString();
    }

    @Override
    public void setNameProviderForClass(Class<?> cls, NameProvider np) {
        this.nameProviders.put(cls, np);
    }

    @Override
    public NameProvider getNameProviderForClass(Class<?> cls) {
        Entity e = this.morphium.getAnnotationFromHierarchy(cls, Entity.class);
        if (e == null) {
            throw new IllegalArgumentException("no entity annotation found");
        }
        try {
            return this.getNameProviderForClass(cls, e);
        }
        catch (Exception ex) {
            log.error((Object)"Error getting nameProvider", (Throwable)ex);
            throw new IllegalArgumentException("could not get name provicer", ex);
        }
    }

    private NameProvider getNameProviderForClass(Class<?> cls, Entity p) throws IllegalAccessException, InstantiationException {
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        if (this.nameProviders.get(cls) == null) {
            NameProvider np = p.nameProvider().newInstance();
            this.nameProviders.put(cls, np);
        }
        return this.nameProviders.get(cls);
    }

    @Override
    public String getCollectionName(Class cls) {
        if (this.morphium == null) {
            return null;
        }
        Entity p = this.morphium.getAnnotationFromHierarchy(cls, Entity.class);
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        try {
            cls = this.getRealClass(cls);
            NameProvider np = this.getNameProviderForClass(cls, p);
            return np.getCollectionName(cls, this, p.translateCamelCase(), p.useFQN(), p.collectionName().equals(".") ? null : p.collectionName(), this.morphium);
        }
        catch (InstantiationException e) {
            log.error((Object)("Could not instanciate NameProvider: " + p.nameProvider().getName()), (Throwable)e);
            throw new RuntimeException("Could not Instaciate NameProvider", e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal Access during instanciation of NameProvider: " + p.nameProvider().getName()), (Throwable)e);
            throw new RuntimeException("Illegal Access during instanciation", e);
        }
    }

    @Override
    public DBObject marshall(Object o) {
        if (!this.isEntity(o)) {
            throw new IllegalArgumentException("Object is no entity: " + o.getClass().getSimpleName());
        }
        BasicDBObject dbo = new BasicDBObject();
        if (o == null) {
            return dbo;
        }
        Class<?> cls = this.getRealClass(o.getClass());
        if (cls == null) {
            throw new IllegalArgumentException("No real class?");
        }
        o = this.getRealObject(o);
        List<String> flds = this.getFields(cls, new Class[0]);
        if (flds == null) {
            throw new IllegalArgumentException("Fields not found? " + cls.getName());
        }
        Entity e = this.morphium.getAnnotationFromHierarchy(o.getClass(), Entity.class);
        Embedded emb = this.morphium.getAnnotationFromHierarchy(o.getClass(), Embedded.class);
        if (e != null && e.polymorph()) {
            dbo.put("class_name", (Object)cls.getName());
        }
        if (emb != null && emb.polymorph()) {
            dbo.put("class_name", (Object)cls.getName());
        }
        Iterator<String> i$ = flds.iterator();
        while (i$.hasNext()) {
            String f;
            String fName = f = i$.next();
            try {
                Field fld = this.getField(cls, f);
                if (fld == null) {
                    log.error((Object)"Field not found");
                    continue;
                }
                if (Modifier.isStatic(fld.getModifiers())) continue;
                AdditionalData ad = fld.getAnnotation(AdditionalData.class);
                if (ad != null) {
                    if (ad.readOnly()) continue;
                    dbo.putAll((Map)fld.get(o));
                    continue;
                }
                if (fld.isAnnotationPresent(Id.class)) {
                    fName = "_id";
                }
                Object v = null;
                Object value = fld.get(o);
                if (fld.isAnnotationPresent(Reference.class)) {
                    Reference r = fld.getAnnotation(Reference.class);
                    if (value == null) {
                        v = null;
                    } else if (fld.getType().isAssignableFrom(List.class)) {
                        BasicDBList lst = new BasicDBList();
                        for (Object rec : (List)value) {
                            if (rec != null) {
                                ObjectId id = this.getId(rec);
                                if (id == null) {
                                    if (r.automaticStore()) {
                                        this.morphium.storeNoCache(rec);
                                        id = this.getId(rec);
                                    } else {
                                        throw new IllegalArgumentException("Cannot store reference to unstored entity if automaticStore in @Reference is set to false!");
                                    }
                                }
                                DBRef ref = new DBRef(this.morphium.getDatabase(), this.getRealClass(rec.getClass()).getName(), (Object)id);
                                lst.add((Object)ref);
                                continue;
                            }
                            lst.add(null);
                        }
                        v = lst;
                    } else {
                        if (fld.getType().isAssignableFrom(Map.class)) {
                            throw new RuntimeException("Cannot store references in Maps!");
                        }
                        if (this.getId(value) == null) {
                            if (r.automaticStore()) {
                                if (this.morphium == null) {
                                    log.fatal((Object)"Could not store - no Morphium set!");
                                } else {
                                    this.morphium.storeNoCache(value);
                                }
                            } else {
                                throw new IllegalArgumentException("Reference to be stored, that is null!");
                            }
                        }
                        v = this.getId(value);
                    }
                } else if (this.morphium.isAnnotationPresentInHierarchy(fld.getType(), Entity.class)) {
                    if (value != null) {
                        DBObject obj = this.marshall(value);
                        obj.removeField("_id");
                        v = obj;
                    }
                } else if (this.morphium.isAnnotationPresentInHierarchy(fld.getType(), Embedded.class)) {
                    if (value != null) {
                        v = this.marshall(value);
                    }
                } else {
                    v = value;
                    if (v != null) {
                        if (v instanceof Map) {
                            v = this.createDBMap((Map)v);
                        } else if (v instanceof List) {
                            v = this.createDBList((List)v);
                        } else if (v instanceof Iterable) {
                            ArrayList lst = new ArrayList();
                            for (Object i : (Iterable)v) {
                                lst.add(i);
                            }
                            v = this.createDBList(lst);
                        } else if (v.getClass().equals(GregorianCalendar.class)) {
                            v = ((GregorianCalendar)v).getTime();
                        } else if (v.getClass().isEnum()) {
                            v = ((Enum)v).name();
                        }
                    }
                }
                if (v == null && !fld.isAnnotationPresent(UseIfnull.class)) continue;
                dbo.put(fName, v);
            }
            catch (IllegalAccessException exc) {
                log.fatal((Object)("Illegal Access to field " + f));
            }
        }
        return dbo;
    }

    private BasicDBList createDBList(List v) {
        BasicDBList lst = new BasicDBList();
        for (Object lo : v) {
            if (lo != null) {
                if (this.morphium.isAnnotationPresentInHierarchy(lo.getClass(), Entity.class) || this.morphium.isAnnotationPresentInHierarchy(lo.getClass(), Embedded.class)) {
                    DBObject marshall = this.marshall(lo);
                    marshall.put("class_name", (Object)lo.getClass().getName());
                    lst.add((Object)marshall);
                    continue;
                }
                if (lo instanceof List) {
                    lst.add((Object)this.createDBList((List)lo));
                    continue;
                }
                if (lo instanceof Map) {
                    lst.add((Object)this.createDBMap((Map)lo));
                    continue;
                }
                if (lo.getClass().isEnum()) {
                    BasicDBObject obj = new BasicDBObject();
                    obj.put("class_name", (Object)lo.getClass().getName());
                    obj.put("name", (Object)((Enum)lo).name());
                    lst.add((Object)obj);
                    continue;
                }
                lst.add(lo);
                continue;
            }
            lst.add(null);
        }
        return lst;
    }

    private BasicDBObject createDBMap(Map v) {
        BasicDBObject dbMap = new BasicDBObject();
        for (Map.Entry es : v.entrySet()) {
            Object mval;
            Object k = es.getKey();
            if (!(k instanceof String)) {
                log.warn((Object)"Map in Mongodb needs to have String as keys - using toString");
                k = k.toString();
                if (((String)k).contains(".")) {
                    log.warn((Object)". not allowed as Key in Maps - converting to _");
                    k = ((String)k).replaceAll("\\.", "_");
                }
            }
            if ((mval = es.getValue()) != null) {
                DBObject obj;
                if (this.morphium.isAnnotationPresentInHierarchy(mval.getClass(), Entity.class) || this.morphium.isAnnotationPresentInHierarchy(mval.getClass(), Embedded.class)) {
                    obj = this.marshall(mval);
                    obj.put("class_name", (Object)mval.getClass().getName());
                    mval = obj;
                } else if (mval instanceof Map) {
                    mval = this.createDBMap((Map)mval);
                } else if (mval instanceof List) {
                    mval = this.createDBList((List)mval);
                } else if (mval.getClass().isEnum()) {
                    obj = new BasicDBObject();
                    obj.put("class_name", (Object)mval.getClass().getName());
                    obj.put("name", (Object)((Enum)mval).name());
                }
            }
            dbMap.put((String)k, mval);
        }
        return dbMap;
    }

    @Override
    public <T> T unmarshall(Class<T> cls, DBObject o) {
        try {
            if (o.get("class_name") != null || o.get("className") != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"overriding cls - it's defined in dbObject");
                }
                try {
                    String cN = (String)o.get("class_name");
                    if (cN == null) {
                        cN = (String)o.get("className");
                    }
                    cls = Class.forName(cN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (cls.isEnum()) {
                T[] en = cls.getEnumConstants();
                for (Enum e : (Enum[])en) {
                    if (!e.name().equals(o.get("name"))) continue;
                    return (T)e;
                }
            }
            T ret = cls.newInstance();
            List<String> flds = this.getFields(cls, new Class[0]);
            for (String f : flds) {
                Field fld = this.getField(cls, f);
                if (Modifier.isStatic(fld.getModifiers())) continue;
                if (fld.isAnnotationPresent(AdditionalData.class)) {
                    if (!fld.getType().isAssignableFrom(Map.class)) {
                        log.error((Object)("Could not unmarshall additional data into fld of type " + fld.getType().toString()));
                        continue;
                    }
                    Set keys = o.keySet();
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    for (String k : keys) {
                        if (flds.contains(k)) continue;
                        data.put(k, o.get(k));
                    }
                    fld.set(ret, data);
                    continue;
                }
                Object value = null;
                if (!fld.getType().isAssignableFrom(Map.class) && !fld.getType().isAssignableFrom(List.class) && fld.isAnnotationPresent(Reference.class)) {
                    Reference reference = fld.getAnnotation(Reference.class);
                    if (this.morphium == null) {
                        log.fatal((Object)"Morphium not set - could not de-reference!");
                    } else {
                        ObjectId id = null;
                        if (o.get(f) instanceof ObjectId) {
                            id = (ObjectId)o.get(f);
                        } else {
                            DBRef ref = (DBRef)o.get(f);
                            if (ref != null) {
                                id = (ObjectId)ref.getId();
                                if (!ref.getRef().equals(fld.getType().getName())) {
                                    log.warn((Object)"Reference to different object?! - continuing anyway");
                                }
                            }
                        }
                        if (id != null) {
                            if (reference.lazyLoading()) {
                                List<String> lst = this.getFields(fld.getType(), Id.class);
                                if (lst.size() == 0) {
                                    throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                }
                                value = this.morphium.createLazyLoadedEntity(fld.getType(), id);
                            } else {
                                value = this.morphium.findById(fld.getType(), id);
                            }
                        } else {
                            value = null;
                        }
                    }
                } else if (fld.isAnnotationPresent(Id.class)) {
                    value = (ObjectId)o.get("_id");
                } else if (this.morphium.isAnnotationPresentInHierarchy(fld.getType(), Entity.class) || this.morphium.isAnnotationPresentInHierarchy(fld.getType(), Embedded.class)) {
                    value = o.get(f) != null ? this.unmarshall(fld.getType(), (DBObject)o.get(f)) : null;
                } else if (fld.getType().isAssignableFrom(Map.class)) {
                    BasicDBObject map = (BasicDBObject)o.get(f);
                    value = this.createMap(map);
                } else if (fld.getType().isAssignableFrom(List.class) || fld.getType().isArray()) {
                    BasicDBList l = (BasicDBList)o.get(f);
                    ArrayList lst = new ArrayList();
                    if (l != null) {
                        this.fillList(fld, l, lst);
                        if (fld.getType().isArray()) {
                            Object arr = Array.newInstance(fld.getType().getComponentType(), lst.size());
                            for (int i = 0; i < lst.size(); ++i) {
                                Array.set(arr, i, lst.get(i));
                            }
                            value = arr;
                        } else {
                            value = lst;
                        }
                    } else {
                        value = l;
                    }
                } else if (fld.getType().isEnum()) {
                    if (o.get(f) != null) {
                        value = Enum.valueOf(fld.getType(), (String)o.get(f));
                    }
                } else {
                    value = o.get(f);
                }
                this.setValue(ret, value, f);
            }
            if (this.morphium.isAnnotationPresentInHierarchy(cls, Entity.class)) {
                flds = this.getFields(cls, Id.class);
                if (flds.isEmpty()) {
                    throw new RuntimeException("Error - class does not have an ID field!");
                }
                this.getField(cls, flds.get(0)).set(ret, o.get("_id"));
            }
            if (this.morphium.isAnnotationPresentInHierarchy(cls, PartialUpdate.class) || cls.isInstance(PartiallyUpdateable.class)) {
                return this.morphium.createPartiallyUpdateableEntity(ret);
            }
            return ret;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object createMap(BasicDBObject map) {
        BasicDBObject value;
        if (map != null) {
            for (String n : map.keySet()) {
                if (map.get(n) instanceof BasicDBObject) {
                    Object val = map.get(n);
                    if (((BasicDBObject)val).containsField("class_name") || ((BasicDBObject)val).containsField("className")) {
                        String cn = (String)((BasicDBObject)val).get("class_name");
                        if (cn == null) {
                            cn = (String)((BasicDBObject)val).get("className");
                        }
                        try {
                            Class<?> ecls = Class.forName(cn);
                            map.put(n, this.unmarshall(ecls, (DBObject)map.get(n)));
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    map.put(n, this.createMap((BasicDBObject)val));
                    continue;
                }
                if (!(map.get(n) instanceof BasicDBList)) continue;
                BasicDBList lst = (BasicDBList)map.get(n);
                List mapValue = this.createList(lst);
                map.put(n, (Object)mapValue);
            }
            value = map;
        } else {
            value = null;
        }
        return value;
    }

    private List createList(BasicDBList lst) {
        ArrayList<Object> mapValue = new ArrayList<Object>();
        for (Object li : lst) {
            if (li instanceof BasicDBObject) {
                if (((BasicDBObject)li).containsField("class_name") || ((BasicDBObject)li).containsField("className")) {
                    String cn = (String)((BasicDBObject)li).get("class_name");
                    if (cn == null) {
                        cn = (String)((BasicDBObject)li).get("className");
                    }
                    try {
                        Class<?> ecls = Class.forName(cn);
                        mapValue.add(this.unmarshall(ecls, (DBObject)li));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                mapValue.add(this.createMap((BasicDBObject)li));
                continue;
            }
            if (li instanceof BasicDBList) {
                mapValue.add(this.createList((BasicDBList)li));
                continue;
            }
            mapValue.add(li);
        }
        return mapValue;
    }

    private void fillList(Field forField, BasicDBList fromDB, List toFillIn) {
        for (Object val : fromDB) {
            if (val instanceof BasicDBObject) {
                if (((BasicDBObject)val).containsField("class_name") || ((BasicDBObject)val).containsField("className")) {
                    String cn = (String)((BasicDBObject)val).get("class_name");
                    if (cn == null) {
                        cn = (String)((BasicDBObject)val).get("className");
                    }
                    try {
                        Class<?> ecls = Class.forName(cn);
                        toFillIn.add(this.unmarshall(ecls, (DBObject)val));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                toFillIn.add(val);
                continue;
            }
            if (val instanceof ObjectId) {
                log.fatal((Object)"Cannot de-reference to unknown collection");
                continue;
            }
            if (val instanceof BasicDBList) {
                ArrayList lt = new ArrayList();
                this.fillList(null, (BasicDBList)val, lt);
                toFillIn.add(lt);
                continue;
            }
            if (val instanceof DBRef) {
                try {
                    Reference reference;
                    DBRef ref = (DBRef)val;
                    ObjectId id = (ObjectId)ref.getId();
                    Class<?> clz = Class.forName(ref.getRef());
                    List<String> idFlds = this.getFields(clz, Id.class);
                    Reference reference2 = reference = forField != null ? forField.getAnnotation(Reference.class) : null;
                    if (reference != null && reference.lazyLoading()) {
                        if (idFlds.size() == 0) {
                            throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                        }
                        toFillIn.add(this.morphium.createLazyLoadedEntity(clz, id));
                        continue;
                    }
                    Query<Object> q = this.morphium.createQueryFor(clz);
                    q = q.f(idFlds.get(0)).eq(id);
                    toFillIn.add(q.get());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            toFillIn.add(val);
        }
    }

    @Override
    public ObjectId getId(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Class<?> cls = this.getRealClass(o.getClass());
        List<String> flds = this.getFields(cls, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new IllegalArgumentException("Object has no id defined: " + o.getClass().getSimpleName());
        }
        Field f = this.getField(cls, flds.get(0));
        if (f == null) {
            throw new IllegalArgumentException("Object ID field not found " + o.getClass().getSimpleName());
        }
        try {
            if (!f.getType().equals(ObjectId.class)) {
                throw new IllegalArgumentException("ID sould be of type ObjectId");
            }
            if ((o = this.getRealObject(o)) != null) {
                return (ObjectId)f.get(o);
            }
            log.warn((Object)"Illegal reference?");
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Field> getAllFields(Class clz) {
        Class cls = this.getRealClass(clz);
        if (fieldCache.containsKey(cls)) {
            return fieldCache.get(cls);
        }
        Vector<Field> ret = new Vector<Field>();
        Class sc = cls;
        Vector hierachy = new Vector();
        while (!sc.equals(Object.class)) {
            hierachy.add(sc);
            sc = sc.getSuperclass();
        }
        for (Class<?> c : cls.getInterfaces()) {
            hierachy.add(c);
        }
        for (int i = hierachy.size() - 1; i >= 0; --i) {
            Class c = (Class)hierachy.get(i);
            for (Field f : c.getDeclaredFields()) {
                ret.add(f);
            }
        }
        fieldCache.put(cls, ret);
        return ret;
    }

    @Override
    public List<String> getFields(Class cls, Class<? extends Annotation> ... annotations) {
        Vector<String> ret = new Vector<String>();
        Class sc = cls;
        sc = this.getRealClass(sc);
        Entity entity = this.morphium.getAnnotationFromHierarchy(sc, Entity.class);
        Embedded embedded = this.morphium.getAnnotationFromHierarchy(sc, Embedded.class);
        if (embedded != null && entity != null) {
            log.warn((Object)("Class " + cls.getName() + " does have both @Entity and @Embedded Annotations - not allowed! Assuming @Entity is right"));
        }
        if (embedded == null && entity == null) {
            throw new IllegalArgumentException("This class " + cls.getName() + " does not have @Entity or @Embedded set, not even in hierachy - illegal!");
        }
        boolean tcc = entity == null ? embedded.translateCamelCase() : entity.translateCamelCase();
        List<Field> fld = this.getAllFields(cls);
        for (Field f : fld) {
            if (annotations.length > 0) {
                boolean found = false;
                for (Class<? extends Annotation> a : annotations) {
                    if (!f.isAnnotationPresent(a)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (f.isAnnotationPresent(Reference.class) && !".".equals(f.getAnnotation(Reference.class).fieldName())) {
                ret.add(f.getAnnotation(Reference.class).fieldName());
                continue;
            }
            if (f.isAnnotationPresent(Property.class) && !".".equals(f.getAnnotation(Property.class).fieldName())) {
                ret.add(f.getAnnotation(Property.class).fieldName());
                continue;
            }
            if (f.isAnnotationPresent(Transient.class)) continue;
            if (tcc) {
                ret.add(this.convertCamelCase(f.getName()));
                continue;
            }
            ret.add(f.getName());
        }
        return ret;
    }

    @Override
    public <T> Class<T> getRealClass(Class<T> sc) {
        if (sc.getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                sc = Class.forName(sc.getName().substring(0, sc.getName().indexOf("$$")));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sc;
    }

    @Override
    public String getFieldName(Class clz, String field) {
        Annotation p;
        Class cls = this.getRealClass(clz);
        if (field.contains(".")) {
            return field;
        }
        Field f = this.getField(cls, field);
        if (f == null) {
            throw new RuntimeException("Field not found " + field + " in cls: " + clz.getName());
        }
        if (f.isAnnotationPresent(Property.class) && (p = f.getAnnotation(Property.class)).fieldName() != null && !p.fieldName().equals(".")) {
            return p.fieldName();
        }
        if (f.isAnnotationPresent(Reference.class) && (p = f.getAnnotation(Reference.class)).fieldName() != null && !p.fieldName().equals(".")) {
            return p.fieldName();
        }
        if (f.isAnnotationPresent(Id.class)) {
            return "_id";
        }
        String fieldName = f.getName();
        Entity ent = this.morphium.getAnnotationFromHierarchy(cls, Entity.class);
        Embedded emb = this.morphium.getAnnotationFromHierarchy(cls, Embedded.class);
        if (ent != null && ent.translateCamelCase()) {
            fieldName = this.convertCamelCase(fieldName);
        } else if (emb != null && emb.translateCamelCase()) {
            fieldName = this.convertCamelCase(fieldName);
        }
        return fieldName;
    }

    @Override
    public Field getField(Class clz, String fld) {
        Class cls = this.getRealClass(clz);
        List<Field> flds = this.getAllFields(cls);
        for (Field f : flds) {
            if (f.isAnnotationPresent(Property.class) && f.getAnnotation(Property.class).fieldName() != null && !".".equals(f.getAnnotation(Property.class).fieldName()) && f.getAnnotation(Property.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                return f;
            }
            if (f.isAnnotationPresent(Reference.class) && f.getAnnotation(Reference.class).fieldName() != null && !".".equals(f.getAnnotation(Reference.class).fieldName()) && f.getAnnotation(Reference.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                return f;
            }
            if (f.isAnnotationPresent(Aliases.class)) {
                String[] v;
                Aliases aliases = f.getAnnotation(Aliases.class);
                for (String field : v = aliases.value()) {
                    if (!field.equals(fld)) continue;
                    f.setAccessible(true);
                    return f;
                }
            }
            if (fld.equals("_id") && f.isAnnotationPresent(Id.class)) {
                f.setAccessible(true);
                return f;
            }
            if (f.getName().equals(fld)) {
                f.setAccessible(true);
                return f;
            }
            if (!this.convertCamelCase(f.getName()).equals(fld)) continue;
            f.setAccessible(true);
            return f;
        }
        return null;
    }

    @Override
    public boolean isEntity(Object o) {
        Class<Object> cls = null;
        if (o == null) {
            return false;
        }
        cls = o instanceof Class ? this.getRealClass((Class)o) : this.getRealClass(o.getClass());
        return this.morphium.isAnnotationPresentInHierarchy(cls, Entity.class) || this.morphium.isAnnotationPresentInHierarchy(cls, Embedded.class);
    }

    @Override
    public Object getValue(Object o, String fld) {
        if (o == null) {
            return null;
        }
        try {
            Field f = this.getField(o.getClass(), fld);
            if (!Modifier.isStatic(f.getModifiers())) {
                o = this.getRealObject(o);
                return f.get(o);
            }
        }
        catch (IllegalAccessException e) {
            log.fatal((Object)("Illegal access to field " + fld + " of type " + o.getClass().getSimpleName()));
        }
        return null;
    }

    @Override
    public void setValue(Object o, Object value, String fld) {
        block60: {
            if (o == null) {
                return;
            }
            try {
                Field f = this.getField(this.getRealClass(o.getClass()), fld);
                if (Modifier.isStatic(f.getModifiers())) break block60;
                o = this.getRealObject(o);
                try {
                    f.set(o, value);
                }
                catch (Exception e) {
                    if (value == null) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting of value (" + value.getClass().getSimpleName() + ") failed for field " + f.getName() + "- trying type-conversion"));
                    }
                    if (value instanceof Double) {
                        Double d = (Double)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, d.intValue());
                            break block60;
                        }
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.longValue());
                            break block60;
                        }
                        if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(d.longValue()));
                            break block60;
                        }
                        if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(d.floatValue()));
                            break block60;
                        }
                        if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, d == 1.0);
                            break block60;
                        }
                        if (f.getType().equals(String.class)) {
                            f.set(o, d.toString());
                            break block60;
                        }
                        throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                    }
                    if (value instanceof Float) {
                        Float d = (Float)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, d.intValue());
                            break block60;
                        }
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.longValue());
                            break block60;
                        }
                        if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(d.longValue()));
                            break block60;
                        }
                        if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(d.floatValue()));
                            break block60;
                        }
                        if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, d.floatValue() == 1.0f);
                            break block60;
                        }
                        if (f.getType().equals(String.class)) {
                            f.set(o, d.toString());
                            break block60;
                        }
                        throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                    }
                    if (value instanceof Date) {
                        Date d = (Date)value;
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, d.getTime());
                        } else if (f.getType().equals(GregorianCalendar.class)) {
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTimeInMillis(d.getTime());
                            f.set(o, cal);
                        } else if (f.getType().equals(String.class)) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                            f.set(o, df.format(d));
                        }
                        break block60;
                    }
                    if (value instanceof String) {
                        try {
                            String s = (String)value;
                            if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                                f.set(o, Long.parseLong(s));
                                break block60;
                            }
                            if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                                f.set(o, Integer.parseInt(s));
                                break block60;
                            }
                            if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                                f.set(o, Double.parseDouble(s));
                                break block60;
                            }
                            if (f.getType().equals(Date.class)) {
                                if (s.length() == 8) {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                                    f.set(o, df.parse(s));
                                } else if (s.indexOf("-") > 0) {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                                    f.set(o, df.parse(s));
                                } else if (s.indexOf(".") > 0) {
                                    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
                                    f.set(o, df.parse(s));
                                } else {
                                    f.set(o, new Date(Long.parseLong(s)));
                                }
                                break block60;
                            }
                            if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                                f.set(o, s.equalsIgnoreCase("true"));
                                break block60;
                            }
                            if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                                f.set(o, Float.valueOf(Float.parseFloat(s)));
                                break block60;
                            }
                            throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                        }
                        catch (ParseException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                    if (value instanceof Integer) {
                        Integer i = (Integer)value;
                        if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                            f.set(o, (int)i);
                            break block60;
                        }
                        if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, i.doubleValue());
                            break block60;
                        }
                        if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(i.longValue()));
                            break block60;
                        }
                        if (f.getType().equals(String.class)) {
                            f.set(o, i.toString());
                            break block60;
                        }
                        if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(i.floatValue()));
                            break block60;
                        }
                        if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, i == 1);
                            break block60;
                        }
                        throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                    }
                    if (value instanceof Long) {
                        Long l = (Long)value;
                        if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                            f.set(o, l.intValue());
                            break block60;
                        }
                        if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                            f.set(o, l.doubleValue());
                            break block60;
                        }
                        if (f.getType().equals(Date.class)) {
                            f.set(o, new Date(l));
                            break block60;
                        }
                        if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                            f.set(o, Float.valueOf(l.floatValue()));
                            break block60;
                        }
                        if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                            f.set(o, l == 1L);
                            break block60;
                        }
                        if (f.getType().equals(String.class)) {
                            f.set(o, l.toString());
                            break block60;
                        }
                        throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                    }
                    if (!(value instanceof Boolean)) break block60;
                    Boolean b = (Boolean)value;
                    if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                        f.set(o, b != false ? 1 : 0);
                        break block60;
                    }
                    if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                        f.set(o, b != false ? 1.0 : 0.0);
                        break block60;
                    }
                    if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                        f.set(o, Float.valueOf(b != false ? 1.0f : 0.0f));
                        break block60;
                    }
                    if (f.getType().equals(String.class)) {
                        f.set(o, b != false ? "true" : "false");
                        break block60;
                    }
                    throw new RuntimeException("could not set field " + fld + ": Field has type " + f.getType().toString() + " got type " + value.getClass().toString());
                }
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)("Illegal access to field " + fld + " of toype " + o.getClass().getSimpleName()));
                return;
            }
        }
    }

    @Override
    public <T> T getRealObject(T o) {
        if (o.getClass().getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                Field f1 = o.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                f1.setAccessible(true);
                Object delegate = f1.get(o);
                Method m = delegate.getClass().getMethod("__getDeref", new Class[0]);
                o = m.invoke(delegate, new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)"Exception: ", (Throwable)e);
            }
        }
        return o;
    }
}

