/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class MorphiumIteratorImpl<T>
implements MorphiumIterator<T> {
    private int windowSize = 1;
    private Query<T> theQuery;
    private List<T> buffer;
    private int cursor = 0;
    private long count = 0L;
    private Logger log = Logger.getLogger(MorphiumIterator.class);

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return (long)this.cursor < this.count;
    }

    @Override
    public T next() {
        if ((long)this.cursor > this.count) {
            return null;
        }
        int idx = this.cursor % this.windowSize;
        if (this.buffer == null || idx == 0) {
            this.theQuery.skip(this.cursor);
            if (this.count - (long)this.cursor < (long)this.windowSize) {
                this.theQuery.limit((int)(this.count - (long)this.cursor));
            } else {
                this.theQuery.limit(this.windowSize);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reached window boundary - reading in: skip:" + this.cursor + " limit:" + this.windowSize));
            }
            this.buffer = this.theQuery.asList();
        }
        ++this.cursor;
        return this.buffer.get(idx);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not possible on MorphiumIterators");
    }

    @Override
    public void setWindowSize(int sz) {
        this.windowSize = sz;
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setQuery(Query<T> q) {
        try {
            this.theQuery = q.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.count = this.theQuery.countAll();
    }

    @Override
    public Query<T> getQuery() {
        return this.theQuery;
    }

    @Override
    public int getCurrentBufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.size();
    }

    @Override
    public List<T> getCurrentBuffer() {
        return this.buffer;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public void ahead(int jump) {
        this.cursor += jump;
    }

    @Override
    public void back(int jump) {
        this.cursor -= jump;
    }
}

