/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.SafetyLevel;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.MsgType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

@Entity
@NoCache
@WriteSafety(level=SafetyLevel.WAIT_FOR_ALL_SLAVES, timeout=0, waitForJournalCommit=true, waitForSync=true)
@DefaultReadPreference(value=ReadPreferenceLevel.NEAREST)
@Lifecycle
@Index(value={"sender,locked_by,processed_by,to,-timestamp", "locked_by,processed_by,to,timestamp"})
public class Msg {
    @Index
    private List<String> processedBy;
    @Id
    private ObjectId msgId;
    @Index
    private String lockedBy = "ALL";
    @Index
    private long locked;
    private MsgType type;
    private long ttl;
    private String sender;
    private List<String> to;
    private ObjectId inAnswerTo;
    private String name;
    private String msg;
    private List<String> additional;
    private Map<String, Object> mapValue;
    private String value;
    @Index
    private long timestamp;
    @Transient
    private Boolean exclusive = false;

    public Msg() {
    }

    public Msg(String name, String msg, String value) {
        this(name, MsgType.MULTI, msg, value, 30000L);
    }

    public Msg(String name, MsgType t, String msg, String value, long ttl) {
        this();
        this.name = name;
        this.msg = msg;
        this.value = value;
        this.type = t;
        this.ttl = ttl;
    }

    public boolean isExclusive() {
        if (this.exclusive == null) {
            return this.getLockedBy() != null && !this.getLockedBy().equals("ALL");
        }
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.lockedBy = !exclusive ? "ALL" : null;
        this.exclusive = exclusive;
    }

    public void addRecipient(String id) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        if (!this.to.contains(id)) {
            this.to.add(id);
        }
    }

    public void removeRecipient(String id) {
        if (this.to == null) {
            return;
        }
        this.to.remove(id);
    }

    public void addValue(String key, Object value) {
        if (this.mapValue == null) {
            this.mapValue = new HashMap<String, Object>();
        }
        this.mapValue.put(key, value);
    }

    public void removeValue(String key) {
        if (this.mapValue == null) {
            return;
        }
        this.mapValue.remove(key);
    }

    public Map<String, Object> getMapValue() {
        return this.mapValue;
    }

    public void setMapValue(Map<String, Object> mapValue) {
        this.mapValue = mapValue;
    }

    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public ObjectId getInAnswerTo() {
        return this.inAnswerTo;
    }

    public void setInAnswerTo(ObjectId inAnswerTo) {
        this.inAnswerTo = inAnswerTo;
    }

    public ObjectId getMsgId() {
        return this.msgId;
    }

    public void setMsgId(ObjectId msgId) {
        this.msgId = msgId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public List<String> getProcessedBy() {
        return this.processedBy;
    }

    public void setProcessedBy(List<String> processedBy) {
        this.processedBy = processedBy;
    }

    public void addProcessedId(String id) {
        if (this.processedBy == null) {
            this.processedBy = new ArrayList<String>();
        }
        this.processedBy.add(id);
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(String lockedBy) {
        this.lockedBy = lockedBy;
    }

    public long getLocked() {
        return this.locked;
    }

    public void setLocked(long locked) {
        this.locked = locked;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public MsgType getType() {
        return this.type;
    }

    public void setType(MsgType type) {
        this.type = type;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<String> getAdditional() {
        return this.additional;
    }

    public void setAdditional(List<String> additional) {
        this.additional = additional;
    }

    public void addAdditional(String value) {
        if (this.additional == null) {
            this.additional = new ArrayList<String>();
        }
        this.additional.add(value);
    }

    public void removeAdditional(String value) {
        if (this.additional == null) {
            return;
        }
        this.additional.remove(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Msg{ msgId='" + this.msgId + '\'' + ", inAnswerTo='" + this.inAnswerTo + '\'' + ", lockedBy='" + this.lockedBy + '\'' + ", locked=" + this.locked + ", type=" + (Object)((Object)this.type) + ", ttl=" + this.ttl + ", sender='" + this.sender + '\'' + ", name='" + this.name + '\'' + ", msg='" + this.msg + '\'' + ", value='" + this.value + '\'' + ", timestamp=" + this.timestamp + ", additional='" + this.additional + '\'' + ", mapValue='" + this.mapValue + '\'' + ", recipients='" + this.to + '\'' + ", processedBy=" + this.processedBy + '}';
    }

    @PreStore
    public void preStore() {
        if (this.sender == null) {
            throw new RuntimeException("Cannot send msg anonymously - set Sender first!");
        }
        if (this.type == null) {
            Logger.getLogger(Msg.class).warn((Object)"Messagetype not set - using SINGLE");
            this.type = MsgType.SINGLE;
        }
        if (this.name == null) {
            throw new RuntimeException("Cannot send a message without name!");
        }
        if (this.ttl == 0L) {
            Logger.getLogger(Msg.class).warn((Object)"Defaulting msg ttl to 30sec");
            this.ttl = 30000L;
        }
        if (!this.exclusive.booleanValue()) {
            this.locked = System.currentTimeMillis();
            this.lockedBy = "ALL";
        }
        this.timestamp = System.currentTimeMillis();
    }

    public Msg createAnswerMsg() {
        Msg ret = new Msg(this.name, this.type, this.msg, this.value, this.ttl);
        ret.setInAnswerTo(this.msgId);
        ret.addRecipient(this.sender);
        return ret;
    }

    public void sendAnswer(Messaging messaging, Msg m) {
        m.setInAnswerTo(this.msgId);
        m.addRecipient(this.getSender());
        messaging.queueMessage(m);
    }

    public static enum Fields {
        processedBy,
        lockedBy,
        msgId,
        locked,
        type,
        inAnswerTo,
        to,
        msg,
        additional,
        value,
        timestamp,
        sender,
        ttl;

    }
}

