/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumSingleton;
import de.caluga.morphium.Sequence;
import de.caluga.morphium.query.Query;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class SequenceGenerator {
    private int inc;
    private long startValue;
    private Morphium morphium;
    private String id;
    private String name;
    private static Logger log = Logger.getLogger(SequenceGenerator.class);

    public SequenceGenerator() {
        this(MorphiumSingleton.get(), "seq", 1, 1L);
    }

    public SequenceGenerator(Morphium m, String n) {
        this(m, n, 1, 1L);
    }

    public SequenceGenerator(Morphium mrph, String name, int inc, long startValue) {
        this.inc = inc;
        if (inc == 0) {
            throw new IllegalArgumentException("Cannot use increment value 0!");
        }
        this.name = name;
        this.startValue = startValue;
        this.morphium = mrph;
        this.id = UUID.randomUUID().toString();
        if (!this.morphium.getDatabase().collectionExists(this.morphium.getConfig().getMapper().getCollectionName(Sequence.class)) || this.morphium.createQueryFor(Sequence.class).f("name").eq(name).countAll() == 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sequence does not exist yet... inserting");
            }
            Sequence s = new Sequence();
            s.setCurrentValue(startValue - (long)inc);
            s.setName(name);
            s.setId(new ObjectId(new Date(0L), name.hashCode()));
            this.morphium.storeNoCache(s);
        }
    }

    public long getCurrentValue() {
        Sequence s = (Sequence)this.morphium.createQueryFor(Sequence.class).f("name").eq(this.name).get();
        if (s == null || s.getCurrentValue() == null) {
            return this.getNextValue(1);
        }
        return s.getCurrentValue();
    }

    public long getNextValue() {
        return this.getNextValue(0);
    }

    private synchronized long getNextValue(int recLevel) {
        Sequence s;
        if (recLevel > 10) {
            log.error((Object)("Could not get lock on Sequence " + this.name));
            throw new RuntimeException("Getting lock on sequence " + this.name + " failed!");
        }
        Query<Sequence> seq = this.morphium.createQueryFor(Sequence.class);
        if ((seq = seq.f("name").eq(this.name)).countAll() == 0L) {
            log.error((Object)"Sequence vanished?");
            throw new RuntimeException("Sequence vanished");
        }
        seq = this.morphium.createQueryFor(Sequence.class);
        seq.f("name").eq(this.name).f("lockedBy").eq(null);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("locked_by", this.id);
        this.morphium.set(seq, values, false, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)"loced sequence entry");
        }
        seq = this.morphium.createQueryFor(Sequence.class);
        seq.f("name").eq(this.name).f("lockedBy").eq(this.id);
        if (seq.countAll() == 0L) {
            log.warn((Object)"Locking failed - recursing");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return this.getNextValue(recLevel + 1);
        }
        if (seq.countAll() > 1L) {
            log.error((Object)"sequence name / locked by not unique??? - using first");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found it!");
        }
        this.morphium.inc(seq, "currentValue", this.inc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"increased it");
        }
        if ((s = seq.get()) == null) {
            log.error((Object)"locked Sequence not found anymore?");
            seq = MorphiumSingleton.get().createQueryFor(Sequence.class).f("name").eq(this.name);
            for (Sequence sq : seq.asList()) {
                log.error((Object)("Sequence: " + sq.toString()));
            }
            return -1L;
        }
        s.setLockedBy(null);
        this.morphium.store(s);
        if (log.isDebugEnabled()) {
            log.debug((Object)"unlocked it");
        }
        return s.getCurrentValue();
    }

    public int getInc() {
        return this.inc;
    }

    public void setInc(int inc) {
        this.inc = inc;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public void setStartValue(long startValue) {
        this.startValue = startValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Morphium getMorphium() {
        return this.morphium;
    }

    public void setMorphium(Morphium morphium) {
        this.morphium = morphium;
    }
}

