/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.sgen.AppendTextAsTokenInstruction;
import de.calamanari.adl.util.sgen.AppendTextInstruction;
import de.calamanari.adl.util.sgen.IdFilterReuseExpressionInstruction;
import de.calamanari.adl.util.sgen.OutputLimitOverrideTemplateInstruction;
import de.calamanari.adl.util.sgen.ReuseCompositeExpressionInstruction;
import de.calamanari.adl.util.sgen.ReuseOpaqueExpressionInstruction;
import de.calamanari.adl.util.sgen.StatelessInstruction;
import de.calamanari.adl.util.sgen.TemplateInstruction;
import de.calamanari.adl.util.sgen.TemplateParseException;
import java.util.ArrayList;
import java.util.List;

public class TemplateInstructionParser {
    public List<TemplateInstruction> parse(String templateExpression) {
        ArrayList<TemplateInstruction> res = new ArrayList<TemplateInstruction>();
        StringBuilder currentPlainTextPart = new StringBuilder();
        int len = templateExpression.length();
        for (int idx = 0; idx < len; ++idx) {
            char ch = templateExpression.charAt(idx);
            if (ch == '$' && idx < len - 1 && templateExpression.charAt(idx + 1) == '{') {
                int idxClose;
                idx = idxClose = this.handleInstructionToken(templateExpression, idx, res, currentPlainTextPart);
                continue;
            }
            if (ch == '~') {
                this.handlePendingPlainText(currentPlainTextPart, res);
                res.add(StatelessInstruction.OPTIONAL_WHITESPACE_OR_COMMENT);
                continue;
            }
            if (ch == '_') {
                this.handlePendingPlainText(currentPlainTextPart, res);
                res.add(StatelessInstruction.MANDATORY_WHITESPACE_OR_COMMENT);
                continue;
            }
            currentPlainTextPart.append(ch);
        }
        this.handlePendingPlainText(currentPlainTextPart, res);
        if (res.isEmpty()) {
            res.add(new AppendTextInstruction(""));
        }
        return res;
    }

    private void handlePendingPlainText(StringBuilder currentPlainTextPart, List<TemplateInstruction> res) {
        if (!currentPlainTextPart.isEmpty()) {
            res.add(new AppendTextInstruction(currentPlainTextPart.toString()));
            currentPlainTextPart.setLength(0);
        }
    }

    private int handleInstructionToken(String templateExpression, int idx, List<TemplateInstruction> res, StringBuilder currentPlainTextPart) {
        TemplateInstruction instruction;
        int idxClose;
        this.handlePendingPlainText(currentPlainTextPart, res);
        String argument = null;
        int idxStart = idx + 2;
        int idxColon = templateExpression.indexOf(58, idxStart);
        int idxEnd = idxClose = templateExpression.indexOf(125, idxStart);
        if (idxColon > -1 && idxColon < idxClose) {
            argument = templateExpression.substring(idxColon + 1, idxClose).strip();
            idxEnd = idxColon;
        }
        if (idxClose > 0) {
            String instructionName = templateExpression.substring(idxStart, idxEnd);
            int overrideOutputLimit = -1;
            if (instructionName.endsWith("!")) {
                overrideOutputLimit = 0;
                instructionName = instructionName.substring(0, instructionName.length() - 1);
            } else if (instructionName.endsWith("*")) {
                overrideOutputLimit = 10000;
                instructionName = instructionName.substring(0, instructionName.length() - 1);
            }
            instruction = this.createInstruction(instructionName, argument);
            this.validateInstruction(instruction, templateExpression, instructionName, argument);
            if (overrideOutputLimit >= 0) {
                instruction = new OutputLimitOverrideTemplateInstruction(instruction, overrideOutputLimit);
            }
        } else {
            throw new TemplateParseException("Instruction not closed ${... in " + templateExpression);
        }
        res.add(instruction);
        return idxClose;
    }

    private void validateInstruction(TemplateInstruction instruction, String templateExpression, String instructionName, String argument) {
        if (instruction == null && argument != null) {
            throw new TemplateParseException("Usupported instruction in ${" + instructionName + ":" + argument + "} in expression " + templateExpression);
        }
        if (instruction == null) {
            throw new TemplateParseException("Usupported instruction ${" + instructionName + "} in " + templateExpression);
        }
        if (!(instruction instanceof IdFilterReuseExpressionInstruction) && !(instruction instanceof AppendTextAsTokenInstruction) && argument != null) {
            throw new TemplateParseException("Usupported text constant instruction in ${" + instructionName + ":" + argument + "} in " + templateExpression);
        }
    }

    private TemplateInstruction createInstruction(String instructionName, String argument) {
        String normalized = instructionName.strip().toUpperCase();
        argument = argument == null ? "" : argument.strip();
        switch (normalized) {
            case "ALL": {
                return StatelessInstruction.ALL;
            }
            case "NONE": {
                return StatelessInstruction.NONE;
            }
            case "ARG_NAME": {
                return argument.isEmpty() ? StatelessInstruction.ARG_NAME : new AppendTextAsTokenInstruction(StatelessInstruction.ARG_NAME, argument);
            }
            case "ARG_VALUE": {
                return argument.isEmpty() ? StatelessInstruction.ARG_VALUE : new AppendTextAsTokenInstruction(StatelessInstruction.ARG_VALUE, argument);
            }
            case "ARG_REF": {
                return argument.isEmpty() ? StatelessInstruction.ARG_REF : new AppendTextAsTokenInstruction(StatelessInstruction.ARG_REF, argument);
            }
            case "IS": {
                return StatelessInstruction.IS;
            }
            case "NOT": {
                return StatelessInstruction.NOT;
            }
            case "UNKNOWN": {
                return StatelessInstruction.UNKNOWN;
            }
            case "OP": {
                return argument.isEmpty() ? StatelessInstruction.OP : new AppendTextAsTokenInstruction(StatelessInstruction.OP, argument);
            }
            case "STRICT": {
                return StatelessInstruction.STRICT;
            }
            case "ANY": {
                return StatelessInstruction.ANY;
            }
            case "OF": {
                return StatelessInstruction.OF;
            }
            case "MIXED_LIST": {
                return StatelessInstruction.MIXED_LIST;
            }
            case "CONTAINS": {
                return StatelessInstruction.CONTAINS;
            }
            case "SNIPPET": {
                return argument.isEmpty() ? StatelessInstruction.SNIPPET : new AppendTextAsTokenInstruction(StatelessInstruction.SNIPPET, argument);
            }
            case "SNIPPET_LIST": {
                return StatelessInstruction.SNIPPET_LIST;
            }
            case "BETWEEN": {
                return StatelessInstruction.BETWEEN;
            }
            case "BOUND": {
                return argument.isEmpty() ? StatelessInstruction.BOUND : new AppendTextAsTokenInstruction(StatelessInstruction.BOUND, argument);
            }
            case "COMMENT": {
                return argument.isEmpty() ? StatelessInstruction.COMMENT : new AppendTextAsTokenInstruction(StatelessInstruction.COMMENT, argument);
            }
            case "AND": {
                return StatelessInstruction.AND;
            }
            case "OR": {
                return StatelessInstruction.OR;
            }
            case "CURB": {
                return StatelessInstruction.CURB;
            }
            case "OPAQUE_EXPRESSION": {
                return new ReuseOpaqueExpressionInstruction();
            }
            case "COMPOSITE_EXPRESSION": {
                return new ReuseCompositeExpressionInstruction();
            }
            case "EXPRESSION": {
                return argument.isEmpty() ? null : new IdFilterReuseExpressionInstruction(argument);
            }
        }
        return null;
    }
}

