/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.TriFunction;
import de.calamanari.adl.util.sgen.GenDataUtils;
import de.calamanari.adl.util.sgen.SampleExpression;
import de.calamanari.adl.util.sgen.SampleExpressionOperator;
import de.calamanari.adl.util.sgen.SampleGenInfo;
import de.calamanari.adl.util.sgen.TemplateInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;

public enum StatelessInstruction implements TemplateInstruction
{
    MANDATORY_WHITESPACE_OR_COMMENT(BasicPatterns.TPL_MANDATORY_WHITESPACE_OR_COMMENT, StatelessInstruction::augmentWithWhitespaceOrComment, 1),
    OPTIONAL_WHITESPACE_OR_COMMENT(BasicPatterns.TPL_OPTIONAL_WHITESPACE_OR_COMMENT, StatelessInstruction::augmentWithWhitespaceOrComment, 1),
    ALL(BasicPatterns.TPL_ALL, StatelessInstruction::augmentWithTokenMultiSelect, 1),
    NONE(BasicPatterns.TPL_NONE, StatelessInstruction::augmentWithTokenMultiSelect, 1),
    ARG_NAME(BasicPatterns.TPL_ARG_NAME, StatelessInstruction::augmentWithTokenMultiSelect, 1),
    ARG_VALUE(BasicPatterns.TPL_ARG_VALUE, StatelessInstruction::augmentWithTokenMultiSelect, 1),
    IS(BasicPatterns.TPL_IS, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    NOT(BasicPatterns.TPL_NOT, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    UNKNOWN(BasicPatterns.TPL_UNKNOWN, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    OP(BasicPatterns.TPL_OP, StatelessInstruction::augmentWithTokenMultiSelect, 1),
    ARG_REF(BasicPatterns.TPL_ARG_REF, StatelessInstruction::augmentWithTokenMultiSelect, 1),
    STRICT(BasicPatterns.TPL_STRICT, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    ANY(BasicPatterns.TPL_ANY, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    OF(BasicPatterns.TPL_OF, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    MIXED_LIST(BasicPatterns.TPL_MIXED, StatelessInstruction::augmentWithTokenCSV, 1),
    CONTAINS(BasicPatterns.TPL_CONTAINS, StatelessInstruction::augmentWithTokenMultiSelect, 1),
    SNIPPET(BasicPatterns.TPL_SNIPPET, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    SNIPPET_LIST(BasicPatterns.TPL_SNIPPET, StatelessInstruction::augmentWithTokenCSV, 1),
    BETWEEN(BasicPatterns.TPL_BETWEEN, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    BOUND(BasicPatterns.TPL_BOUND, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    COMMENT(BasicPatterns.TPL_COMMENT, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    AND(BasicPatterns.TPL_AND, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    OR(BasicPatterns.TPL_OR, StatelessInstruction::augmentWithTokenSingleSelect, 1),
    CURB(BasicPatterns.TPL_CURB, StatelessInstruction::augmentWithTokenSingleSelect, 1);

    private final TriFunction<StatelessInstruction, SampleExpression, Integer, List<SampleExpression>> instruction;
    private final String[] patterns;
    private final int defaultOutputLimit;

    @Override
    public int getDefaultOutputLimit() {
        return this.defaultOutputLimit;
    }

    private StatelessInstruction(String[] patterns, TriFunction<StatelessInstruction, SampleExpression, Integer, List<SampleExpression>> instruction, int defaultOutputLimit) {
        this.patterns = patterns;
        this.instruction = instruction;
        this.defaultOutputLimit = defaultOutputLimit;
    }

    private static String pickValue(String[] patterns, Random rand) {
        int idx = 0;
        if (patterns.length > 1) {
            idx = rand.nextInt(patterns.length - 1) + 1;
        }
        return patterns[idx];
    }

    private static List<String> pickValuesNoDuplicates(String[] patterns, Random rand, int len) {
        if (patterns.length >= len) {
            return Arrays.asList(patterns);
        }
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<String> availablePatterns = new ArrayList<String>(Arrays.asList(patterns));
        for (int i = 0; i < len; ++i) {
            if (availablePatterns.size() == 1) {
                res.add((String)availablePatterns.get(0));
                break;
            }
            String value = StatelessInstruction.pickValue(availablePatterns.toArray(new String[0]), rand);
            res.add(value);
            availablePatterns.remove(value);
        }
        return res;
    }

    private static List<String> pickValues(String[] patterns, Random rand, int max) {
        ArrayList<String> res = new ArrayList<String>();
        int limit = rand.nextInt(max) + 1;
        for (int i = 0; i < limit; ++i) {
            String value = StatelessInstruction.pickValue(patterns, rand);
            res.add(value);
        }
        return res;
    }

    void updateGenInfo(SampleGenInfo info, String pattern) {
        switch (this.ordinal()) {
            case 2: {
                info.incrementCntAll();
                break;
            }
            case 3: {
                info.incrementCntNone();
                break;
            }
            case 6: {
                info.incrementCntIs();
                break;
            }
            case 7: {
                info.incrementCntNot();
                break;
            }
            case 8: {
                info.incrementCntUnknown();
                break;
            }
            case 11: {
                info.incrementCntStrict();
                break;
            }
            case 12: {
                info.incrementCntAny();
                break;
            }
            case 13: {
                info.incrementCntOf();
                break;
            }
            case 15: {
                info.incrementCntContains();
                break;
            }
            case 18: {
                info.incrementCntBetween();
                break;
            }
            case 23: {
                info.incrementCntCurb();
                break;
            }
            case 9: {
                this.createOrUpdateList(info.getOperators(), SampleExpressionOperator.resolve(pattern), info::setOperators);
                break;
            }
            case 4: {
                this.createOrUpdateList(info.getArgNames(), pattern, info::setArgNames);
                break;
            }
            case 5: {
                this.createOrUpdateList(info.getArgValues(), pattern, info::setArgValues);
                break;
            }
            case 10: {
                this.createOrUpdateList(info.getArgRefs(), pattern.substring(1), info::setArgRefs);
                break;
            }
            case 20: {
                this.createOrUpdateList(info.getComments(), this.trimComment(pattern), info::setComments);
                break;
            }
            case 21: {
                info.incrementCntAnd();
                break;
            }
            case 22: {
                info.incrementCntOr();
                break;
            }
            case 16: {
                this.createOrUpdateList(info.getSnippets(), pattern, info::setSnippets);
                break;
            }
            case 19: {
                this.createOrUpdateList(info.getBoundValues(), Integer.valueOf(pattern), info::setBoundValues);
                break;
            }
        }
    }

    private String trimComment(String comment) {
        int start = 0;
        while (comment.charAt(start) != '/') {
            ++start;
        }
        int end = comment.length();
        while (comment.charAt(end - 1) != '/') {
            --end;
        }
        return comment.substring(start, end);
    }

    private <T> void createOrUpdateList(List<T> list, T element, Consumer<List<T>> setter) {
        if (list == null) {
            list = new ArrayList<T>();
            setter.accept(list);
        }
        list.add(element);
    }

    private static List<SampleExpression> augmentWithFirstPattern(StatelessInstruction instance, SampleExpression inputExpression) {
        String pattern = instance.patterns[0];
        ArrayList<SampleExpression> res = new ArrayList<SampleExpression>();
        StatelessInstruction.augmentWithPattern(instance, inputExpression, pattern, res);
        return res;
    }

    private static void augmentWithPattern(StatelessInstruction instance, SampleExpression inputExpression, String pattern, List<SampleExpression> res) {
        if (!pattern.isEmpty()) {
            String newExpression = inputExpression.expression() + pattern;
            SampleExpression outputExpression = new SampleExpression(inputExpression.id(), inputExpression.label(), newExpression, inputExpression.invalid(), inputExpression.composite(), inputExpression.skip(), inputExpression.generationInfo().copy());
            instance.updateGenInfo(outputExpression.generationInfo(), pattern);
            res.add(outputExpression);
        } else {
            res.add(inputExpression);
        }
    }

    private static List<SampleExpression> augmentWithTokenSingleSelect(StatelessInstruction instance, SampleExpression inputExpression, String[] patterns, int outputLimit) {
        Random rand = GenDataUtils.createRandomWithSeed(inputExpression);
        String pattern = outputLimit < 1 ? patterns[0] : StatelessInstruction.pickValue(patterns, rand);
        ArrayList<SampleExpression> res = new ArrayList<SampleExpression>();
        StatelessInstruction.augmentWithPattern(instance, inputExpression, pattern, res);
        return instance.addInvalidExpressionIfAppropriate(inputExpression, rand, res, outputLimit < 1);
    }

    private static List<SampleExpression> augmentWithTokenSingleSelect(StatelessInstruction instance, SampleExpression inputExpression, int outputLimit) {
        return StatelessInstruction.augmentWithTokenSingleSelect(instance, inputExpression, instance.patterns, outputLimit);
    }

    private static List<SampleExpression> augmentWithTokenMultiSelect(StatelessInstruction instance, SampleExpression inputExpression, int outputLimit) {
        Random rand = GenDataUtils.createRandomWithSeed(inputExpression);
        ArrayList<SampleExpression> res = new ArrayList<SampleExpression>();
        int multiplier = inputExpression.invalid() || outputLimit <= 1 ? 1 : outputLimit;
        ArrayList<String> multiplierPatterns = new ArrayList<String>();
        multiplierPatterns.add(instance.patterns[0]);
        if (multiplier > 1) {
            multiplierPatterns.addAll(StatelessInstruction.pickValuesNoDuplicates(instance.patterns, rand, multiplier - 1));
        }
        for (String pattern : multiplierPatterns) {
            StatelessInstruction.augmentWithPattern(instance, inputExpression, pattern, res);
        }
        return instance.addInvalidExpressionIfAppropriate(inputExpression, rand, res, outputLimit < 1);
    }

    private static List<SampleExpression> augmentWithWhitespaceOrComment(StatelessInstruction instance, SampleExpression inputExpression, int outputLimit) {
        Random rand = GenDataUtils.createRandomWithSeed(inputExpression);
        boolean skipVariations = outputLimit < 1;
        List<SampleExpression> res = StatelessInstruction.augmentWithFirstPattern(instance, inputExpression);
        if (rand.nextInt(100) < 10) {
            List<SampleExpression> subRes = COMMENT.apply(inputExpression);
            if (!skipVariations && rand.nextInt(100) < 5) {
                subRes = COMMENT.apply(subRes.get(0));
            }
            res.addAll(subRes);
        } else if (!skipVariations) {
            String[] patterns = Arrays.copyOfRange(instance.patterns, 1, instance.patterns.length);
            res.addAll(StatelessInstruction.augmentWithTokenSingleSelect(instance, inputExpression, patterns, outputLimit));
        }
        return res;
    }

    private static List<SampleExpression> augmentWithTokenCSV(StatelessInstruction instance, SampleExpression inputExpression, int outputLimit) {
        Random rand = GenDataUtils.createRandomWithSeed(inputExpression);
        List<String> listValues = StatelessInstruction.pickValues(instance.patterns, rand, 5);
        StringBuilder sbNewExpression = new StringBuilder(inputExpression.expression());
        SampleGenInfo newInfo = inputExpression.generationInfo().copy();
        for (int i = 0; i < listValues.size(); ++i) {
            if (i > 0) {
                StatelessInstruction.occasionallyAppendWhitespaceOrComment(rand, sbNewExpression, newInfo);
                sbNewExpression.append(",");
                StatelessInstruction.occasionallyAppendWhitespaceOrComment(rand, sbNewExpression, newInfo);
            }
            String value = listValues.get(i);
            sbNewExpression.append(value);
            instance.updateGenInfo(newInfo, value);
            if (instance == MIXED_LIST) {
                if (value.startsWith("@")) {
                    ARG_REF.updateGenInfo(newInfo, value);
                    continue;
                }
                ARG_VALUE.updateGenInfo(newInfo, value);
                continue;
            }
            SNIPPET.updateGenInfo(newInfo, value);
        }
        List<SampleExpression> res = Arrays.asList(new SampleExpression(inputExpression.id(), inputExpression.label(), sbNewExpression.toString(), inputExpression.invalid(), inputExpression.composite(), inputExpression.skip(), newInfo));
        return instance.addInvalidExpressionIfAppropriate(inputExpression, rand, res, outputLimit < 1);
    }

    private static void occasionallyAppendWhitespaceOrComment(Random rand, StringBuilder sbNewExpression, SampleGenInfo newInfo) {
        if (rand.nextInt(100) < 10) {
            sbNewExpression.append("\n");
        } else if (rand.nextBoolean()) {
            sbNewExpression.append(" ");
        }
        if (rand.nextInt(100) < 10) {
            String comment = StatelessInstruction.COMMENT.patterns[0];
            sbNewExpression.append(comment);
            COMMENT.updateGenInfo(newInfo, comment);
        }
    }

    private List<SampleExpression> addInvalidExpressionIfAppropriate(SampleExpression inputExpression, Random rand, List<SampleExpression> results, boolean skipVariations) {
        if (inputExpression.invalid() || skipVariations) {
            return results;
        }
        ArrayList<String> invalidExpressions = new ArrayList<String>();
        if (this == ARG_NAME) {
            invalidExpressions.add(inputExpression.expression());
            this.addBadPatterns(inputExpression, rand, invalidExpressions, new String[]{" ", "!", "\"", "\n", "\t", "\r", "\"", "\"\"", "\"\n\""}, 2);
        } else if (this == ARG_VALUE || this == SNIPPET) {
            invalidExpressions.add(inputExpression.expression());
            this.addBadPatterns(inputExpression, rand, invalidExpressions, new String[]{" ", "!", "\"", "\n", "\t", "\r", "\"", "\"\n\""}, 2);
        } else if (this == MIXED_LIST) {
            invalidExpressions.add(inputExpression.expression());
            this.addBadPatterns(inputExpression, rand, invalidExpressions, new String[]{" ", "a,,b", "a,", "a,b,", "a,,", ",", "\"a\",", ",\"a\"", ",a"}, 3);
        } else if (this == SNIPPET_LIST) {
            invalidExpressions.add(inputExpression.expression());
            this.addBadPatterns(inputExpression, rand, invalidExpressions, new String[]{" ", "a,,b", "a,", "a,@b,", "a,,", ",", "@\"a\",", ",@\"a\"", ",@a, b"}, 3);
        }
        if (!invalidExpressions.isEmpty()) {
            results = new ArrayList<SampleExpression>(results);
            for (String invalidExpression : invalidExpressions) {
                SampleExpression newExpr = new SampleExpression(inputExpression.id(), inputExpression.label(), invalidExpression, true, inputExpression.composite(), inputExpression.skip(), inputExpression.generationInfo().copy());
                results.add(newExpr);
            }
        }
        return results;
    }

    private void addBadPatterns(SampleExpression inputExpression, Random rand, List<String> invalidExpressions, String[] badPatternTemplates, int numberOfVariations) {
        List<String> badPatterns = StatelessInstruction.pickValuesNoDuplicates(badPatternTemplates, rand, numberOfVariations);
        for (String badPattern : badPatterns) {
            invalidExpressions.add(inputExpression.expression() + badPattern);
        }
    }

    @Override
    public List<SampleExpression> apply(SampleExpression inputExpression, int outputLimit) {
        return this.instruction.apply(this, inputExpression, outputLimit);
    }

    private static final class BasicPatterns {
        private static final String[] TPL_MANDATORY_WHITESPACE_OR_COMMENT = new String[]{" ", "\n", "\r\n", "\t", "\r", "   ", "\t\t\n\t"};
        private static final String[] TPL_OPTIONAL_WHITESPACE_OR_COMMENT = new String[]{"", " ", "\n", "\r\n", "\t", "\r", "   ", "\t\t\n\t"};
        private static final String[] TPL_COMMENT = new String[]{"/* comment */", "/* hugo */", "/* NOT */", "\n/**/\n", "\n/*AND (b=3)*/\n", "/*\\nsome comment\\n\\n\\n*/"};
        private static final String[] TPL_OR = new String[]{"OR", "or", "Or", "oR"};
        private static final String[] TPL_AND = new String[]{"AND", "and", "And", "AnD", "aND"};
        private static final String[] TPL_ALL = new String[]{"<ALL>", "<all>", "<All>", "<aLl>", "<AlL>"};
        private static final String[] TPL_NONE = new String[]{"<NONE>", "<none>", "<None>", "<nOnE>", "<NoNe>"};
        private static final String[] TPL_IS = new String[]{"IS", "is", "Is", "iS"};
        private static final String[] TPL_NOT = new String[]{"NOT", "not", "Not", "nOt", "nOT"};
        private static final String[] TPL_UNKNOWN = new String[]{"UNKNOWN", "unknown", "Unknown", "unKnown", "uNkNoWn"};
        private static final String[] TPL_OP = new String[]{"=", "<", "<=", "!=", ">=", ">"};
        private static final String[] TPL_STRICT = new String[]{"STRICT", "strict", "Strict", "sTriCt"};
        private static final String[] TPL_ANY = new String[]{"ANY", "any", "Any", "AnY", "aNY"};
        private static final String[] TPL_OF = new String[]{"OF", "of", "Of", "oF"};
        private static final String[] TPL_CONTAINS = new String[]{"CONTAINS", "contains", "Contains", "conTains", "cONTAInS"};
        private static final String[] TPL_BETWEEN = new String[]{"BETWEEN", "between", "Between", "betWeen", "bETWEEn"};
        private static final String[] TPL_CURB = new String[]{"CURB", "curb", "Curb", "curB", "cUrB"};
        private static final String[] TPL_ARG_NAME = new String[]{"argName", "a", "\"a\"", "\"argName\"", "\"argument name\"", "arg1", "arg2", "arg3", "arg4", "arg5", "arg6", "arg7", "arg8", "arg9", "arg10", "arg11", "arg12", "arg13", "arg14", "arg15", "arg16", "arg17", "arg18", "arg19", "arg20", "\"<ALL>\"", "\"<NONE>\"", "\"IS\"", "\"NOT\"", "\"BETWEEN\"", "\"STRICT\"", "\"UNKNOWN\"", "\"OF\"", "\"CONTAINS\"", "\"CURB\"", "\"name with quote (\"\")\""};
        private static final String[] TPL_ARG_VALUE = new String[]{"value", "\"\"", "v", "\"v\"", "\"value\"", "val1", "val2", "val3", "val4", "val5", "val6", "val7", "val8", "val9", "val10", "val11", "val12", "val13", "val14", "val15", "val16", "val17", "val18", "val19", "val20", "\"some value\"", "\"<ALL>\"", "\"<NONE>\"", "\"IS\"", "\"NOT\"", "\"BETWEEN\"", "\"STRICT\"", "\"UNKNOWN\"", "\"OF\"", "\"CONTAINS\"", "\"CURB\"", "\"value with quote (\"\")\""};
        private static final String[] TPL_ARG_REF = new String[]{"@argName", "@a", "@\"a\"", "@\"argName\"", "@\"argument name\"", "@arg1", "@arg2", "@arg3", "@arg4", "@arg5", "@arg6", "@arg7", "@arg8", "@arg9", "@arg10", "@arg11", "@arg12", "@arg13", "@arg14", "@arg15", "@arg16", "@arg17", "@arg18", "@arg19", "@arg20", "@\"<ALL>\"", "@\"<NONE>\"", "@\"IS\"", "@\"NOT\"", "@\"BETWEEN\"", "@\"STRICT\"", "@\"UNKNOWN\"", "@\"OF\"", "@\"CONTAINS\"", "@\"CURB\"", "@\"argref with quote (\"\")\""};
        private static final String[] TPL_SNIPPET = new String[]{"foo", "f", "bar", "\"foo bar\"", "\\", "\"a=b\"", "\"OR\"", "brand\\sports", "C:\\programs", "\"!\"", "yeti", "Hugo", "Eliza", "blue", "red", "green", "toast", "\"snippet with quote (\"\")\""};
        private static final String[] TPL_MIXED;
        private static final String[] TPL_BOUND;

        private BasicPatterns() {
        }

        static {
            ArrayList<String> all = new ArrayList<String>(Arrays.asList(TPL_ARG_VALUE));
            all.addAll(Arrays.asList(TPL_ARG_REF));
            TPL_MIXED = all.toArray(new String[0]);
            TPL_BOUND = new String[]{"1", "0", "10", "2", "3", "4", "5", "6", "7", "8", "9", "999"};
        }
    }
}

