/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.JsonUtils;
import de.calamanari.adl.util.sgen.InstructionPlanCreator;
import de.calamanari.adl.util.sgen.InstructionPlanExecutor;
import de.calamanari.adl.util.sgen.SampleExpressionGroup;
import de.calamanari.adl.util.sgen.SampleGroupCatalog;
import de.calamanari.adl.util.sgen.SampleGroupCatalogEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SampleExpressionUtils {
    public static List<SampleExpressionGroup> readSampleGroupsFromJsonResource(String fileName) throws IOException {
        try (InputStream is = SampleExpressionUtils.class.getResourceAsStream(fileName);){
            List<SampleExpressionGroup> list;
            block13: {
                BufferedInputStream bis = is == null ? null : new BufferedInputStream(is);
                try {
                    if (is == null) {
                        throw new IOException("Unable to load sample resource " + fileName);
                    }
                    list = Arrays.asList((SampleExpressionGroup[])JsonUtils.createObjectMapper(false).readValue((InputStream)bis, SampleExpressionGroup[].class));
                    if (bis == null) break block13;
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                bis.close();
            }
            return list;
        }
    }

    public static List<SampleExpressionGroup> readSampleGroupsFromJsonFile(String fileName) throws IOException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            List<SampleExpressionGroup> list;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                list = Arrays.asList((SampleExpressionGroup[])JsonUtils.createObjectMapper(false).readValue((InputStream)bis, SampleExpressionGroup[].class));
            }
            return list;
        }
    }

    public static void writeSampleGroupsToJsonFile(List<SampleExpressionGroup> samples, String fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            JsonUtils.createObjectMapper(true).writeValue((OutputStream)bos, samples);
        }
    }

    public static void writeGroupCatalogToJsonFile(SampleGroupCatalog catalog, String fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            JsonUtils.createObjectMapper(true).writeValue((OutputStream)bos, (Object)catalog);
        }
    }

    public static SampleGroupCatalog createSampleGroupCatalog(List<SampleExpressionGroup> samples) {
        int numberOfSamples = samples.stream().map(group -> group.samples().size()).collect(Collectors.summingInt(Integer::intValue));
        int numberOfGroups = samples.size();
        List<SampleGroupCatalogEntry> groups = samples.stream().map(g -> new SampleGroupCatalogEntry(g.group(), g.samples().size())).toList();
        return new SampleGroupCatalog(groups, numberOfGroups, numberOfSamples);
    }

    public static List<SampleExpressionGroup> generateSamples(List<SampleExpressionGroup> sampleTemplateGroups) {
        InstructionPlanCreator planner = new InstructionPlanCreator();
        InstructionPlanExecutor executor = new InstructionPlanExecutor();
        return executor.execute(planner.createPlan(sampleTemplateGroups));
    }

    private SampleExpressionUtils() {
    }
}

