/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.calamanari.adl.util.JsonUtils;
import de.calamanari.adl.util.sgen.SampleExpression;
import de.calamanari.adl.util.sgen.SampleGenInfo;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public record SampleExpressionGroup(String group, List<SampleExpression> samples, @JsonInclude(value=JsonInclude.Include.NON_DEFAULT) boolean skip) implements Serializable
{
    public SampleExpressionGroup {
        if (group == null || samples == null) {
            throw new IllegalArgumentException(String.format("group identifier and samples must not be null, given: group=%s, samples=%s", group, samples == null ? null : Integer.valueOf(samples.size())));
        }
        if (group.isBlank()) {
            throw new IllegalArgumentException(String.format("group identifier must not be empty or whitespace-only, given: group='%s', samples=%s", group, "[" + samples.size() + "]"));
        }
        if (samples.isEmpty()) {
            throw new IllegalArgumentException(String.format("A group of samples must at least contain one element, given: group='%s', samples=%s", group, "[" + samples.size() + "]"));
        }
        samples = samples.stream().map(sample -> SampleExpressionGroup.updateSampleWithGroup(sample, group)).toList();
    }

    public SampleExpressionGroup(String group, List<SampleExpression> samples) {
        this(group, samples, false);
    }

    private static SampleExpression updateSampleWithGroup(SampleExpression sample, String group) {
        SampleExpression res = sample;
        if (sample.generationInfo() == null) {
            res = new SampleExpression(sample.id(), sample.label(), sample.expression(), sample.invalid(), sample.composite(), sample.skip(), new SampleGenInfo());
            res.generationInfo().group = group;
        } else if (!group.equals(sample.generationInfo().group)) {
            res = new SampleExpression(sample.id(), sample.label(), sample.expression(), sample.invalid(), sample.composite(), sample.skip(), sample.generationInfo().copy());
            res.generationInfo().group = group;
        }
        return res;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SampleExpressionGroup other = (SampleExpressionGroup)obj;
        return Objects.equals(this.group, other.group);
    }

    public static SampleExpressionGroup fromJson(String json) {
        return JsonUtils.readFromJsonString(json, SampleExpressionGroup.class);
    }

    public String toJson() {
        return JsonUtils.writeAsJsonString(this, true);
    }
}

