/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.calamanari.adl.util.JsonUtils;
import de.calamanari.adl.util.sgen.SampleGenInfo;
import java.io.Serializable;
import java.util.Objects;

public record SampleExpression(String id, String label, String expression, @JsonInclude(value=JsonInclude.Include.NON_DEFAULT) boolean invalid, @JsonInclude(value=JsonInclude.Include.NON_DEFAULT) boolean composite, @JsonInclude(value=JsonInclude.Include.NON_DEFAULT) boolean skip, SampleGenInfo generationInfo) implements Serializable
{
    public SampleExpression {
        if (id == null || label == null || expression == null) {
            throw new IllegalArgumentException(String.format("id, label and expression must not be null, given: id=%s, label=%s, expression=%s", id, label, expression));
        }
        if (id.isBlank() || label.isBlank()) {
            throw new IllegalArgumentException(String.format("id and label must not be empty or whitespace only, given: id='%s', label='%s', expression=%s", id, label, expression));
        }
    }

    public SampleExpression(String id, String label, String expression, boolean invalid, boolean composite, boolean skip) {
        this(id, label, expression, invalid, composite, skip, null);
    }

    public SampleExpression(String id, String label, String expression, boolean invalid, boolean composite) {
        this(id, label, expression, invalid, composite, false, null);
    }

    public SampleExpression(String id, String label, String expression, boolean invalid) {
        this(id, label, expression, invalid, false, false, null);
    }

    public SampleExpression(String id, String label, String expression) {
        this(id, label, expression, false, false, false, null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SampleExpression other = (SampleExpression)obj;
        return Objects.equals(this.id, other.id);
    }

    String group() {
        return this.generationInfo == null ? null : this.generationInfo.group;
    }

    public static SampleExpression fromJson(String json) {
        return JsonUtils.readFromJsonString(json, SampleExpression.class);
    }

    public String toJson() {
        return JsonUtils.writeAsJsonString(this, true);
    }
}

