/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.sgen.GenDataUtils;
import de.calamanari.adl.util.sgen.GenInstructionGroup;
import de.calamanari.adl.util.sgen.GenInstructionPlan;
import de.calamanari.adl.util.sgen.SampleExpression;
import de.calamanari.adl.util.sgen.SampleExpressionGroup;
import de.calamanari.adl.util.sgen.TemplateInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class InstructionPlanExecutor {
    private static final int VARIATION_COUNT_LIMIT = 50;
    private final List<SampleExpression> allGeneratedSamples = new ArrayList<SampleExpression>();

    public List<SampleExpressionGroup> execute(GenInstructionPlan plan) {
        plan.prepare(this.allGeneratedSamples);
        ArrayList<SampleExpressionGroup> res = new ArrayList<SampleExpressionGroup>();
        for (GenInstructionGroup instructionGroup : plan.groups()) {
            ArrayList<SampleExpression> groupResultList = new ArrayList<SampleExpression>();
            instructionGroup.members().forEach(instruction -> this.processTemplateInstructions(instruction.startExpression(), instruction.instructions(), groupResultList, new AtomicInteger()));
            SampleExpressionGroup sampleExpressionGroup = new SampleExpressionGroup(instructionGroup.group(), groupResultList);
            res.add(sampleExpressionGroup);
        }
        return res;
    }

    private void processTemplateInstructions(SampleExpression baseExpression, List<TemplateInstruction> templateInstructions, List<SampleExpression> groupResultList, AtomicInteger variationCount) {
        List<SampleExpression> results = null;
        results = variationCount.get() < 50 ? templateInstructions.get(0).apply(baseExpression) : templateInstructions.get(0).apply(baseExpression, 0);
        List<TemplateInstruction> furtherInstructions = templateInstructions.subList(1, templateInstructions.size());
        if (furtherInstructions.isEmpty()) {
            for (SampleExpression result : results) {
                result = this.finalizeSampleExpression(result);
                groupResultList.add(result);
                variationCount.incrementAndGet();
                this.allGeneratedSamples.add(result);
            }
        } else {
            results.forEach(instruction -> this.processTemplateInstructions((SampleExpression)instruction, furtherInstructions, groupResultList, variationCount));
        }
    }

    private SampleExpression finalizeSampleExpression(SampleExpression expression) {
        return new SampleExpression(expression.id() + "_" + Long.toHexString(GenDataUtils.hashLong(expression.expression())), expression.label(), expression.expression(), expression.invalid(), expression.composite(), expression.skip(), expression.generationInfo().copy());
    }
}

