/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.AdlException;
import de.calamanari.adl.util.sgen.GenInstruction;
import de.calamanari.adl.util.sgen.GenInstructionGroup;
import de.calamanari.adl.util.sgen.GenInstructionPlan;
import de.calamanari.adl.util.sgen.SampleExpression;
import de.calamanari.adl.util.sgen.SampleExpressionGroup;
import de.calamanari.adl.util.sgen.TemplateInstructionParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionPlanCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstructionPlanCreator.class);
    private final TemplateInstructionParser templateInstructionParser = new TemplateInstructionParser();

    public GenInstructionPlan createPlan(List<SampleExpressionGroup> templateGroups) {
        if (templateGroups == null || templateGroups.isEmpty()) {
            return new GenInstructionPlan(Collections.emptyList());
        }
        LinkedHashMap<String, List<GenInstruction>> groupMap = new LinkedHashMap<String, List<GenInstruction>>();
        for (SampleExpressionGroup templateGroup : templateGroups) {
            this.processTemplateGroup(templateGroup, groupMap);
        }
        ArrayList<GenInstructionGroup> generatorInstructionGroups = new ArrayList<GenInstructionGroup>();
        for (Map.Entry entry : groupMap.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) {
                LOGGER.debug("Skipping empty group: '{}'", entry.getKey());
                continue;
            }
            generatorInstructionGroups.add(new GenInstructionGroup((String)entry.getKey(), (List)entry.getValue()));
        }
        return new GenInstructionPlan(generatorInstructionGroups);
    }

    private void processTemplateGroup(SampleExpressionGroup templateGroup, Map<String, List<GenInstruction>> groupMap) {
        if (!templateGroup.skip()) {
            if (groupMap.containsKey(templateGroup.group())) {
                throw new AdlException(String.format("Found duplicate group name in instruction plan: %s, %s", groupMap.keySet().stream().collect(Collectors.joining(", ")), templateGroup.group()));
            }
            ArrayList<GenInstruction> currentGroupMembers = new ArrayList<GenInstruction>();
            groupMap.put(templateGroup.group(), currentGroupMembers);
            LinkedHashSet<String> templateIdsInGroup = new LinkedHashSet<String>();
            for (SampleExpression template : templateGroup.samples()) {
                this.processTemplate(template, templateGroup, templateIdsInGroup, currentGroupMembers);
            }
        } else {
            LOGGER.debug("Skipping template group: '{}'", (Object)templateGroup.group());
        }
    }

    private void processTemplate(SampleExpression template, SampleExpressionGroup templateGroup, Set<String> templateIdsInGroup, List<GenInstruction> currentGroupMembers) {
        if (!template.skip()) {
            if (templateIdsInGroup.contains(template.id())) {
                throw new AdlException(String.format("Found duplicate template id in template group %s: %s, %s", templateGroup.group(), templateIdsInGroup.stream().collect(Collectors.joining(", ")), template.id()));
            }
            templateIdsInGroup.add(template.id());
            GenInstruction instruction = new GenInstruction(template, this.templateInstructionParser.parse(template.expression()));
            currentGroupMembers.add(instruction);
        } else {
            LOGGER.debug("Skipping template '{}' in group '{}'", (Object)template.id(), (Object)templateGroup.group());
        }
    }
}

