/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.sgen.AbstractReuseExpressionInstruction;
import de.calamanari.adl.util.sgen.SampleExpression;
import java.util.List;
import java.util.function.Predicate;

public class IdFilterReuseExpressionInstruction
extends AbstractReuseExpressionInstruction {
    protected final String idFilter;

    public IdFilterReuseExpressionInstruction(String idFilter) {
        super(baseList -> IdFilterReuseExpressionInstruction.filter(baseList, idFilter));
        this.idFilter = idFilter;
    }

    private static List<SampleExpression> filter(List<SampleExpression> baseList, String idFilter) {
        List<SampleExpression> res = baseList.stream().filter(Predicate.not(SampleExpression::invalid)).filter(e -> IdFilterReuseExpressionInstruction.matchId(e, idFilter)).limit(1L).toList();
        if (res.isEmpty()) {
            res = baseList.stream().filter(Predicate.not(SampleExpression::invalid)).filter(e -> idFilter.equals(e.group())).toList();
        }
        return res;
    }

    private static boolean matchId(SampleExpression expression, String idFilter) {
        boolean res = false;
        String id = expression.id();
        int pos = id.lastIndexOf(95);
        if (pos > 0 && id.substring(0, pos).equals(idFilter)) {
            res = true;
        }
        return res;
    }

    public String toString() {
        return "EXPRESSION:" + this.idFilter;
    }
}

