/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.sgen.GenInstruction;
import de.calamanari.adl.util.sgen.GenInstructionGroup;
import de.calamanari.adl.util.sgen.SampleExpression;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record GenInstructionPlan(List<GenInstructionGroup> groups) {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenInstructionPlan.class);

    public GenInstructionPlan {
        if (groups == null) {
            throw new IllegalArgumentException("groups must not be null");
        }
        HashMap<String, String> idToGroupMap = new HashMap<String, String>();
        for (GenInstructionGroup group : groups) {
            for (GenInstruction member : group.members()) {
                String otherGroup = idToGroupMap.putIfAbsent(member.template().id(), group.group());
                if (otherGroup == null) continue;
                LOGGER.warn("SampleExpression ids should be unique across group templates, found id={} in group {} previously declared in group {}.", new Object[]{member.template().id(), group.group(), otherGroup});
            }
        }
    }

    public void prepare(List<SampleExpression> targetList) {
        this.groups.stream().forEach(group -> group.prepare(targetList));
    }
}

