/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.AdlException;
import de.calamanari.adl.util.sgen.SampleExpression;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

public class GenDataUtils {
    private static final ThreadLocal<MessageDigest> DIGEST_HOLDER = ThreadLocal.withInitial(() -> GenDataUtils.getSha1MessageDigestInstance("SHA-1"));

    static final MessageDigest getSha1MessageDigestInstance(String digestName) {
        try {
            return MessageDigest.getInstance(digestName);
        }
        catch (RuntimeException | NoSuchAlgorithmException ex) {
            throw new AdlException("Unexpected issue during SHA-1-MessageDigest initialization.", ex);
        }
    }

    public static byte[] hash(String value) {
        if (value == null || value.isEmpty()) {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        }
        MessageDigest digest = DIGEST_HOLDER.get();
        digest.reset();
        digest.update(value.getBytes(StandardCharsets.UTF_8));
        return Arrays.copyOf(digest.digest(), 8);
    }

    public static long hashLong(String value) {
        byte[] bytes = GenDataUtils.hash(value);
        long res = 0L;
        for (int i = 0; i < 8; ++i) {
            res = res << 8 | Byte.toUnsignedLong(bytes[i]);
        }
        return res >>> 1;
    }

    public static Random createRandomWithSeed(String value) {
        return new Random(GenDataUtils.hashLong(value));
    }

    public static Random createRandomWithSeed(SampleExpression inputExpression) {
        return GenDataUtils.createRandomWithSeed(inputExpression.id() + inputExpression.expression());
    }

    private GenDataUtils() {
    }

    public static void cleanup() {
        DIGEST_HOLDER.remove();
    }
}

