/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.sgen.AppendTextInstruction;
import de.calamanari.adl.util.sgen.SampleExpression;
import de.calamanari.adl.util.sgen.StatelessInstruction;
import de.calamanari.adl.util.sgen.TemplateInstruction;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class AppendTextAsTokenInstruction
extends AppendTextInstruction {
    public static final Set<TemplateInstruction> ELIGIBLE_TOKENS = Collections.unmodifiableSet(new LinkedHashSet<StatelessInstruction>(Arrays.asList(StatelessInstruction.ARG_NAME, StatelessInstruction.ARG_VALUE, StatelessInstruction.ARG_REF, StatelessInstruction.BOUND, StatelessInstruction.COMMENT, StatelessInstruction.OP, StatelessInstruction.SNIPPET)));
    private final StatelessInstruction token;

    public AppendTextAsTokenInstruction(TemplateInstruction token, String text) {
        super(text);
        StatelessInstruction sToken;
        if (!ELIGIBLE_TOKENS.contains(token) || !(token instanceof StatelessInstruction)) {
            throw new IllegalArgumentException(String.format("Token not eligible for constant definition, given: token=%s, text=%s", token, text));
        }
        this.token = sToken = (StatelessInstruction)token;
    }

    @Override
    public List<SampleExpression> apply(SampleExpression inputExpression, int outputLimit) {
        List<SampleExpression> res = super.apply(inputExpression, 1);
        this.token.updateGenInfo(res.get(0).generationInfo(), this.text);
        return res;
    }

    @Override
    public String toString() {
        return String.valueOf(this.token) + ":'" + this.text + "'";
    }
}

