/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util.sgen;

import de.calamanari.adl.util.sgen.GenDataUtils;
import de.calamanari.adl.util.sgen.SampleExpression;
import de.calamanari.adl.util.sgen.TemplateInstruction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReuseExpressionInstruction
implements TemplateInstruction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReuseExpressionInstruction.class);
    protected final UnaryOperator<List<SampleExpression>> filter;
    private Supplier<List<SampleExpression>> baseListSupplier = Collections::emptyList;

    protected AbstractReuseExpressionInstruction(UnaryOperator<List<SampleExpression>> filter) {
        this.filter = filter == null ? l -> l : filter;
    }

    protected List<SampleExpression> applyInternal(SampleExpression inputExpression, int maxVariations) {
        Random rand = GenDataUtils.createRandomWithSeed(inputExpression);
        ArrayList<SampleExpression> res = new ArrayList<SampleExpression>();
        List<SampleExpression> refExpressions = AbstractReuseExpressionInstruction.pickUniqueExpressions((List)this.filter.apply(this.baseListSupplier.get()), rand, Math.max(maxVariations, 1));
        if (!refExpressions.isEmpty()) {
            for (SampleExpression refExpression : refExpressions) {
                Object newExpressionText = inputExpression.expression();
                newExpressionText = refExpression.composite() ? (String)newExpressionText + "( " + refExpression.expression() + " )" : (String)newExpressionText + refExpression.expression();
                SampleExpression outputExpression = new SampleExpression(inputExpression.id(), inputExpression.label(), (String)newExpressionText, inputExpression.invalid(), inputExpression.composite(), inputExpression.skip(), inputExpression.generationInfo().combine(refExpression.generationInfo()));
                res.add(outputExpression);
            }
        } else {
            SampleExpression fail = new SampleExpression(inputExpression.id(), inputExpression.label(), inputExpression.expression(), true, inputExpression.composite(), true, inputExpression.generationInfo().copy());
            LOGGER.error("{} failed: No matching reference expression found, marking expression as invalid with skip=true: {}", (Object)this, (Object)fail);
            res.add(fail);
        }
        return res;
    }

    @Override
    public int getDefaultOutputLimit() {
        return 3;
    }

    @Override
    public List<SampleExpression> apply(SampleExpression inputExpression, int outputLimit) {
        return this.applyInternal(inputExpression, inputExpression.invalid() ? 0 : outputLimit);
    }

    @Override
    public void setBaseListSupplier(Supplier<List<SampleExpression>> baseListSupplier) {
        this.baseListSupplier = baseListSupplier;
    }

    private static List<SampleExpression> pickUniqueExpressions(List<SampleExpression> expressions, Random rand, int max) {
        if (expressions.isEmpty()) {
            return Collections.emptyList();
        }
        if (expressions.size() == 1 || expressions.size() <= max) {
            return expressions;
        }
        ArrayList<SampleExpression> res = new ArrayList<SampleExpression>();
        ArrayList<SampleExpression> availableExpressions = new ArrayList<SampleExpression>(expressions);
        for (int i = 0; i < max; ++i) {
            SampleExpression value = (SampleExpression)availableExpressions.get(rand.nextInt(availableExpressions.size()));
            res.add(value);
            availableExpressions.remove(value);
        }
        return res;
    }
}

