/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.calamanari.adl.AdlException;

public class JsonUtils {
    public static ObjectMapper createObjectMapper(boolean prettyPrint) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        if (prettyPrint) {
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
            DefaultIndenter indenter = new DefaultIndenter("    ", DefaultIndenter.SYS_LF);
            prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
            prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.setDefaultPrettyPrinter((PrettyPrinter)prettyPrinter);
        }
        return objectMapper;
    }

    public static ObjectMapper createObjectMapper() {
        return JsonUtils.createObjectMapper(false);
    }

    public static String writeAsJsonString(Object value, boolean prettyPrint) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot write NULL as json string.");
        }
        try {
            return JsonUtils.createObjectMapper(prettyPrint).writeValueAsString(value);
        }
        catch (JsonProcessingException ex) {
            throw new AdlException(ex);
        }
    }

    public static <T> T readFromJsonString(String json, Class<T> type) {
        try {
            return (T)JsonUtils.createObjectMapper(false).readValue(json, type);
        }
        catch (JsonProcessingException | RuntimeException ex) {
            throw new AdlException(ex);
        }
    }

    private JsonUtils() {
    }
}

