/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AdlTextUtils {
    private static final String RESERVED_AUDLANG_CHARS = " ()<>=,!/\"*";
    static final Set<String> RESERVED_LITERALS;

    static void computeSpellingVariations(String template, int idx, StringBuilder sb, List<String> result) {
        if (idx == template.length()) {
            result.add(sb.toString());
        } else {
            sb.append(template.charAt(idx));
            AdlTextUtils.computeSpellingVariations(template, idx + 1, sb, result);
            sb.setLength(sb.length() - 1);
            sb.append(Character.toLowerCase(template.charAt(idx)));
            AdlTextUtils.computeSpellingVariations(template, idx + 1, sb, result);
            sb.setLength(sb.length() - 1);
        }
    }

    public static String addDoubleQuotesIfRequired(String input) {
        if (input == null) {
            throw new IllegalArgumentException("null is not allowed, neither with nor without quotes");
        }
        ParserState state = new ParserState(input);
        if (input.isEmpty() || !input.isEmpty() && input.charAt(0) == '@' || RESERVED_LITERALS.contains(input)) {
            state.modified = true;
        }
        while (state.inputIdx < input.length()) {
            char ch = input.charAt(state.inputIdx);
            if (ch >= '\u0000' && ch < ' ' || ch == '\u007f') {
                throw new IllegalArgumentException(String.format("Special character %s detected (implementation error, escaping must happen beforehand), problematic text: %s", Integer.toHexString(ch), input));
            }
            if (ch == '\"') {
                state.sb.append('\"');
                state.sb.append('\"');
                state.modified = true;
            } else {
                state.modified = state.modified || RESERVED_AUDLANG_CHARS.indexOf(ch) > -1;
                state.sb.append(ch);
            }
            ++state.inputIdx;
        }
        if (state.modified) {
            state.sb.insert(0, '\"');
            state.sb.append('\"');
        }
        return state.getOutput();
    }

    public static String removeDoubleQuotesIfRequired(String input) {
        AdlTextUtils.validateTextIsInDoubleQuotes(input);
        if (input.equals("\"\"")) {
            return "";
        }
        if (input.isEmpty() || input.charAt(0) != '\"') {
            return input;
        }
        ParserState state = new ParserState(input);
        state.modified = true;
        state.inputIdx = 1;
        while (state.inputIdx < input.length() - 1) {
            char ch = input.charAt(state.inputIdx);
            if (ch >= '\u0000' && ch < ' ' || ch == '\u007f') {
                throw new IllegalArgumentException(String.format("Special character %s detected (implementation error, unescaped text is not expected here), problematic text: %s", Integer.toHexString(ch), input));
            }
            if (ch == '\"') {
                if (state.inputIdx == input.length() - 2) {
                    throw new IllegalArgumentException(String.format("Unescaped single '\"' detected (implementation error, unescaped text is not expected here), problematic text: %s", input));
                }
                state.sb.append('\"');
                ++state.inputIdx;
            } else {
                state.sb.append(ch);
            }
            ++state.inputIdx;
        }
        return state.getOutput();
    }

    private static void validateTextIsInDoubleQuotes(String input) {
        if (input == null) {
            throw new IllegalArgumentException("null is not allowed, neither with nor without quotes");
        }
        if (input.isEmpty() || input.equals("\"") || input.charAt(0) == '\"' && input.charAt(input.length() - 1) != '\"' || input.charAt(0) != '\"' && input.charAt(input.length() - 1) == '\"') {
            throw new IllegalArgumentException(String.format("Unexpected input, expecting '\"...\"' or '...' (implementation error), problematic input: '%s'", input));
        }
    }

    public static String escapeSpecialCharacters(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Cannot escape null string");
        }
        ParserState state = new ParserState(input);
        while (state.inputIdx < input.length()) {
            char ch = input.charAt(state.inputIdx);
            if (ch == '<') {
                state.candidateStartIdx = state.sb.length();
                state.sb.append(ch);
            } else if (ch == '>') {
                state.sb.append(ch);
                if (AdlTextUtils.escapePotentialEscapeSequence(state)) {
                    state.candidateStartIdx = -1;
                    state.modified = true;
                }
            } else if (ch >= SpecialCharacter.MIN_CHARACTER_CODE && ch <= SpecialCharacter.MAX_CHARACTER_CODE) {
                AdlTextUtils.processSpecialCharacterCandidate(state, ch);
            } else {
                state.sb.append(ch);
            }
            ++state.inputIdx;
        }
        return state.getOutput();
    }

    public static String unescapeSpecialCharacters(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Cannot unescape null string");
        }
        ParserState state = new ParserState(input);
        while (state.inputIdx < input.length()) {
            char ch = input.charAt(state.inputIdx);
            if (ch == '<') {
                state.candidateStartIdx = state.sb.length();
                state.sb.append(ch);
            } else if (ch == '>') {
                state.sb.append(ch);
                if (AdlTextUtils.unescapePotentialEscapeSequence(state)) {
                    state.candidateStartIdx = -1;
                    state.modified = true;
                }
            } else {
                state.sb.append(ch);
            }
            ++state.inputIdx;
        }
        return state.getOutput();
    }

    private static void processSpecialCharacterCandidate(ParserState state, char ch) {
        SpecialCharacter spc = SpecialCharacter.resolve(ch);
        if (spc != null) {
            AdlTextUtils.escapeTrailingBackspaceCharacters(state.sb);
            state.sb.append("<");
            state.sb.append(spc.name());
            state.sb.append(">");
            state.modified = true;
            state.candidateStartIdx = -1;
        } else {
            state.sb.append(ch);
        }
    }

    private static boolean escapePotentialEscapeSequence(ParserState state) {
        String candidateName;
        int candidateNameLen;
        boolean modified = false;
        if (state.candidateStartIdx > -1 && (candidateNameLen = state.sb.length() - (state.candidateStartIdx + 2)) > 0 && candidateNameLen <= SpecialCharacter.MAX_NAME_LENGTH && SpecialCharacter.resolve(candidateName = state.sb.substring(state.candidateStartIdx + 1, state.candidateStartIdx + 1 + candidateNameLen)) != null) {
            String esc = state.sb.substring(state.candidateStartIdx);
            state.sb.setLength(state.candidateStartIdx);
            AdlTextUtils.escapeTrailingBackspaceCharacters(state.sb);
            state.sb.append('\\');
            state.sb.append(esc);
            modified = true;
        }
        return modified;
    }

    private static boolean unescapePotentialEscapeSequence(ParserState state) {
        String candidateName;
        SpecialCharacter candidate;
        int candidateNameLen;
        boolean modified = false;
        if (state.candidateStartIdx > -1 && (candidateNameLen = state.sb.length() - (state.candidateStartIdx + 2)) > 0 && candidateNameLen <= SpecialCharacter.MAX_NAME_LENGTH && (candidate = SpecialCharacter.resolve(candidateName = state.sb.substring(state.candidateStartIdx + 1, state.candidateStartIdx + 1 + candidateNameLen))) != null) {
            AdlTextUtils.processCandidate(state, candidate);
            modified = true;
        }
        return modified;
    }

    private static void processCandidate(ParserState state, SpecialCharacter candidate) {
        String esc = state.sb.substring(state.candidateStartIdx);
        state.sb.setLength(state.candidateStartIdx);
        int numberOfTrailingBackspaces = AdlTextUtils.countTrailingBackspaceCharacters(state.sb);
        AdlTextUtils.unescapeTrailingBackspaceCharacters(state.sb);
        if (numberOfTrailingBackspaces % 2 == 0) {
            state.sb.append((char)candidate.code);
        } else {
            state.sb.append(esc);
        }
    }

    private static int countTrailingBackspaceCharacters(StringBuilder sb) {
        int trailingBackslashCount = 0;
        for (int i = sb.length() - 1; i > -1 && sb.charAt(i) == '\\'; --i) {
            ++trailingBackslashCount;
        }
        return trailingBackslashCount;
    }

    private static void escapeTrailingBackspaceCharacters(StringBuilder sb) {
        int trailingBackslashCount = AdlTextUtils.countTrailingBackspaceCharacters(sb);
        if (trailingBackslashCount > 0) {
            sb.setLength(sb.length() - trailingBackslashCount);
            for (int i = 0; i < trailingBackslashCount; ++i) {
                sb.append("\\\\");
            }
        }
    }

    private static void unescapeTrailingBackspaceCharacters(StringBuilder sb) {
        int trailingBackslashCount = AdlTextUtils.countTrailingBackspaceCharacters(sb);
        if (trailingBackslashCount > 0) {
            sb.setLength(sb.length() - (trailingBackslashCount + 1) / 2);
        }
    }

    private AdlTextUtils() {
    }

    static {
        String[] templates = new String[]{"AND", "OR", "STRICT", "NOT", "IS", "ANY", "OF", "BETWEEN", "CONTAINS", "CURB", "UNKNOWN"};
        ArrayList<String> literalVariations = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String template : templates) {
            AdlTextUtils.computeSpellingVariations(template, 0, sb, literalVariations);
        }
        RESERVED_LITERALS = Collections.unmodifiableSet(new HashSet(literalVariations));
    }

    private static class ParserState {
        final String input;
        int inputIdx = 0;
        int candidateStartIdx = -1;
        boolean modified = false;
        StringBuilder sb = new StringBuilder();

        ParserState(String input) {
            this.input = input;
        }

        String getOutput() {
            return this.modified ? this.sb.toString() : this.input;
        }
    }

    public static enum SpecialCharacter {
        NUL(0),
        SOH(1),
        STX(2),
        ETX(3),
        EOT(4),
        ENQ(5),
        ACK(6),
        BEL(7),
        BS(8),
        HT(9),
        LF(10),
        VT(11),
        FF(12),
        CR(13),
        SO(14),
        SI(15),
        DLE(16),
        DC1(17),
        DC2(18),
        DC3(19),
        DC4(20),
        NAK(21),
        SYN(22),
        ETB(23),
        CAN(24),
        EM(25),
        SUB(26),
        ESC(27),
        FS(28),
        GS(29),
        RS(30),
        US(31),
        DEL(127);

        public final int code;
        private static final Map<String, SpecialCharacter> nameToInstanceMap;
        private static final SpecialCharacter[] quickCodeLookup;
        public static final int MIN_CHARACTER_CODE;
        public static final int MAX_CHARACTER_CODE;
        public static final int MAX_NAME_LENGTH;

        private SpecialCharacter(int code) {
            this.code = code;
        }

        public static SpecialCharacter resolve(String name) {
            return nameToInstanceMap.get(name);
        }

        public static SpecialCharacter resolve(int characterCode) {
            return characterCode > -1 && characterCode < quickCodeLookup.length ? quickCodeLookup[characterCode] : null;
        }

        static {
            HashMap map = new HashMap();
            Stream.of(SpecialCharacter.values()).forEach(c -> map.put(c.name(), c));
            nameToInstanceMap = Collections.unmodifiableMap(map);
            int size = Stream.of(SpecialCharacter.values()).map(c -> c.code).collect(Collectors.summarizingInt(Integer::intValue)).getMax() + 1;
            SpecialCharacter[] arr = new SpecialCharacter[size];
            Stream.of(SpecialCharacter.values()).forEach(c -> {
                arr[c.code] = c;
            });
            quickCodeLookup = arr;
            IntSummaryStatistics stats = Stream.of(SpecialCharacter.values()).map(c -> c.code).collect(Collectors.summarizingInt(Integer::intValue));
            MIN_CHARACTER_CODE = stats.getMin();
            MAX_CHARACTER_CODE = stats.getMax();
            MAX_NAME_LENGTH = Stream.of(SpecialCharacter.values()).map(c -> c.name().length()).collect(Collectors.summarizingInt(Integer::intValue)).getMax();
        }
    }
}

