/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.cnv.TemplateParameterUtils;
import de.calamanari.adl.cnv.tps.ArgMetaInfoLookup;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.cnv.tps.LookupException;
import de.calamanari.adl.sql.config.AbstractTableBuilder;
import de.calamanari.adl.sql.config.ArgColumnAssignment;
import de.calamanari.adl.sql.config.AutoMappingPolicy;
import de.calamanari.adl.sql.config.CompositeAutoMappingPolicy;
import de.calamanari.adl.sql.config.ConfigBuilderInterfaces;
import de.calamanari.adl.sql.config.ConfigUtils;
import de.calamanari.adl.sql.config.DataColumn;
import de.calamanari.adl.sql.config.DataTableConfig;
import de.calamanari.adl.sql.config.DefaultAutoMappingPolicy;
import de.calamanari.adl.sql.config.FilterColumn;
import de.calamanari.adl.sql.config.TableMetaInfo;
import de.calamanari.adl.sql.config.TableNature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SingleTableConfig(String tableName, String idColumnName, TableNature tableNature, List<FilterColumn> tableFilters, Map<String, ArgColumnAssignment> argColumnMap, AutoMappingPolicy autoMappingPolicy) implements DataTableConfig,
TableMetaInfo
{
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleTableConfig.class);

    public SingleTableConfig(String tableName, String idColumnName, TableNature tableNature, List<FilterColumn> tableFilters, Map<String, ArgColumnAssignment> argColumnMap, AutoMappingPolicy autoMappingPolicy) {
        SingleTableConfig.validateRequiredFields(tableName, idColumnName, tableNature, tableFilters, argColumnMap);
        SingleTableConfig.validateTableFilters(tableName, idColumnName, tableNature, tableFilters, argColumnMap);
        SingleTableConfig.validateArgColumnMap(tableName, idColumnName, tableNature, tableFilters, argColumnMap);
        SingleTableConfig.validateUniqueNotMultiRow(tableName, idColumnName, tableNature, tableFilters, argColumnMap);
        TreeMap<String, ArgColumnAssignment> tempMap = new TreeMap<String, ArgColumnAssignment>();
        for (Map.Entry<String, ArgColumnAssignment> entry : argColumnMap.entrySet()) {
            tempMap.put(entry.getKey(), entry.getValue());
        }
        if (SingleTableConfig.checkEffectivelyContainsAllIds(tableNature.containsAllIds(), argColumnMap) && !tableNature.containsAllIds()) {
            TableNature tableNatureBefore = tableNature;
            switch (tableNature) {
                case ID_SUBSET: {
                    tableNature = TableNature.ALL_IDS;
                    break;
                }
                case ID_SUBSET_SPARSE: {
                    tableNature = TableNature.ALL_IDS_SPARSE;
                    break;
                }
                case ID_SUBSET_UNIQUE: {
                    tableNature = TableNature.ALL_IDS_UNIQUE;
                    break;
                }
            }
            if (tableNature != tableNatureBefore) {
                LOGGER.trace("Automatic TableNature adjustment for table {}: {} -> {} (attribute always known)", new Object[]{tableName, tableNatureBefore, tableNature});
            }
        }
        this.tableName = tableName;
        this.idColumnName = idColumnName;
        this.tableNature = tableNature;
        this.tableFilters = Collections.unmodifiableList(tableFilters == null ? Collections.emptyList() : new ArrayList<FilterColumn>(tableFilters));
        this.argColumnMap = Collections.unmodifiableMap(tempMap);
        this.autoMappingPolicy = autoMappingPolicy == null ? DefaultAutoMappingPolicy.NONE : autoMappingPolicy;
    }

    public static ConfigBuilderInterfaces.SingleTableStep2 forTable(String tableName) {
        return new Builder(tableName, null);
    }

    public static ConfigBuilderInterfaces.SingleTableStep2 forTable(String tableName, ArgMetaInfoLookup argMetaInfoLookup) {
        return new Builder(tableName, argMetaInfoLookup);
    }

    private static void validateRequiredFields(String tableName, String idColumnName, TableNature tableNature, List<FilterColumn> tableFilters, Map<String, ArgColumnAssignment> argColumnMap) {
        if (!ConfigUtils.isValidTableName(tableName) || !ConfigUtils.isValidColumnName(idColumnName)) {
            throw new ConfigException(String.format("Invalid tableName or idColumnName, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
        }
        if (tableNature == null) {
            throw new ConfigException(String.format("Argument tableNature must not be null, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
        }
    }

    private static void validateArgColumnMap(String tableName, String idColumnName, TableNature tableNature, List<FilterColumn> tableFilters, Map<String, ArgColumnAssignment> argColumnMap) {
        if (argColumnMap == null) {
            throw new ConfigException(String.format("The parameter argColumnMap can be empty but must not be null, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
        }
        Set allDataColumnNames = argColumnMap.values().stream().filter(Predicate.not(Objects::isNull)).map(ArgColumnAssignment::column).map(DataColumn::columnName).collect(Collectors.toCollection(HashSet::new));
        for (Map.Entry<String, ArgColumnAssignment> entry : argColumnMap.entrySet()) {
            String argName = entry.getKey();
            if (!ConfigUtils.isValidArgName(argName)) {
                throw new ConfigException(String.format("Argument names in argColumnMap must not be null or empty, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            if (entry.getValue() == null) {
                throw new ConfigException(String.format("Assignments in argColumnMap must not be null, given: (%s=null) with tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", argName, tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            if (!argName.equals(entry.getValue().arg().argName())) {
                throw new ConfigException(String.format("Argument name mismatch in argColumnMap (expected same argument name), given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
            }
            if (!entry.getValue().column().tableName().equals(tableName)) {
                throw new ConfigException(String.format("Columns must all be in the same table, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFiltesr=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            if (entry.getValue().column().columnName().equals(idColumnName)) {
                throw new ConfigException(String.format("Columns in argColumnMap must not include the ID-column, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            SingleTableConfig.validateFilterColumns(tableName, idColumnName, tableNature, tableFilters, argColumnMap, allDataColumnNames, entry);
        }
    }

    private static void validateFilterColumns(String tableName, String idColumnName, TableNature tableNature, List<FilterColumn> tableFilters, Map<String, ArgColumnAssignment> argColumnMap, Set<String> allDataColumnNames, Map.Entry<String, ArgColumnAssignment> entry) {
        for (FilterColumn filterColumn : entry.getValue().column().filters()) {
            if (filterColumn.columnName().equals(idColumnName)) {
                throw new ConfigException(String.format("ID-column cannot be defined as a filter column, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            if (allDataColumnNames.contains(filterColumn.columnName())) {
                throw new ConfigException(String.format("Data column %s cannot be defined as a filter column, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", filterColumn.columnName(), tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            if (tableFilters == null) continue;
            List<String> tableFilterColumnNames = tableFilters.stream().map(FilterColumn::columnName).toList();
            if (!entry.getValue().column().filters().stream().map(FilterColumn::columnName).anyMatch(tableFilterColumnNames::contains)) continue;
            throw new ConfigException(String.format("Filters defined for column %s must not overlap with the table filters, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", entry.getValue().column().columnName(), tableName, idColumnName, tableNature, tableFilters, argColumnMap));
        }
    }

    private static boolean checkEffectivelyContainsAllIds(boolean containsAllIds, Map<String, ArgColumnAssignment> argColumnMap) {
        return containsAllIds || argColumnMap.values().stream().anyMatch(aca -> aca.column().isAlwaysKnown());
    }

    private static void validateUniqueNotMultiRow(String tableName, String idColumnName, TableNature tableNature, List<FilterColumn> tableFilters, Map<String, ArgColumnAssignment> argColumnMap) {
        if (tableNature.isIdUnique()) {
            for (ArgColumnAssignment assignment : argColumnMap.values()) {
                if (!assignment.column().isMultiRow()) continue;
                throw new ConfigException(String.format("Inconsistency detected: The table requires the records-IDs in the table to be unique but column %s is marked multi-row, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", assignment.column().columnName(), tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
        }
    }

    private static void validateTableFilters(String tableName, String idColumnName, TableNature tableNature, List<FilterColumn> tableFilters, Map<String, ArgColumnAssignment> argColumnMap) {
        if (tableFilters == null) {
            return;
        }
        Set allDataColumnNames = argColumnMap.values().stream().map(ArgColumnAssignment::column).map(DataColumn::columnName).collect(Collectors.toCollection(HashSet::new));
        HashMap<String, FilterColumn> tableFilterColumns = new HashMap<String, FilterColumn>();
        for (FilterColumn filterColumn : tableFilters) {
            if (filterColumn.columnName().equals(idColumnName)) {
                throw new ConfigException(String.format("The ID-column %s cannot be specified as filter column of the table, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", filterColumn.columnName(), tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            if (allDataColumnNames.contains(filterColumn.columnName())) {
                throw new ConfigException(String.format("The data column %s cannot be specified as filter column the a table, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", filterColumn.columnName(), tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            if (tableFilterColumns.putIfAbsent(filterColumn.columnName(), filterColumn) != null) {
                throw new ConfigException(String.format("Duplicate table filter column %s detected, given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", filterColumn.columnName(), tableName, idColumnName, tableNature, tableFilters, argColumnMap));
            }
            List variableNames = TemplateParameterUtils.extractVariableNames((String)filterColumn.filterValue());
            if (!variableNames.contains("argName.local") && !variableNames.contains("argName")) continue;
            throw new ConfigException(String.format("Cannot reference variable 'argName' in table filter (only global variables allowed), given: tableName=%s, idColumnName=%s, tableNature=%s, tableFilters=%s, argColumnMap=%s", tableName, idColumnName, tableNature, tableFilters, argColumnMap));
        }
    }

    @Override
    public ArgColumnAssignment lookupAssignment(String argName, ProcessContext ctx) {
        ConfigUtils.assertContextNotNull(ctx);
        ConfigUtils.assertValidArgName(argName);
        ArgColumnAssignment assignment = this.argColumnMap.get(argName);
        try {
            if (assignment == null && this.autoMappingPolicy.isApplicable(argName)) {
                assignment = this.autoMappingPolicy.map(argName, ctx);
            }
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            AudlangMessage userMessage = AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]);
            throw new LookupException(String.format("An auto-mapping defined for table=%s failed unexpectedly while being applied to argName=%s.", this.tableName, argName), (Throwable)ex, userMessage);
        }
        if (assignment != null && !assignment.column().tableName().equals(this.tableName)) {
            throw new LookupException(String.format("Inconsistent auto-mapping detected: The argName=%s was mapped to %s, a column that does not belong to this table (%s).", argName, assignment, this.tableName), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
        }
        if (assignment == null) {
            throw new LookupException("No meta data available for argName=" + argName, AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
        }
        return assignment;
    }

    public boolean contains(String argName) {
        ConfigUtils.assertValidArgName(argName);
        try {
            return this.argColumnMap.containsKey(argName) || this.autoMappingPolicy.isApplicable(argName);
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            AudlangMessage userMessage = AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]);
            throw new LookupException(String.format("An auto-mapping defined for table=%s failed unexpectedly while being applied to argName=%s.", this.tableName, argName), (Throwable)ex, userMessage);
        }
    }

    @Override
    public int numberOfTables() {
        return 1;
    }

    @Override
    public TableMetaInfo lookupTableMetaInfo(String argName, ProcessContext ctx) {
        ConfigUtils.assertContextNotNull(ctx);
        if (this.contains(argName)) {
            return this;
        }
        throw new LookupException("No TableMetaInfo available for argName=" + argName, AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
    }

    @Override
    public List<TableMetaInfo> allTableMetaInfos() {
        return Collections.singletonList(this);
    }

    private static class Builder
    extends AbstractTableBuilder<Builder>
    implements ConfigBuilderInterfaces.SingleTableDataColumnStep1,
    ConfigBuilderInterfaces.SingleTableStep2,
    ConfigBuilderInterfaces.SingleTableStep3,
    ConfigBuilderInterfaces.SingleTableDataColumnStep2 {
        private Builder(String tableName, ArgMetaInfoLookup argMetaInfoLookup) {
            super(argMetaInfoLookup);
            this.tableName = tableName;
        }

        @Override
        public SingleTableConfig get() {
            this.addPendingColumn();
            return new SingleTableConfig(this.tableName, this.idColumnName, this.determineTableNature(), this.tableFilterColumns, this.argColumnMap, new CompositeAutoMappingPolicy(this.autoMappingPolicies));
        }
    }
}

