/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.cnv.tps.AdlType;
import de.calamanari.adl.cnv.tps.ArgMetaInfo;
import de.calamanari.adl.cnv.tps.DefaultAdlType;
import de.calamanari.adl.sql.DefaultAdlSqlType;
import de.calamanari.adl.sql.config.ArgColumnAssignment;
import de.calamanari.adl.sql.config.ConfigUtils;
import de.calamanari.adl.sql.config.DataColumn;
import de.calamanari.adl.sql.config.DataTableConfig;
import de.calamanari.adl.sql.config.FilterColumn;
import de.calamanari.adl.sql.config.TableMetaInfo;
import de.calamanari.adl.sql.config.TableNature;
import java.util.Collections;
import java.util.List;

public class DummyDataTableConfig
implements DataTableConfig {
    private static final long serialVersionUID = -5545574197848562045L;
    private static final DummyDataTableConfig INSTANCE = new DummyDataTableConfig();
    private static final TableMetaInfo DUMMY_TABLE_META_INFO = new TableMetaInfo(){
        private static final long serialVersionUID = -33333861113941621L;

        @Override
        public String tableName() {
            return "DUMMY_TABLE";
        }

        @Override
        public String idColumnName() {
            return "ID";
        }

        @Override
        public TableNature tableNature() {
            return TableNature.ALL_IDS;
        }

        @Override
        public List<FilterColumn> tableFilters() {
            return Collections.emptyList();
        }

        Object readResolve() {
            return DUMMY_TABLE_META_INFO;
        }
    };

    public static DummyDataTableConfig getInstance() {
        return INSTANCE;
    }

    private DummyDataTableConfig() {
    }

    public boolean contains(String argName) {
        ConfigUtils.assertValidArgName(argName);
        return true;
    }

    @Override
    public ArgColumnAssignment lookupAssignment(String argName, ProcessContext ctx) {
        ConfigUtils.assertContextNotNull(ctx);
        ConfigUtils.assertValidArgName(argName);
        return new ArgColumnAssignment(new ArgMetaInfo(argName, (AdlType)DefaultAdlType.STRING, false, false), new DataColumn(DUMMY_TABLE_META_INFO.tableName(), DummyDataTableConfig.cleanUpperCase(argName), DefaultAdlSqlType.SQL_VARCHAR, false, false, null));
    }

    @Override
    public int numberOfTables() {
        return 1;
    }

    @Override
    public TableMetaInfo lookupTableMetaInfo(String argName, ProcessContext ctx) {
        ConfigUtils.assertContextNotNull(ctx);
        ConfigUtils.assertValidArgName(argName);
        return DUMMY_TABLE_META_INFO;
    }

    @Override
    public List<TableMetaInfo> allTableMetaInfos() {
        return Collections.singletonList(DUMMY_TABLE_META_INFO);
    }

    Object readResolve() {
        return INSTANCE;
    }

    private static String cleanUpperCase(String argName) {
        StringBuilder sb = new StringBuilder(argName.length());
        argName = argName.toUpperCase();
        for (int i = 0; i < argName.length(); ++i) {
            char ch = argName.charAt(i);
            if (ch < ' ' || Character.isWhitespace(ch)) {
                sb.append("_");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

