/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.sql.config.ArgColumnAssignment;
import de.calamanari.adl.sql.config.AutoMappingPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record CompositeAutoMappingPolicy(List<AutoMappingPolicy> members) implements AutoMappingPolicy
{
    private static final long serialVersionUID = 8402766482259227432L;

    public CompositeAutoMappingPolicy(List<AutoMappingPolicy> members) {
        if (members != null && members.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("The members list must not contain any nulls, given: " + String.valueOf(members));
        }
        this.members = members == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<AutoMappingPolicy>(members));
    }

    @Override
    public boolean isApplicable(String argName) {
        return this.members.stream().anyMatch(member -> member.isApplicable(argName));
    }

    @Override
    public ArgColumnAssignment map(String argName, ProcessContext ctx) {
        return this.members.stream().filter(member -> member.isApplicable(argName)).findFirst().orElseThrow(() -> new ConfigException("Auto-mapping error: No column assignment configured for argName=" + argName, AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]))).map(argName, ctx);
    }
}

