/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.cnv.tps.AdlType;
import de.calamanari.adl.cnv.tps.ArgMetaInfo;
import de.calamanari.adl.cnv.tps.ArgMetaInfoLookup;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.config.ArgColumnAssignment;
import de.calamanari.adl.sql.config.AutoMappingPolicy;
import de.calamanari.adl.sql.config.DataColumn;
import de.calamanari.adl.sql.config.DefaultAutoMappingPolicy;
import de.calamanari.adl.sql.config.FilterColumn;
import de.calamanari.adl.sql.config.TableNature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class AbstractTableBuilder<T extends AbstractTableBuilder<T>> {
    private final T builder;
    protected final ArgMetaInfoLookup argMetaInfoLookup;
    protected final Map<String, ArgColumnAssignment> argColumnMap = new HashMap<String, ArgColumnAssignment>();
    protected String tableName;
    protected String idColumnName;
    protected boolean sparseFlag = false;
    protected boolean primaryTableFlag = false;
    protected boolean uniqueIdsFlag = false;
    protected boolean containsAllIdsFlag = false;
    protected String columnName;
    protected List<FilterColumn> tableFilterColumns = new ArrayList<FilterColumn>();
    protected AdlSqlType columnType;
    protected boolean multiRowFlag = false;
    protected boolean alwaysKnownFlag = false;
    protected List<FilterColumn> filterColumns = new ArrayList<FilterColumn>();
    protected boolean haveDataColumns = false;
    protected String mappedArgName;
    protected AdlType mappedArgType;
    protected DefaultAutoMappingPolicy.LocalArgNameExtractor autoMappingExtractor;
    protected Function<DataColumn, AutoMappingPolicy> autoMappingPolicyFunction;
    protected List<AutoMappingPolicy> autoMappingPolicies = new ArrayList<AutoMappingPolicy>();

    protected AbstractTableBuilder(ArgMetaInfoLookup argMetaInfoLookup) {
        this.argMetaInfoLookup = argMetaInfoLookup;
        AbstractTableBuilder instance = this;
        this.builder = instance;
    }

    public T idColumn(String idColumnName) {
        this.idColumnName = idColumnName;
        return this.builder;
    }

    public T withSparseData() {
        this.sparseFlag = true;
        return this.builder;
    }

    public T withUniqueIds() {
        this.uniqueIdsFlag = true;
        return this.builder;
    }

    public T asPrimaryTable() {
        this.primaryTableFlag = true;
        this.containsAllIdsFlag = true;
        return this.builder;
    }

    public T thatContainsAllIds() {
        this.containsAllIdsFlag = true;
        return this.builder;
    }

    public T alwaysKnown() {
        this.alwaysKnownFlag = true;
        return this.builder;
    }

    public T multiRow() {
        this.multiRowFlag = true;
        return this.builder;
    }

    public T filteredBy(String columnName, AdlSqlType columnType, String value) {
        if (this.haveDataColumns) {
            this.filterColumns.add(new FilterColumn(this.tableName, columnName, columnType, value));
        } else {
            this.tableFilterColumns.add(new FilterColumn(this.tableName, columnName, columnType, value));
        }
        return this.builder;
    }

    public T dataColumn(String columnName, AdlSqlType columnType) {
        this.addPendingColumn();
        this.columnName = columnName;
        this.columnType = columnType;
        this.haveDataColumns = true;
        return this.builder;
    }

    public T mappedToArgName(String argName, AdlType argType) {
        if (this.argMetaInfoLookup != null) {
            if (!this.argMetaInfoLookup.contains(argName)) {
                throw new ConfigException(String.format("Illegal attempt to add a new argName=%s. Logical data model cannot be extended.", argName), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
            }
            AdlType type = this.argMetaInfoLookup.typeOf(argName);
            if (argType == null || !type.name().equals(argType.name())) {
                throw new ConfigException(String.format("Illegal attempt to re-define the type of argName=%s. argMetaInfo: %s, given: %s", argName, type, argType), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
            }
        } else {
            this.mappedArgType = argType;
            this.mappedArgName = argName;
        }
        return this.builder;
    }

    public T mappedToArgName(String argName) {
        if (this.argMetaInfoLookup == null) {
            throw new ConfigException(String.format("Unable to lookup type of argName=%s, logical data model (argMetaInfoLookup) not configured.", argName), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)argName, (Object[])new Object[0]));
        }
        this.mappedArgType = this.argMetaInfoLookup.typeOf(argName);
        this.mappedArgName = argName;
        return this.builder;
    }

    public T autoMapped(DefaultAutoMappingPolicy.LocalArgNameExtractor extractor, AdlType argType) {
        this.mappedArgType = argType;
        this.autoMappingExtractor = extractor;
        return this.builder;
    }

    public T autoMapped(Function<DataColumn, AutoMappingPolicy> policyCreator) {
        this.autoMappingPolicyFunction = policyCreator;
        return this.builder;
    }

    protected void addPendingColumn() {
        if (this.haveDataColumns) {
            DataColumn dataColumn = new DataColumn(this.tableName, this.columnName, this.columnType, this.alwaysKnownFlag, this.multiRowFlag, this.filterColumns);
            if (this.autoMappingPolicyFunction != null) {
                this.autoMappingPolicies.add(this.autoMappingPolicyFunction.apply(dataColumn));
            } else if (this.autoMappingExtractor != null) {
                ArgColumnAssignment templateAssignment = new ArgColumnAssignment(new ArgMetaInfo("dummy", this.mappedArgType, this.alwaysKnownFlag, this.multiRowFlag), dataColumn);
                this.autoMappingPolicies.add(new DefaultAutoMappingPolicy(this.autoMappingExtractor, templateAssignment));
            } else {
                ArgColumnAssignment assignment = new ArgColumnAssignment(new ArgMetaInfo(this.mappedArgName, this.mappedArgType, this.alwaysKnownFlag, this.multiRowFlag), dataColumn);
                ArgColumnAssignment prevAssignment = this.argColumnMap.put(this.mappedArgName, assignment);
                if (prevAssignment != null) {
                    throw new ConfigException(String.format("Duplicate mapping detected for argName=%s, given: %s vs. %s", this.mappedArgName, prevAssignment, assignment), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)this.mappedArgName, (Object[])new Object[0]));
                }
            }
            this.columnName = null;
            this.columnType = null;
            this.multiRowFlag = false;
            this.alwaysKnownFlag = false;
            this.filterColumns.clear();
            this.mappedArgName = null;
            this.mappedArgType = null;
            this.autoMappingPolicyFunction = null;
            this.autoMappingExtractor = null;
        }
    }

    protected TableNature determineTableNature() {
        if (this.primaryTableFlag && this.sparseFlag) {
            return TableNature.PRIMARY_SPARSE;
        }
        if (this.primaryTableFlag && this.uniqueIdsFlag) {
            return TableNature.PRIMARY_UNIQUE;
        }
        if (this.primaryTableFlag) {
            return TableNature.PRIMARY;
        }
        if (this.containsAllIdsFlag && this.sparseFlag) {
            return TableNature.ALL_IDS_SPARSE;
        }
        if (this.containsAllIdsFlag && this.uniqueIdsFlag) {
            return TableNature.ALL_IDS_UNIQUE;
        }
        if (this.containsAllIdsFlag) {
            return TableNature.ALL_IDS;
        }
        if (this.sparseFlag) {
            return TableNature.ID_SUBSET_SPARSE;
        }
        if (this.uniqueIdsFlag) {
            return TableNature.ID_SUBSET_UNIQUE;
        }
        return TableNature.ID_SUBSET;
    }
}

