/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.ConversionException;
import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.cnv.TemplateParameterUtils;
import de.calamanari.adl.cnv.tps.AdlDateUtils;
import de.calamanari.adl.cnv.tps.AdlType;
import de.calamanari.adl.cnv.tps.ArgMetaInfo;
import de.calamanari.adl.cnv.tps.ContainsNotSupportedException;
import de.calamanari.adl.cnv.tps.DefaultAdlType;
import de.calamanari.adl.cnv.tps.LessThanGreaterThanNotSupportedException;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.irl.NegationExpression;
import de.calamanari.adl.irl.Operand;
import de.calamanari.adl.irl.SimpleExpression;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.DefaultAdlSqlType;
import de.calamanari.adl.sql.QueryParameter;
import de.calamanari.adl.sql.QueryParameterCreator;
import de.calamanari.adl.sql.cnv.ColumnCondition;
import de.calamanari.adl.sql.cnv.ColumnConditionType;
import de.calamanari.adl.sql.cnv.ConversionDirective;
import de.calamanari.adl.sql.cnv.SqlConversionProcessContext;
import de.calamanari.adl.sql.config.AdlSqlColumn;
import de.calamanari.adl.sql.config.DataColumn;
import de.calamanari.adl.sql.config.DataTableConfig;
import de.calamanari.adl.sql.config.FilterColumn;
import de.calamanari.adl.sql.config.TableMetaInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public record MatchCondition(MatchOperator operator, boolean isNegation, String argNameLeft, TableMetaInfo tableLeft, DataColumn columnLeft, String argNameRight, TableMetaInfo tableRight, DataColumn columnRight, List<ColumnCondition> columnConditions) implements Serializable
{
    private static final ArgMetaInfo FILTER_META_INFO = new ArgMetaInfo("<FILTER>", (AdlType)DefaultAdlType.STRING, false, false);
    private static final String NEXT_DAY_PARAM_SUFFIX = "_NEXT_DAY";

    public MatchCondition(MatchOperator operator, boolean isNegation, String argNameLeft, TableMetaInfo tableLeft, DataColumn columnLeft, String argNameRight, TableMetaInfo tableRight, DataColumn columnRight, List<ColumnCondition> columnConditions) {
        ColumnCondition parameters;
        if (operator == null || argNameLeft == null || tableLeft == null || columnLeft == null || columnConditions == null || columnConditions.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(String.format("The arguments must not be null nor contain any nulls, given: operator=%s, argNameLeft=%s, tableLeft=%s, columnLeft=%s, argNameRight=%s, tableRight=%s, columnRight=%s and columnConditions=%s", operator, argNameLeft, tableLeft, columnLeft, argNameRight, tableRight, columnRight, columnConditions));
        }
        if (!MatchCondition.checkColumnsUnique(columnConditions)) {
            throw new IllegalArgumentException(String.format("A column must be unique inside the columnConditions list resp. for both sides of a reference match, given: operator=%s, argNameLeft=%s, tableLeft=%s, columnLeft=%s, argNameRight=%s, tableRight=%s, columnRight=%s, and columnConditions=%s\nIn this query the same column would be compared twice within the same condition (usually this cannot be fulfilled).\nThis rather indicates a bug in the implementation than a mapping problem.\n", operator, argNameLeft, tableLeft, columnLeft, argNameRight, tableRight, columnRight, columnConditions));
        }
        if (tableRight == null && (parameters = (ColumnCondition)columnConditions.stream().filter(cp -> cp.column().columnName().equals(columnLeft.columnName())).findAny().orElse(null)) == null) {
            throw new IllegalArgumentException(String.format("For a value match you must specify at least one parameter for column %s, given: operator=%s, argNameLeft=%s, tableLeft=%s, columnLeft=%s, argNameRight=%s, tableRight=%s, columnRight=%s, and columnConditions=%s", columnLeft.columnName(), operator, argNameLeft, tableLeft, columnLeft, argNameRight, tableRight, columnRight, columnConditions));
        }
        if (!MatchCondition.checkAllNullOrAllNotNull(argNameRight, tableRight, columnRight)) {
            throw new IllegalArgumentException(String.format("The arguments argNameRight, tableRight, columnRight either all have to be null or all not null, given: operator=%s, argNameLeft=%s, tableLeft=%s, columnLeft=%s, argNameRight=%s, tableRight=%s, columnRight=%s, and columnConditions=%s", operator, argNameLeft, tableLeft, columnLeft, argNameRight, tableRight, columnRight, columnConditions));
        }
        this.operator = operator;
        this.isNegation = isNegation;
        this.argNameLeft = argNameLeft;
        this.tableLeft = tableLeft;
        this.columnLeft = columnLeft;
        this.argNameRight = argNameRight;
        this.tableRight = tableRight;
        this.columnRight = columnRight;
        this.columnConditions = columnConditions.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ColumnCondition>(columnConditions));
    }

    private static boolean checkColumnsUnique(List<ColumnCondition> columnConditions) {
        List<AdlSqlColumn> leftColumns = columnConditions.stream().filter(Predicate.not(condition -> condition.type() == ColumnConditionType.FILTER_RIGHT)).map(ColumnCondition::column).toList();
        List<AdlSqlColumn> rightColumns = columnConditions.stream().filter(condition -> condition.type() == ColumnConditionType.FILTER_RIGHT).map(ColumnCondition::column).toList();
        return leftColumns.size() == new HashSet<AdlSqlColumn>(leftColumns).size() && rightColumns.size() == new HashSet<AdlSqlColumn>(rightColumns).size();
    }

    private static boolean checkAllNullOrAllNotNull(Object ... params) {
        boolean anyNull = false;
        boolean anyNotNull = false;
        for (Object param : params) {
            if (param != null && anyNull || param == null && anyNotNull) {
                return false;
            }
            if (param == null) {
                anyNull = true;
                continue;
            }
            anyNotNull = true;
        }
        return true;
    }

    public static MatchCondition createSimpleCondition(SimpleExpression expression, SqlConversionProcessContext ctx) {
        if (expression instanceof NegationExpression) {
            NegationExpression neg = (NegationExpression)expression;
            return MatchCondition.negate(MatchCondition.createSimpleCondition((SimpleExpression)neg.delegate(), ctx));
        }
        return MatchCondition.createMatchConditionInternal(expression, ctx);
    }

    private static MatchCondition createMatchConditionInternal(SimpleExpression expression, SqlConversionProcessContext ctx) {
        DataTableConfig dataTableConfig = ctx.getDataBinding().dataTableConfig();
        MatchOperator operator = expression.operator();
        String argNameLeft = expression.argName();
        DataColumn columnLeft = dataTableConfig.lookupColumn(argNameLeft, ctx);
        TableMetaInfo tableLeft = dataTableConfig.lookupTableMetaInfo(argNameLeft, ctx);
        String argNameRight = expression.referencedArgName();
        if (argNameRight != null && ConversionDirective.DISABLE_REFERENCE_MATCHING.check(ctx.getGlobalFlags())) {
            AudlangMessage userMessage = AudlangMessage.argRefMsg((AudlangUserMessage)CommonErrors.ERR_2101_REFERENCE_MATCH_NOT_SUPPORTED, (String)argNameLeft, (String)argNameRight, (Object[])new Object[0]);
            throw new ConversionException(String.format("Reference matching disabled by global directive, given: expression=%s, argName=%s", expression, argNameLeft), userMessage);
        }
        DataColumn columnRight = argNameRight != null ? dataTableConfig.lookupColumn(argNameRight, ctx) : null;
        TableMetaInfo tableRight = argNameRight != null ? dataTableConfig.lookupTableMetaInfo(argNameRight, ctx) : null;
        ArrayList<ColumnCondition> columnParameters = new ArrayList<ColumnCondition>();
        if (columnRight == null) {
            columnParameters.add(MatchCondition.createPrimaryColumnCondition(expression, argNameLeft, columnLeft, ctx));
        }
        MatchCondition.createFilterColumnConditions(expression, columnParameters, ctx);
        return new MatchCondition(operator, false, argNameLeft, tableLeft, columnLeft, argNameRight, tableRight, columnRight, columnParameters);
    }

    public static boolean shouldAlignDate(AdlType type, AdlSqlType columnType, ProcessContext ctx) {
        return type.getBaseType() == DefaultAdlType.DATE && (columnType.getBaseType() == DefaultAdlSqlType.SQL_BIGINT || columnType.getBaseType() == DefaultAdlSqlType.SQL_INTEGER || columnType.getBaseType() == DefaultAdlSqlType.SQL_TIMESTAMP) && !ConversionDirective.DISABLE_DATE_TIME_ALIGNMENT.check(ctx.getGlobalFlags());
    }

    private static ColumnCondition createPrimaryColumnCondition(SimpleExpression expression, String argName, DataColumn columnLeft, SqlConversionProcessContext ctx) {
        String value;
        AdlSqlType columnType = columnLeft.columnType();
        DataTableConfig dataTableConfig = ctx.getDataBinding().dataTableConfig();
        MatchOperator operator = expression.operator();
        String string = value = expression.operand() != null ? expression.operand().value() : null;
        if ((expression.operator() == MatchOperator.EQUALS || expression.operator() == MatchOperator.GREATER_THAN) && MatchCondition.shouldAlignDate(dataTableConfig.typeOf(argName), columnType, ctx)) {
            QueryParameter date = columnType.getQueryParameterCreator().createParameter(dataTableConfig.lookup(argName), value, operator, columnType);
            ctx.registerParameter(date);
            String valueNextDay = AdlDateUtils.computeDayAfter((String)dataTableConfig.typeOf(argName).getFormatter().format(argName, value, operator));
            QueryParameter nextDate = columnType.getQueryParameterCreator().createParameter(date.id() + NEXT_DAY_PARAM_SUFFIX, dataTableConfig.lookup(argName), valueNextDay, operator, columnType);
            ctx.registerParameter(nextDate);
            return MatchCondition.createAlignedDateColumnCondition(expression, columnLeft, operator, date, nextDate);
        }
        if (expression.operator() == MatchOperator.CONTAINS) {
            MatchCondition.assertContainsSupported(expression, argName, columnType, ctx);
            value = ctx.getDataBinding().sqlContainsPolicy().prepareSearchSnippet(value);
        } else if (expression.operator() == MatchOperator.LESS_THAN || expression.operator() == MatchOperator.GREATER_THAN) {
            MatchCondition.assertLessThanGreaterThanSupported(expression, argName, columnType, ctx);
        }
        List<QueryParameter> parameters = Collections.singletonList(columnType.getQueryParameterCreator().createParameter(dataTableConfig.lookup(argName), value, operator, columnType));
        ctx.registerParameter(parameters.get(0));
        return new ColumnCondition(ColumnConditionType.SINGLE, operator, columnLeft, parameters);
    }

    private static void assertLessThanGreaterThanSupported(SimpleExpression expression, String argName, AdlSqlType columnType, SqlConversionProcessContext ctx) {
        DataTableConfig dataTableConfig = ctx.getDataBinding().dataTableConfig();
        if (!columnType.supportsLessThanGreaterThan() || !dataTableConfig.typeOf(argName).supportsLessThanGreaterThan()) {
            AudlangMessage userMessage = AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_2201_LTGT_NOT_SUPPORTED, (String)argName, (Object[])new Object[0]);
            throw new LessThanGreaterThanNotSupportedException(String.format("LESS/GREATER THAN not supported by type=%s or columnType=%s, given: expression=%s, argName=%s", dataTableConfig.typeOf(argName), columnType, expression, argName), userMessage);
        }
        if (ConversionDirective.DISABLE_LESS_THAN_GREATER_THAN.check(ctx.getGlobalFlags())) {
            AudlangMessage userMessage = AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_2201_LTGT_NOT_SUPPORTED, (String)argName, (Object[])new Object[0]);
            throw new LessThanGreaterThanNotSupportedException(String.format("LESS/GREATER THAN disabled by global directive, given: expression=%s, argName=%s", expression, argName), userMessage);
        }
    }

    private static void assertContainsSupported(SimpleExpression expression, String argName, AdlSqlType columnType, SqlConversionProcessContext ctx) {
        DataTableConfig dataTableConfig = ctx.getDataBinding().dataTableConfig();
        if (!columnType.supportsContains() || !dataTableConfig.typeOf(argName).supportsContains()) {
            AudlangMessage userMessage = AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_2200_CONTAINS_NOT_SUPPORTED, (String)argName, (Object[])new Object[0]);
            throw new ContainsNotSupportedException(String.format("CONTAINS not supported by type=%s or columnType=%s, given: expression=%s, argName=%s", dataTableConfig.typeOf(argName), columnType, expression, argName), userMessage);
        }
        if (ConversionDirective.DISABLE_CONTAINS.check(ctx.getGlobalFlags())) {
            AudlangMessage userMessage = AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_2200_CONTAINS_NOT_SUPPORTED, (String)argName, (Object[])new Object[0]);
            throw new ContainsNotSupportedException(String.format("CONTAINS disabled by global directive, given: expression=%s, argName=%s", expression, argName), userMessage);
        }
    }

    private static ColumnCondition createAlignedDateColumnCondition(SimpleExpression expression, DataColumn columnLeft, MatchOperator operator, QueryParameter date, QueryParameter nextDate) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        if (expression.operator() == MatchOperator.EQUALS) {
            parameters.add(date);
            parameters.add(nextDate);
            return new ColumnCondition(ColumnConditionType.DATE_RANGE, operator, columnLeft, parameters);
        }
        parameters.add(nextDate);
        return new ColumnCondition(ColumnConditionType.AFTER_TODAY, operator, columnLeft, parameters);
    }

    private static void createFilterColumnConditions(SimpleExpression expression, List<ColumnCondition> columnConditions, SqlConversionProcessContext ctx) {
        MatchCondition.createFilterColumnConditions(ColumnConditionType.FILTER_LEFT, expression.argName(), columnConditions, ctx);
        if (expression.referencedArgName() != null) {
            MatchCondition.createFilterColumnConditions(ColumnConditionType.FILTER_RIGHT, expression.referencedArgName(), columnConditions, ctx);
        }
    }

    private static void createFilterColumnConditions(ColumnConditionType filterType, String argName, List<ColumnCondition> columnConditions, SqlConversionProcessContext ctx) {
        DataTableConfig dataTableConfig = ctx.getDataBinding().dataTableConfig();
        ctx.getGlobalVariables().put("argName", argName);
        DataColumn column = dataTableConfig.lookupColumn(argName, ctx);
        for (FilterColumn filterColumn : column.filters()) {
            columnConditions.add(MatchCondition.createFilterColumnCondition(filterType, filterColumn, ctx));
        }
        ctx.getGlobalVariables().remove("argName");
        for (FilterColumn filterColumn : dataTableConfig.lookupTableMetaInfo(argName, ctx).tableFilters()) {
            columnConditions.add(MatchCondition.createFilterColumnCondition(filterType, filterColumn, ctx));
        }
    }

    public static ColumnCondition createFilterColumnCondition(ColumnConditionType filterType, FilterColumn filterColumn, SqlConversionProcessContext ctx) {
        QueryParameter parameter = null;
        parameter = filterColumn.columnType().getQueryParameterCreator().createParameter(FILTER_META_INFO, TemplateParameterUtils.replaceVariables((String)filterColumn.filterValue(), ctx.getGlobalVariables()::get), MatchOperator.EQUALS, filterColumn.columnType());
        ctx.registerParameter(parameter);
        return new ColumnCondition(filterType, MatchOperator.EQUALS, filterColumn, Collections.singletonList(parameter));
    }

    public static MatchCondition negate(MatchCondition condition) {
        return new MatchCondition(condition.operator, true, condition.argNameLeft, condition.tableLeft, condition.columnLeft, condition.argNameRight, condition.tableRight, condition.columnRight, condition.columnConditions);
    }

    public static MatchCondition createInClauseCondition(List<SimpleExpression> expressions, SqlConversionProcessContext ctx) {
        DataTableConfig dataTableConfig = ctx.getDataBinding().dataTableConfig();
        if (expressions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot creatre IN or NOT IN clause match condition without member expressions, given: expressions=%s", expressions));
        }
        if (expressions.size() == 1) {
            return MatchCondition.createSimpleCondition(expressions.get(0), ctx);
        }
        Class cls = expressions.get(0).getClass();
        boolean negationFlag = cls == NegationExpression.class;
        if (expressions.stream().anyMatch(Predicate.not(cls::isInstance))) {
            throw new IllegalArgumentException(String.format("To create IN or NOT IN clause match condition, all member expressions must be of the same type, given: expressions=%s", expressions));
        }
        String argNameLeft = expressions.get(0).argName();
        List<String> uniqueValues = MatchCondition.extractInClauseValues(expressions, argNameLeft, negationFlag ? "NOT IN" : "IN");
        if (uniqueValues.size() == 1) {
            return MatchCondition.createSimpleCondition(expressions.get(0), ctx);
        }
        MatchOperator operator = MatchOperator.EQUALS;
        DataColumn columnLeft = dataTableConfig.lookupColumn(argNameLeft, ctx);
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>(uniqueValues.size());
        QueryParameterCreator creator = columnLeft.columnType().getQueryParameterCreator();
        ArgMetaInfo argMetaInfo = dataTableConfig.lookup(argNameLeft);
        AdlSqlType columnType = columnLeft.columnType();
        for (String value : uniqueValues) {
            QueryParameter parameter = creator.createParameter(argMetaInfo, value, operator, columnType);
            ctx.registerParameter(parameter);
            parameters.add(parameter);
        }
        ColumnCondition inCondition = new ColumnCondition(ColumnConditionType.IN_CLAUSE, operator, columnLeft, parameters);
        ArrayList<ColumnCondition> columnConditions = new ArrayList<ColumnCondition>();
        columnConditions.add(inCondition);
        MatchCondition.createFilterColumnConditions(expressions.get(0), columnConditions, ctx);
        return new MatchCondition(operator, negationFlag, argNameLeft, dataTableConfig.lookupTableMetaInfo(argNameLeft, ctx), columnLeft, null, null, null, columnConditions);
    }

    private static List<String> extractInClauseValues(List<SimpleExpression> expressions, String argNameLeft, String clauseInfo) {
        if (!expressions.stream().map(SimpleExpression::argName).allMatch(argNameLeft::equals)) {
            throw new IllegalArgumentException(String.format("To create an %s-clause match condition, all expressions must carry the same argName, given: orExpression=%s", clauseInfo, expressions));
        }
        if (!expressions.stream().map(SimpleExpression::operator).allMatch(arg_0 -> MatchOperator.EQUALS.equals(arg_0))) {
            throw new IllegalArgumentException(String.format("To create an %s-clause match condition, all expression operators must be 'EQUALS', given: orExpression=%s", clauseInfo, expressions));
        }
        if (expressions.stream().map(SimpleExpression::operand).anyMatch(op -> op == null || op.isReference())) {
            throw new IllegalArgumentException(String.format("To create an %s-clause match condition, all expression operands must be non-null values, given: orExpression=%s", clauseInfo, expressions));
        }
        return expressions.stream().map(SimpleExpression::operand).map(Operand::value).distinct().toList();
    }

    public String dataColumnNameLeft(boolean qualified) {
        if (qualified) {
            return this.tableLeft.tableName() + "." + this.columnLeft.columnName();
        }
        return this.columnLeft.columnName();
    }

    public String dataColumnNameRight(boolean qualified) {
        if (this.argNameRight == null) {
            throw new IllegalStateException("This is not a reference match: " + String.valueOf(this));
        }
        if (qualified) {
            return this.tableRight.tableName() + "." + this.columnRight.columnName();
        }
        return this.columnRight.columnName();
    }

    public String idColumnNameLeft(boolean qualified) {
        if (qualified) {
            return this.tableLeft.tableName() + "." + this.tableLeft.idColumnName();
        }
        return this.tableLeft.idColumnName();
    }

    public String idColumnNameRight(boolean qualified) {
        if (qualified) {
            return this.tableRight.tableName() + "." + this.tableRight.idColumnName();
        }
        return this.tableRight.idColumnName();
    }

    public boolean isReferenceMatch() {
        return this.tableRight != null;
    }

    public boolean isSingleTableReferenceMatchInvolvingMultipleRows() {
        return this.tableRight != null && this.tableLeft.tableName().equals(this.tableRight.tableName()) && (this.columnLeft.isMultiRow() || this.columnRight.isMultiRow());
    }

    public boolean isDualTableReferenceMatch() {
        return this.tableLeft != null && this.tableRight != null && !this.tableLeft.tableName().equals(this.tableRight.tableName());
    }

    public boolean isNullMatch() {
        return this.operator == MatchOperator.IS_UNKNOWN;
    }

    public ColumnCondition getPrimaryColumnCondition() {
        if (this.argNameRight != null) {
            return null;
        }
        return this.columnConditions.stream().filter(condition -> condition.column().columnName().equals(this.columnLeft.columnName())).findAny().orElse(null);
    }

    public ColumnConditionType type() {
        ColumnCondition primaryColumnCondition = this.getPrimaryColumnCondition();
        return primaryColumnCondition == null ? ColumnConditionType.REFERENCE : primaryColumnCondition.type();
    }

    public boolean hasAnyFilterColumnConditions() {
        return this.columnConditions.stream().anyMatch(condition -> condition.column() instanceof FilterColumn);
    }

    public List<ColumnCondition> getLeftFilterColumnConditions() {
        return this.columnConditions.stream().filter(condition -> condition.type() == ColumnConditionType.FILTER_LEFT).toList();
    }

    public List<ColumnCondition> getRightFilterColumnConditions() {
        if (this.tableRight == null) {
            return Collections.emptyList();
        }
        return this.columnConditions.stream().filter(condition -> condition.type() == ColumnConditionType.FILTER_RIGHT).toList();
    }
}

