/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.ConversionException;
import de.calamanari.adl.Flag;
import de.calamanari.adl.FormatStyle;
import de.calamanari.adl.FormatUtils;
import de.calamanari.adl.irl.CombinedExpression;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.irl.MatchExpression;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.irl.NegationExpression;
import de.calamanari.adl.irl.SimpleExpression;
import de.calamanari.adl.sql.QueryTemplateWithParameters;
import de.calamanari.adl.sql.QueryType;
import de.calamanari.adl.sql.SqlFormatUtils;
import de.calamanari.adl.sql.cnv.AbstractSqlExpressionConverter;
import de.calamanari.adl.sql.cnv.ColumnCondition;
import de.calamanari.adl.sql.cnv.ColumnConditionType;
import de.calamanari.adl.sql.cnv.ConversionDirective;
import de.calamanari.adl.sql.cnv.ConversionHint;
import de.calamanari.adl.sql.cnv.ExpressionAlias;
import de.calamanari.adl.sql.cnv.MatchCondition;
import de.calamanari.adl.sql.cnv.SqlConversionContext;
import de.calamanari.adl.sql.config.DataBinding;
import de.calamanari.adl.sql.config.TableMetaInfo;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlExpressionConverter
extends AbstractSqlExpressionConverter<SqlConversionContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSqlExpressionConverter.class);
    private boolean auxiliaryMainTableRequired = false;
    private boolean haveWithClause = false;

    public DefaultSqlExpressionConverter(Supplier<? extends SqlConversionContext> contextSupplier, DataBinding dataBinding, Map<String, Serializable> globalVariables, Set<Flag> flags) {
        super(contextSupplier, dataBinding, globalVariables, flags);
    }

    public DefaultSqlExpressionConverter(DataBinding dataBinding, Map<String, Serializable> globalVariables, Set<Flag> flags) {
        this((Supplier<? extends SqlConversionContext>)((Supplier<SqlConversionContext>)SqlConversionContext::new), dataBinding, globalVariables, flags);
    }

    public DefaultSqlExpressionConverter(DataBinding dataBinding, Map<String, Serializable> globalVariables, Flag ... flags) {
        this((Supplier<? extends SqlConversionContext>)((Supplier<SqlConversionContext>)SqlConversionContext::new), dataBinding, globalVariables, (Set<Flag>)(flags != null ? new HashSet<Flag>(Arrays.asList(flags)) : null));
    }

    public DefaultSqlExpressionConverter(DataBinding dataBinding, Set<Flag> flags) {
        this((Supplier<? extends SqlConversionContext>)((Supplier<SqlConversionContext>)SqlConversionContext::new), dataBinding, (Map<String, Serializable>)null, flags);
    }

    public DefaultSqlExpressionConverter(DataBinding dataBinding, Flag ... flags) {
        this((Supplier<? extends SqlConversionContext>)((Supplier<SqlConversionContext>)SqlConversionContext::new), dataBinding, (Map<String, Serializable>)null, (Set<Flag>)(flags != null ? new HashSet<Flag>(Arrays.asList(flags)) : null));
    }

    protected QueryTemplateWithParameters finishResult() {
        QueryTemplateWithParameters res = QueryTemplateWithParameters.of(this.createSqlQueryTemplate(), this.getProcessContext().getRegisteredParameters());
        LOGGER.trace("Conversion complete:\n{}", (Object)res);
        return res;
    }

    @Override
    public void init() {
        super.init();
        this.haveWithClause = false;
        this.auxiliaryMainTableRequired = false;
    }

    protected String createSqlQueryTemplate() {
        StringBuilder sb = new StringBuilder();
        this.augmentationListener().handleBeforeScript(sb, this.getProcessContext());
        this.aliasHelper().determinePrimaryAlias(this.expressionHelper(), this.aliasesInWhereClause());
        this.determineMainTable();
        this.aliasHelper().determineStartSelectionName();
        this.appendWithClauseIfRequired(sb);
        if (this.auxiliaryMainTableRequired) {
            this.determineAuxiliaryMainTable();
        }
        FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)this.getNormalizedDepth(), (boolean)true);
        this.augmentationListener().handleBeforeMainStatement(sb, this.getProcessContext(), this.haveWithClause);
        this.appendMainSelectFrom(sb);
        this.appendAliasJoinsIfRequired(sb);
        FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)this.getNormalizedDepth(), (boolean)true);
        sb.append("WHERE");
        FormatUtils.space((StringBuilder)sb);
        this.appendGlobalWhereCondition(sb);
        if (this.getQueryType() == QueryType.SELECT_DISTINCT_ID_ORDERED) {
            Object idColumnName = this.getMainIdColumnName();
            idColumnName = ((String)idColumnName).equals(this.getIdColumnName()) ? this.aliasHelper().getStartSelectionName() + "." + (String)idColumnName : this.getIdColumnName();
            SqlFormatUtils.appendOrderBy(sb, (String)idColumnName, this.style(), this.getCurrentDepth());
        }
        this.augmentationListener().handleAfterScript(sb, this.getProcessContext());
        return sb.toString();
    }

    protected void appendWithClauseIfRequired(StringBuilder sb) {
        ArrayList<String> withClauseElements = new ArrayList<String>();
        this.addMainWithClauseElement(withClauseElements);
        this.addExtraAliasWithClauseElements(withClauseElements);
        Collections.sort(withClauseElements);
        if (!withClauseElements.isEmpty()) {
            sb.append("WITH");
            FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)this.getNormalizedDepth(), (boolean)true);
            for (int idx = 0; idx < withClauseElements.size(); ++idx) {
                if (idx > 0) {
                    sb.append(",");
                    FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)this.getNormalizedDepth(), (boolean)true);
                }
                sb.append((String)withClauseElements.get(idx));
            }
            this.haveWithClause = true;
        }
    }

    protected void appendMainSelectFrom(StringBuilder sb) {
        sb.append("SELECT");
        FormatUtils.space((StringBuilder)sb);
        this.augmentationListener().handleAfterMainSelect(sb, this.getProcessContext());
        if (this.getQueryType() == QueryType.SELECT_DISTINCT_COUNT) {
            sb.append("COUNT");
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"("});
        }
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"DISTINCT"});
        String idColumnName = this.getMainIdColumnName();
        if (this.getMainTable() != null) {
            if (ConversionHint.NO_JOINS_REQUIRED.check(this.flags())) {
                FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{idColumnName});
            } else {
                SqlFormatUtils.appendQualifiedColumnName(sb, this.aliasHelper().getStartSelectionName(), idColumnName);
            }
        } else {
            SqlFormatUtils.appendQualifiedColumnName(sb, this.aliasHelper().getStartSelectionName(), idColumnName);
        }
        if (this.getQueryType() == QueryType.SELECT_DISTINCT_COUNT) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{")"});
        } else if (!idColumnName.equals(this.getIdColumnName())) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"AS"});
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{this.getIdColumnName()});
        }
        FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)this.getNormalizedDepth(), (boolean)true);
        sb.append("FROM");
        FormatUtils.space((StringBuilder)sb);
        TableMetaInfo mainTable = this.getMainTable();
        if (mainTable != null) {
            sb.append(mainTable.tableName());
            if (!ConversionHint.NO_JOINS_REQUIRED.check(this.flags()) && !this.aliasHelper().getStartSelectionName().equals(mainTable.tableName()) && this.stats().requiredTables().contains(mainTable.tableName())) {
                FormatUtils.space((StringBuilder)sb);
                sb.append(this.aliasHelper().getStartSelectionName());
            }
        } else {
            sb.append(this.aliasHelper().getStartSelectionName());
        }
    }

    protected void addMainWithClauseElement(List<String> withClauseElements) {
        StringBuilder sbMainWith = new StringBuilder();
        if (this.aliasHelper().getPrimaryAlias() != null && this.getMainTable() == null) {
            super.appendAliasQuery(sbMainWith, this.aliasHelper().getPrimaryAlias());
        } else if (this.getMainTable() == null && this.dataBinding().dataTableConfig().primaryTable() == null) {
            List<ExpressionAlias> aliasesForUnion = this.aliasHelper().determineAdequateBaseQueryCombination(this.expressionHelper(), this.aliasHelper().getOrderedAliasList());
            if (aliasesForUnion.size() == 1) {
                this.aliasHelper().setPrimaryAlias(aliasesForUnion.get(0));
                this.aliasHelper().setStartSelectionName(this.aliasHelper().getPrimaryAlias().getName());
                super.appendAliasQuery(sbMainWith, this.aliasHelper().getPrimaryAlias());
            } else if (!aliasesForUnion.isEmpty() && !ConversionDirective.DISABLE_UNION.check(this.flags())) {
                super.appendAliasUnionBaseQuery(sbMainWith, aliasesForUnion);
            } else if (!ConversionDirective.DISABLE_UNION.check(this.flags()) && this.dataBinding().dataTableConfig().numberOfTables() > 1 && this.dataBinding().dataTableConfig().tablesThatContainAllIds().isEmpty()) {
                super.appendAllTableUnionBaseQuery(sbMainWith);
            }
        }
        String element = sbMainWith.toString().trim();
        if (!element.isEmpty()) {
            withClauseElements.add(sbMainWith.toString().trim());
        } else if (this.getMainTable() == null && this.aliasHelper().getPrimaryAlias() == null) {
            this.auxiliaryMainTableRequired = true;
        }
    }

    protected void addExtraAliasWithClauseElements(List<String> withClauseElements) {
        List<ExpressionAlias> extraAliases = this.collectFurtherRequiredAliases();
        if (!extraAliases.isEmpty()) {
            for (int idx = 0; idx < extraAliases.size(); ++idx) {
                StringBuilder sb = new StringBuilder();
                super.appendAliasQuery(sb, extraAliases.get(idx));
                withClauseElements.add(sb.toString().trim());
            }
        }
    }

    protected void determineMainTable() {
        Set flags = this.getProcessContext().getGlobalFlags();
        if (ConversionHint.SIMPLE_CONDITION.check(flags)) {
            this.setMainTable(this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(this.stats().requiredTables().iterator().next()));
            this.aliasHelper().setStartSelectionName(this.getMainTable().tableName());
        } else if (ConversionHint.SINGLE_TABLE_CONTAINING_ALL_ROWS.check(flags)) {
            String tableName = this.stats().requiredTables().iterator().next();
            TableMetaInfo tmi = this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(tableName);
            if (this.tablesInWhereClause().contains(tmi)) {
                this.setMainTable(tmi);
                this.aliasHelper().setStartSelectionName(this.getMainTable().tableName());
                this.aliasHelper().setPrimaryAlias(null);
            }
        } else if (this.aliasHelper().getPrimaryAlias() != null && !this.aliasesInWhereClause().contains(this.aliasHelper().getPrimaryAlias())) {
            if (this.aliasHelper().isPrimaryAliasRunnningOnPrimaryTable(this.expressionHelper())) {
                this.setMainTable(this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(this.dataBinding().dataTableConfig().primaryTable()));
            } else {
                this.setMainTable(this.conditionFactory().createMatchCondition(this.aliasHelper().getPrimaryAlias().getExpression()).tableLeft());
            }
            this.aliasHelper().setStartSelectionName(this.getMainTable().tableName());
        }
        if (ConversionDirective.ENFORCE_PRIMARY_TABLE.check(flags)) {
            String primaryTableName = this.dataBinding().dataTableConfig().primaryTable();
            TableMetaInfo mainTable = this.getMainTable();
            if (!(primaryTableName == null || mainTable != null && mainTable.tableName().equals(primaryTableName))) {
                this.setMainTable(this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(this.dataBinding().dataTableConfig().primaryTable()));
                this.aliasHelper().setStartSelectionName(this.getMainTable().tableName());
                this.aliasHelper().setPrimaryAlias(null);
            } else if (primaryTableName == null) {
                throw new ConversionException(String.format("Unable to create base query for expression=%s. Please configure a primary table or remove the directive ENFORCE_PRIMARY_TABLE.", this.getRootExpression()), AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (Object[])new Object[0]));
            }
        }
    }

    protected void determineAuxiliaryMainTable() {
        if (this.dataBinding().dataTableConfig().primaryTable() != null) {
            this.setMainTable(this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(this.dataBinding().dataTableConfig().primaryTable()));
        } else if (this.dataBinding().dataTableConfig().numberOfTables() == 1) {
            this.setMainTable(this.dataBinding().dataTableConfig().allTableMetaInfos().get(0));
        } else {
            List<String> namesOfTablesWithAllIds = this.dataBinding().dataTableConfig().tablesThatContainAllIds();
            if (namesOfTablesWithAllIds.isEmpty()) {
                throw new ConversionException(String.format("Unable to create base query for expression=%s. Please mark at least one table as containing all IDs or specify a primary table.", this.getRootExpression()));
            }
            String tableName = this.stats().requiredTables().stream().filter(namesOfTablesWithAllIds::contains).findFirst().orElse(namesOfTablesWithAllIds.get(0));
            this.setMainTable(this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(tableName));
        }
        this.aliasHelper().setStartSelectionName(this.getMainTable().tableName());
    }

    protected String detectJoinType(String tableOrAliasName, List<CoreExpression> onRestrictions) {
        TableMetaInfo tmi = this.stats().requiredTables().contains(tableOrAliasName) ? this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(tableOrAliasName) : null;
        String joinType = "INNER JOIN";
        if (ConversionHint.LEFT_OUTER_JOINS_REQUIRED.check(this.flags())) {
            joinType = "LEFT OUTER JOIN";
            if (tmi != null && this.tablesInWhereClause().contains(tmi) && tmi.tableNature().containsAllIds() && (onRestrictions.isEmpty() || this.expressionHelper().isSupersetOfRootExpression(CombinedExpression.orOf(onRestrictions)))) {
                joinType = "INNER JOIN";
            }
        }
        return joinType;
    }

    protected List<CoreExpression> findOnRestrictions(TableMetaInfo table) {
        TreeSet<CoreExpression> expressionCandidates = new TreeSet<CoreExpression>();
        List<ExpressionAlias> aliasCandidates = this.aliasHelper().getOrderedAliasList().stream().filter(Predicate.not(this.aliasesInWhereClause()::contains)).toList();
        for (ExpressionAlias alias : aliasCandidates) {
            this.addOnRestrictionIfApplicable(table, alias, expressionCandidates);
        }
        return this.expressionHelper().consolidateAliasGroupExpressions(this.filterApplicableOnConditionExpressions(expressionCandidates));
    }

    protected void addOnRestrictionIfApplicable(TableMetaInfo table, ExpressionAlias alias, Set<CoreExpression> expressionCandidates) {
        MatchCondition condition = this.conditionFactory().createMatchCondition(alias.getExpression());
        if (condition.isDualTableReferenceMatch()) {
            if (condition.tableLeft().equals(table)) {
                this.addIsNotUnknownOnConditionIfApplicable(condition.argNameLeft(), expressionCandidates);
            } else if (condition.tableRight().equals(table)) {
                this.addIsNotUnknownOnConditionIfApplicable(condition.argNameRight(), expressionCandidates);
            }
        } else if (condition.tableLeft().equals(table)) {
            if (alias.getPositiveReferenceCount() > 0 && alias.getNegativeReferenceCount() > 0) {
                this.addIsNotUnknownOnConditionIfApplicable(condition.argNameLeft(), expressionCandidates);
            }
            if (alias.getNegativeReferenceCount() > 0) {
                expressionCandidates.add(NegationExpression.of((CoreExpression)alias.getExpression(), (boolean)true));
            } else {
                expressionCandidates.add(alias.getExpression());
            }
        }
    }

    private void addIsNotUnknownOnConditionIfApplicable(String argName, Set<CoreExpression> expressionCandidates) {
        if (!this.dataBinding().dataTableConfig().isAlwaysKnown(argName)) {
            expressionCandidates.add(MatchExpression.isNotUnknown((String)argName));
        }
    }

    protected List<CoreExpression> filterApplicableOnConditionExpressions(Set<CoreExpression> expressionCandidates) {
        ArrayList<CoreExpression> filterExpressions = new ArrayList<CoreExpression>();
        block6: for (CoreExpression candidate : expressionCandidates) {
            Objects.requireNonNull(candidate);
            int n = 0;
            block7: while (true) {
                CoreExpression coreExpression;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MatchExpression.class, NegationExpression.class, SimpleExpression.class, CombinedExpression.class}, (CoreExpression)coreExpression, n)) {
                    case 0: {
                        MatchExpression match = (MatchExpression)coreExpression;
                        if (match.operator() != MatchOperator.IS_UNKNOWN || !expressionCandidates.contains(MatchExpression.isNotUnknown((String)match.argName()))) {
                            n = 1;
                            continue block7;
                        }
                        return Collections.emptyList();
                    }
                    case 1: {
                        NegationExpression neg = (NegationExpression)coreExpression;
                        if (neg.operator() != MatchOperator.IS_UNKNOWN) {
                            n = 2;
                            continue block7;
                        }
                        filterExpressions.add(candidate);
                        continue block6;
                    }
                    case 2: {
                        SimpleExpression simple = (SimpleExpression)coreExpression;
                        if (expressionCandidates.contains(MatchExpression.isNotUnknown((String)simple.argName()))) {
                            n = 3;
                            continue block7;
                        }
                        filterExpressions.add(candidate);
                        continue block6;
                    }
                    case 3: {
                        CombinedExpression cmb = (CombinedExpression)coreExpression;
                        if (expressionCandidates.contains(MatchExpression.isNotUnknown((String)((SimpleExpression)cmb.members().get(0)).argName()))) {
                            n = 4;
                            continue block7;
                        }
                        filterExpressions.add(candidate);
                        continue block6;
                    }
                }
                break;
            }
        }
        return filterExpressions;
    }

    protected void appendJoin(StringBuilder sb, String tableOrAliasName, String refIdColumnName, List<CoreExpression> onRestrictions) {
        FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)this.getNormalizedDepth(), (boolean)true);
        this.augmentationListener().handleAppendJoinType(sb, this.getProcessContext(), this.aliasHelper().getStartSelectionName(), tableOrAliasName, this.detectJoinType(tableOrAliasName, onRestrictions));
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{tableOrAliasName});
        FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 1), (boolean)true);
        this.augmentationListener().handleBeforeOnClause(sb, this.getProcessContext(), this.aliasHelper().getStartSelectionName(), tableOrAliasName);
        sb.append("ON");
        FormatUtils.space((StringBuilder)sb);
        this.augmentationListener().handleBeforeOnConditions(sb, this.getProcessContext(), this.aliasHelper().getStartSelectionName(), tableOrAliasName);
        sb.append(tableOrAliasName);
        sb.append(".");
        sb.append(refIdColumnName);
        FormatUtils.appendSpaced((StringBuilder)sb, (String[])new String[]{"="});
        sb.append(this.aliasHelper().getStartSelectionName());
        sb.append(".");
        sb.append(this.getMainIdColumnName());
        this.appendFurtherJoinOnRestrictions(sb, tableOrAliasName, onRestrictions);
        this.augmentationListener().handleAfterOnConditions(sb, this.getProcessContext(), this.aliasHelper().getStartSelectionName(), tableOrAliasName);
    }

    protected void appendFurtherJoinOnRestrictions(StringBuilder sb, String tableOrAliasName, List<CoreExpression> onRestrictions) {
        if (this.getMainTable() != null && !this.getMainTable().tableFilters().isEmpty()) {
            List<ColumnCondition> mainTableFilterConditions = this.getMainTable().tableFilters().stream().map(filterColumn -> MatchCondition.createFilterColumnCondition(ColumnConditionType.FILTER_LEFT, filterColumn, this.getProcessContext())).toList();
            this.appendFilterColumnConditions(sb, this.aliasHelper().getStartSelectionName(), mainTableFilterConditions, true);
        }
        if (onRestrictions.isEmpty()) {
            this.appendTargetTableConditions(sb, tableOrAliasName);
        } else {
            FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 1), (boolean)true);
            sb.append("AND");
            FormatUtils.space((StringBuilder)sb);
            if (onRestrictions.size() > 1) {
                sb.append("(");
                FormatUtils.space((StringBuilder)sb);
            }
            for (int idx = 0; idx < onRestrictions.size(); ++idx) {
                if (idx > 0) {
                    FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 2), (boolean)true);
                    sb.append("OR");
                    FormatUtils.space((StringBuilder)sb);
                }
                this.appendToAliasConditionClause(sb, this.conditionFactory().createMatchCondition(onRestrictions.get(idx)), true);
            }
            if (onRestrictions.size() > 1) {
                FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)this.style(), (int)(this.getNormalizedDepth() + 1), (boolean)true);
                sb.append(")");
            }
        }
    }

    private void appendTargetTableConditions(StringBuilder sb, String tableOrAliasName) {
        Optional<TableMetaInfo> targetTableOpt = this.dataBinding().dataTableConfig().allTableMetaInfos().stream().filter(tmi -> tmi.tableName().equals(tableOrAliasName)).findFirst();
        if (targetTableOpt.isPresent() && !targetTableOpt.get().tableFilters().isEmpty()) {
            List<ColumnCondition> targetTableFilterConditions = targetTableOpt.get().tableFilters().stream().map(filterColumn -> MatchCondition.createFilterColumnCondition(ColumnConditionType.FILTER_RIGHT, filterColumn, this.getProcessContext())).toList();
            this.appendFilterColumnConditions(sb, tableOrAliasName, targetTableFilterConditions, true);
        }
    }

    protected List<ExpressionAlias> collectFurtherRequiredAliases() {
        return this.aliasHelper().getOrderedAliasList().stream().filter(alias -> !alias.equals(this.aliasHelper().getPrimaryAlias())).filter(this.aliasesInWhereClause()::contains).toList();
    }

    protected void appendAliasJoinsIfRequired(StringBuilder sb) {
        if (ConversionHint.NO_JOINS_REQUIRED.check(this.flags())) {
            return;
        }
        ArrayList<String> joinElements = new ArrayList<String>();
        this.tablesInWhereClause().stream().sorted(Comparator.comparing(TableMetaInfo::tableName)).map(TableMetaInfo::tableName).filter(tableName -> !tableName.equals(this.aliasHelper().getStartSelectionName())).forEach(tableName -> this.addTableJoinElement((String)tableName, (List<String>)joinElements));
        if (!this.aliasesInWhereClause().isEmpty()) {
            StringBuilder sbJoin = new StringBuilder();
            for (ExpressionAlias alias : this.collectFurtherRequiredAliases()) {
                this.appendJoin(sbJoin, alias.getName(), this.getIdColumnName(), Collections.emptyList());
                joinElements.add(sbJoin.toString());
                sbJoin.setLength(0);
            }
        }
        Collections.sort(joinElements);
        for (String joinElement : joinElements) {
            if (!this.style().isMultiLine()) {
                FormatUtils.space((StringBuilder)sb);
            }
            sb.append(joinElement);
            FormatUtils.stripTrailingWhitespace((StringBuilder)sb);
        }
    }

    private void addTableJoinElement(String tableName, List<String> joinElements) {
        StringBuilder sbJoin = new StringBuilder();
        TableMetaInfo table = this.dataBinding().dataTableConfig().lookupTableMetaInfoByTableName(tableName);
        this.appendJoin(sbJoin, tableName, table.idColumnName(), this.findOnRestrictions(table));
        joinElements.add(sbJoin.toString());
    }

    protected void appendGlobalWhereCondition(StringBuilder sb) {
        String whereCondition = this.whereClause().toString().trim();
        if (this.getMainTable() != null && !this.getMainTable().tableFilters().isEmpty() && !this.tablesInWhereClause().contains(this.getMainTable())) {
            StringBuilder extendedWhere = new StringBuilder();
            extendedWhere.append("(");
            FormatUtils.appendSpaced((StringBuilder)extendedWhere, (String[])new String[]{whereCondition});
            extendedWhere.append(")");
            List<ColumnCondition> tableFilterConditions = this.getMainTable().tableFilters().stream().map(filterColumn -> MatchCondition.createFilterColumnCondition(ColumnConditionType.FILTER_LEFT, filterColumn, this.getProcessContext())).toList();
            this.appendFilterColumnConditions(extendedWhere, this.aliasHelper().getStartSelectionName(), tableFilterConditions, true);
            whereCondition = extendedWhere.toString().trim();
        }
        sb.append(whereCondition);
    }
}

