/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.CombinedExpressionType;
import de.calamanari.adl.irl.CombinedExpression;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.irl.NegationExpression;
import de.calamanari.adl.irl.SimpleExpression;
import de.calamanari.adl.sql.cnv.MatchCondition;
import de.calamanari.adl.sql.cnv.MatchConditionFactory;
import de.calamanari.adl.sql.cnv.SqlConversionProcessContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefaultMatchConditionFactory
implements MatchConditionFactory {
    private final SqlConversionProcessContext ctx;
    private final Map<CoreExpression, MatchCondition> cache = new HashMap<CoreExpression, MatchCondition>();

    public DefaultMatchConditionFactory(SqlConversionProcessContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public MatchCondition createSimpleCondition(SimpleExpression expression) {
        return this.cache.computeIfAbsent((CoreExpression)expression, coreExpression -> MatchCondition.createSimpleCondition(expression, this.ctx));
    }

    @Override
    public MatchCondition createInClauseCondition(List<SimpleExpression> expressions) {
        if (expressions == null || expressions.isEmpty() || expressions.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Argument expressions must not be null or empty, given: " + String.valueOf(expressions));
        }
        CombinedExpressionType combiType = expressions.get(0) instanceof NegationExpression ? CombinedExpressionType.AND : CombinedExpressionType.OR;
        CoreExpression keyExpression = CombinedExpression.of(new ArrayList<SimpleExpression>(expressions), (CombinedExpressionType)combiType);
        return this.cache.computeIfAbsent(keyExpression, coreExpression -> MatchCondition.createInClauseCondition(expressions, this.ctx));
    }
}

