/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.CombinedExpressionType;
import de.calamanari.adl.Flag;
import de.calamanari.adl.ProcessContext;
import de.calamanari.adl.TimeOut;
import de.calamanari.adl.cnv.tps.AdlType;
import de.calamanari.adl.irl.CombinedExpression;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.irl.MatchExpression;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.irl.NegationExpression;
import de.calamanari.adl.irl.SimpleExpression;
import de.calamanari.adl.irl.biceps.EncodedExpressionTree;
import de.calamanari.adl.irl.biceps.ImplicationResolver;
import de.calamanari.adl.irl.biceps.MemberUtils;
import de.calamanari.adl.irl.biceps.NodeType;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.cnv.ConversionHint;
import de.calamanari.adl.sql.cnv.CoreExpressionStats;
import de.calamanari.adl.sql.cnv.MatchCondition;
import de.calamanari.adl.sql.config.DataBinding;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CoreExpressionSqlHelper {
    protected final CoreExpression rootExpression;
    protected final int rootNode;
    protected final EncodedExpressionTree tree;
    protected final TimeOut timeout;
    protected final CoreExpressionStats stats;
    protected final DataBinding dataBinding;
    protected final ProcessContext processContext;
    protected final Comparator<CoreExpression> complexityComparator = Comparator.comparing(this::complexityOf);

    public CoreExpressionSqlHelper(CoreExpression rootExpression, TimeOut timeout, DataBinding dataBinding, ProcessContext processContext) {
        this.rootExpression = rootExpression;
        this.tree = EncodedExpressionTree.fromCoreExpression((CoreExpression)rootExpression);
        this.rootNode = this.tree.getRootNode();
        this.timeout = timeout == null ? TimeOut.createDefaultTimeOut((String)ImplicationResolver.class.getSimpleName()) : timeout;
        CoreExpressionStats expressionStats = CoreExpressionStats.from(rootExpression, dataBinding, processContext);
        processContext.getGlobalFlags().addAll(expressionStats.hints());
        this.stats = expressionStats;
        this.dataBinding = dataBinding;
        this.processContext = new MinimalProcessContext(processContext.getGlobalVariables(), processContext.getGlobalFlags());
    }

    private int getNode(CoreExpression expression) {
        return this.tree.createNode(expression);
    }

    private Map<Integer, CoreExpression> getSortedNodeMap(List<CoreExpression> expressions) {
        TreeMap<Integer, CoreExpression> res = new TreeMap<Integer, CoreExpression>();
        for (int i = 0; i < expressions.size(); ++i) {
            CoreExpression candidate = expressions.get(i);
            int node = this.getNode(candidate);
            res.putIfAbsent(node, candidate);
        }
        return res;
    }

    public List<CoreExpression> findMinimumRequiredOrCombination(List<CoreExpression> candidates, int limit) {
        if (limit <= 0 || limit > candidates.size()) {
            limit = candidates.size();
        }
        List<CoreExpression> res = Collections.emptyList();
        if (limit > 0) {
            int[] match = MemberUtils.EMPTY_MEMBERS;
            Map<Integer, CoreExpression> nodeMap = this.getSortedNodeMap(candidates);
            int[] candidateNodes = nodeMap.keySet().stream().mapToInt(i -> i).toArray();
            for (int numberOfElements = 1; numberOfElements <= limit && match == MemberUtils.EMPTY_MEMBERS; ++numberOfElements) {
                match = this.findRequiredOrCombination(candidateNodes, 0, MemberUtils.EMPTY_MEMBERS, numberOfElements);
            }
            this.tree.getMemberArrayRegistry().triggerHousekeeping(this.rootNode);
            res = new ArrayList<CoreExpression>(match.length);
            for (int idx = 0; idx < match.length; ++idx) {
                res.add(nodeMap.get(match[idx]));
            }
        }
        return res;
    }

    private int[] findRequiredOrCombination(int[] candidates, int currentIdx, int[] currentCombination, int numberOfElements) {
        int[] match = MemberUtils.EMPTY_MEMBERS;
        for (int idx = currentIdx; match.length == 0 && idx < candidates.length; ++idx) {
            this.timeout.assertHaveTime();
            int[] newCombination = this.combine(currentCombination, candidates[idx]);
            if (newCombination.length == numberOfElements && this.checkLeftSupersetOfRight(this.tree.createNode(NodeType.OR, newCombination), this.rootNode)) {
                match = newCombination;
                continue;
            }
            if (newCombination.length >= numberOfElements) continue;
            match = this.findRequiredOrCombination(candidates, idx + 1, newCombination, numberOfElements);
        }
        return match;
    }

    private int[] combine(int[] currentCombination, int candidate) {
        int[] res = Arrays.copyOf(currentCombination, currentCombination.length + 1);
        res[res.length - 1] = candidate;
        return res;
    }

    public boolean isSupersetOfRootExpression(CoreExpression expression) {
        return this.checkLeftSupersetOfRight(expression, this.rootExpression);
    }

    public boolean checkLeftSupersetOfRight(CoreExpression left, CoreExpression right) {
        return this.checkLeftSupersetOfRight(this.getNode(left), this.getNode(right));
    }

    private boolean checkLeftSupersetOfRight(int leftNode, int rightNode) {
        this.timeout.assertHaveTime();
        return this.tree.getLogicHelper().leftImpliesRight(rightNode, leftNode);
    }

    public boolean groupInClauses(CombinedExpression expression, List<List<SimpleExpression>> groups, List<CoreExpression> remaining) {
        return this.performGrouping(expression.childExpressions(), groups, remaining, expression.combiType() == CombinedExpressionType.AND);
    }

    private boolean isDateAlignmentRequired(SimpleExpression candidate) {
        AdlType type = this.dataBinding.dataTableConfig().typeOf(candidate.argName());
        AdlSqlType columnType = this.dataBinding.dataTableConfig().lookupColumn(candidate.argName(), this.processContext).columnType();
        return MatchCondition.shouldAlignDate(type, columnType, this.processContext);
    }

    private void filterInGroupingCandidates(List<CoreExpression> candidates, List<SimpleExpression> confirmed, List<CoreExpression> remaining, boolean filterNegations) {
        for (CoreExpression candidate : candidates) {
            SimpleExpression simple;
            if (candidate instanceof SimpleExpression && (simple = (SimpleExpression)candidate).operator() == MatchOperator.EQUALS && simple.referencedArgName() == null && (filterNegations && candidate instanceof NegationExpression || !filterNegations && candidate instanceof MatchExpression) && !this.isDateAlignmentRequired(simple)) {
                confirmed.add(simple);
                continue;
            }
            remaining.add(candidate);
        }
    }

    private void performGrouping(List<SimpleExpression> candidates, List<List<SimpleExpression>> groups, List<CoreExpression> remaining) {
        ArrayList<SimpleExpression> currentGroup = new ArrayList<SimpleExpression>();
        ArrayList<SimpleExpression> consumed = new ArrayList<SimpleExpression>();
        for (int idxLeft = 0; idxLeft < candidates.size(); ++idxLeft) {
            SimpleExpression left = candidates.get(idxLeft);
            if (consumed.contains(left)) continue;
            currentGroup.add(left);
            for (int idxRight = idxLeft + 1; idxRight < candidates.size(); ++idxRight) {
                SimpleExpression right = candidates.get(idxRight);
                if (consumed.contains(right) || !right.argName().equals(left.argName())) continue;
                currentGroup.add(right);
                consumed.add(right);
            }
            if (currentGroup.size() > 1) {
                groups.add(currentGroup);
            } else {
                remaining.add((CoreExpression)left);
            }
            currentGroup = new ArrayList();
        }
    }

    private boolean performGrouping(List<CoreExpression> members, List<List<SimpleExpression>> groups, List<CoreExpression> remaining, boolean filterNegations) {
        ArrayList<SimpleExpression> candidates = new ArrayList<SimpleExpression>();
        this.filterInGroupingCandidates(members, candidates, remaining, filterNegations);
        if (candidates.size() > 1) {
            this.performGrouping(candidates, groups, remaining);
        } else {
            remaining.addAll(candidates);
        }
        return !groups.isEmpty();
    }

    public CoreExpressionStats getStats() {
        return this.stats;
    }

    public boolean isExtraExistenceMatchRequired(MatchCondition condition) {
        return !ConversionHint.SIMPLE_CONDITION.check(this.processContext.getGlobalFlags()) && condition.isNegation() && condition.operator() != MatchOperator.IS_UNKNOWN;
    }

    public boolean isMultiRowSensitiveMatch(MatchCondition condition) {
        if (!condition.isNegation() && !condition.isReferenceMatch()) {
            return this.stats.isMultiRowSensitive(condition.argNameLeft());
        }
        if (!condition.isNegation()) {
            return condition.tableLeft().equals(condition.tableRight());
        }
        return this.stats.isMultiRowSensitive(condition.argNameLeft()) || condition.argNameRight() != null && this.stats.isMultiRowSensitive(condition.argNameRight()) || condition.isNegation() && !condition.tableLeft().tableNature().isIdUnique() || condition.isNegation() && condition.isReferenceMatch() && !condition.tableRight().tableNature().isIdUnique();
    }

    public boolean isEligibleForBaseQuery(CoreExpression expression) {
        CoreExpression coreExpression = expression;
        Objects.requireNonNull(coreExpression);
        CoreExpression coreExpression2 = coreExpression;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MatchExpression.class, NegationExpression.class, CombinedExpression.class}, (CoreExpression)coreExpression2, n)) {
                case 0: {
                    MatchExpression match = (MatchExpression)coreExpression2;
                    return match.operator() != MatchOperator.IS_UNKNOWN || this.isNullQueryingAllowed(match.argName());
                }
                case 1: {
                    return true;
                }
                case 2: {
                    if (CoreExpressionSqlHelper.isSubNested(expression)) {
                        n = 3;
                        continue block5;
                    }
                    return true;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected expression type to base query eligibility, given: " + String.valueOf(expression));
    }

    public static boolean isSubNested(CoreExpression expression) {
        if (expression instanceof CombinedExpression) {
            CombinedExpression cmb = (CombinedExpression)expression;
            return cmb.members().stream().anyMatch(CombinedExpression.class::isInstance);
        }
        return false;
    }

    public boolean isNullQueryingAllowed(String argName) {
        return !this.stats.isMultiRowSensitive(argName) && (this.dataBinding.dataTableConfig().numberOfTables() == 1 || this.dataBinding.dataTableConfig().lookupTableMetaInfo(argName, this.processContext).tableNature().containsAllIds());
    }

    private double computeDbPenaltyFactor(MatchExpression expression) {
        double res = 1.0;
        if (expression.referencedArgName() != null) {
            res = this.stats.isMultiRowSensitive(expression.argName()) && this.stats.isMultiRowSensitive(expression.referencedArgName()) ? (res *= 19.0) : (this.stats.isMultiRowSensitive(expression.argName()) || this.stats.isMultiRowSensitive(expression.referencedArgName()) ? (res *= 11.0) : (res *= 2.0));
        } else if (this.stats.isMultiRowSensitive(expression.argName())) {
            res *= 7.0;
        }
        return res;
    }

    public double complexityOf(CoreExpression expression) {
        CoreExpression coreExpression = expression;
        Objects.requireNonNull(coreExpression);
        CoreExpression coreExpression2 = coreExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MatchExpression.class, NegationExpression.class, CombinedExpression.class}, (CoreExpression)coreExpression2, n)) {
            case 0: {
                MatchExpression match = (MatchExpression)coreExpression2;
                switch (match.operator()) {
                    case LESS_THAN: 
                    case GREATER_THAN: {
                        return 1.2 * this.computeDbPenaltyFactor(match);
                    }
                    case CONTAINS: {
                        return 1.8 * this.computeDbPenaltyFactor(match);
                    }
                }
                return 1.0 * this.computeDbPenaltyFactor(match);
            }
            case 1: {
                NegationExpression neg = (NegationExpression)coreExpression2;
                return 1.5 * this.complexityOf((CoreExpression)neg.delegate());
            }
            case 2: {
                CombinedExpression comb = (CombinedExpression)coreExpression2;
                if (comb.combiType() == CombinedExpressionType.AND) {
                    return comb.members().stream().map(this::complexityOf).collect(Collectors.summingDouble(d -> d));
                }
                return comb.members().stream().map(e -> this.complexityOf((CoreExpression)e) * 1.1).collect(Collectors.summingDouble(d -> d));
            }
        }
        return 1.0;
    }

    public List<CoreExpression> consolidateAliasGroupExpressions(List<CoreExpression> members) {
        int sizeBefore = 0;
        do {
            sizeBefore = members.size();
        } while ((members = this.consolidateUnionGroupMembersInternal(members)).size() < sizeBefore);
        return members;
    }

    private List<CoreExpression> consolidateUnionGroupMembersInternal(List<CoreExpression> members) {
        ArrayList<CoreExpression> candidates = new ArrayList<CoreExpression>(members);
        ArrayList<CoreExpression> res = new ArrayList<CoreExpression>(members.size());
        for (int idxLeft = 0; idxLeft < candidates.size(); ++idxLeft) {
            CoreExpression left = (CoreExpression)candidates.get(idxLeft);
            boolean merged = false;
            for (int idxRight = idxLeft + 1; idxRight < candidates.size(); ++idxRight) {
                CoreExpression right = (CoreExpression)candidates.get(idxRight);
                CoreExpression updatedMember = this.tryMergeForUnion(left, right);
                if (updatedMember == null) continue;
                candidates.set(idxRight, updatedMember);
                merged = true;
                break;
            }
            if (merged) continue;
            res.add(left);
        }
        if (res.size() < members.size()) {
            return res;
        }
        return members;
    }

    private CoreExpression tryMergeForUnion(CoreExpression left, CoreExpression right) {
        if (left.equals((Object)right)) {
            return left;
        }
        if (left instanceof CombinedExpression) {
            CombinedExpression cmbLeft = (CombinedExpression)left;
            if (right instanceof CombinedExpression) {
                CombinedExpression cmbRight = (CombinedExpression)right;
                return this.tryMergeInClauses(cmbLeft, cmbRight);
            }
        }
        if (left instanceof CombinedExpression) {
            CombinedExpression cmbLeft = (CombinedExpression)left;
            if (right instanceof SimpleExpression) {
                SimpleExpression simpleRight = (SimpleExpression)right;
                return this.tryMergeInOrNotInClauseWithSimple(cmbLeft, simpleRight);
            }
        }
        if (left instanceof SimpleExpression) {
            SimpleExpression simpleLeft = (SimpleExpression)left;
            if (right instanceof CombinedExpression) {
                CombinedExpression cmbRight = (CombinedExpression)right;
                return this.tryMergeInOrNotInClauseWithSimple(cmbRight, simpleLeft);
            }
        }
        if (left instanceof MatchExpression) {
            MatchExpression matchLeft = (MatchExpression)left;
            if (right instanceof MatchExpression) {
                MatchExpression matchRight = (MatchExpression)right;
                return this.tryMergeMatchExpressions(matchLeft, matchRight);
            }
        }
        return null;
    }

    private CoreExpression tryMergeMatchExpressions(MatchExpression left, MatchExpression right) {
        if (left.argName().equals(right.argName()) && left.operator() == MatchOperator.EQUALS && right.operator() == MatchOperator.EQUALS && left.referencedArgName() == null && right.referencedArgName() == null && !this.isDateAlignmentRequired((SimpleExpression)left) && !this.isDateAlignmentRequired((SimpleExpression)right)) {
            return CombinedExpression.orOf(Arrays.asList(left, right));
        }
        return null;
    }

    private CoreExpression tryMergeInOrNotInClauseWithSimple(CombinedExpression combined, SimpleExpression simple) {
        if (combined.members().contains(simple)) {
            if (combined.combiType() == CombinedExpressionType.AND) {
                return simple;
            }
            return combined;
        }
        if (combined.combiType() == CombinedExpressionType.OR && simple instanceof MatchExpression) {
            MatchExpression member;
            MatchExpression match = (MatchExpression)simple;
            Object e = combined.members().get(0);
            if (e instanceof MatchExpression && (member = (MatchExpression)e).referencedArgName() == null && member.argName().equals(match.argName()) && match.operator() == MatchOperator.EQUALS && !this.isDateAlignmentRequired(simple)) {
                ArrayList<SimpleExpression> updatedMembers = new ArrayList<SimpleExpression>(combined.members());
                updatedMembers.add(simple);
                return CombinedExpression.orOf(updatedMembers);
            }
        }
        return null;
    }

    private CoreExpression tryMergeInClauses(CombinedExpression left, CombinedExpression right) {
        Object e;
        if (left.combiType() == CombinedExpressionType.OR && right.combiType() == CombinedExpressionType.OR && (e = left.members().get(0)) instanceof MatchExpression) {
            MatchExpression memberLeft = (MatchExpression)e;
            e = right.members().get(0);
            if (e instanceof MatchExpression) {
                MatchExpression memberRight = (MatchExpression)e;
                if (memberLeft.argName().equals(memberRight.argName()) && memberLeft.operator() == MatchOperator.EQUALS && memberRight.operator() == MatchOperator.EQUALS) {
                    ArrayList updatedMembers = new ArrayList(left.members());
                    updatedMembers.addAll(right.members());
                    return CombinedExpression.orOf(updatedMembers);
                }
            }
        }
        if (left.combiType() == CombinedExpressionType.AND && right.combiType() == CombinedExpressionType.AND) {
            List membersLeft = left.members();
            List membersRight = right.members();
            if (membersLeft.size() > membersRight.size() && membersLeft.containsAll(membersRight)) {
                return right;
            }
            if (membersLeft.size() < membersRight.size() && membersRight.containsAll(membersLeft)) {
                return left;
            }
        }
        return null;
    }

    public void sortByComplexityDescending(List<CoreExpression> expressions) {
        Collections.sort(expressions, this.complexityComparator.reversed().thenComparing(Function.identity()));
    }

    public boolean isSimpleExpressionOnPrimaryTable(CoreExpression expression) {
        SimpleExpression simple;
        return expression instanceof SimpleExpression && this.isPrimaryTableInvolved(simple = (SimpleExpression)expression);
    }

    public boolean isPrimaryTableInvolved(SimpleExpression expression) {
        String primaryTableName = this.dataBinding.dataTableConfig().primaryTable();
        return primaryTableName != null && (this.dataBinding.dataTableConfig().lookupTableMetaInfo(expression.argName(), this.processContext).tableName().equals(primaryTableName) || expression.referencedArgName() != null && this.dataBinding.dataTableConfig().lookupTableMetaInfo(expression.referencedArgName(), this.processContext).tableName().equals(primaryTableName));
    }

    protected record MinimalProcessContext(Map<String, Serializable> globalVariables, Set<Flag> globalFlags) implements ProcessContext
    {
        public Map<String, Serializable> getGlobalVariables() {
            return this.globalVariables;
        }

        public Set<Flag> getGlobalFlags() {
            return this.globalFlags;
        }
    }
}

