/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.cnv;

import de.calamanari.adl.CombinedExpressionType;
import de.calamanari.adl.irl.CombinedExpression;
import de.calamanari.adl.irl.CoreExpression;
import de.calamanari.adl.irl.MatchExpression;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.irl.NegationExpression;
import de.calamanari.adl.irl.SimpleExpression;
import de.calamanari.adl.sql.cnv.CoreExpressionSqlHelper;
import de.calamanari.adl.sql.cnv.ExpressionAlias;
import de.calamanari.adl.sql.cnv.MatchCondition;
import de.calamanari.adl.sql.cnv.MatchConditionFactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class AliasHelper {
    private int aliasId = 0;
    protected final Map<CoreExpression, ExpressionAlias> aliasMap = new HashMap<CoreExpression, ExpressionAlias>();
    private ExpressionAlias primaryAlias = null;
    private String startSelectionName = null;

    public String createAliasName() {
        ++this.aliasId;
        return String.format("sq__%03d", this.aliasId);
    }

    public ExpressionAlias getOrCreateAlias(CoreExpression expression) {
        CoreExpression coreExpression2 = expression;
        Objects.requireNonNull(coreExpression2);
        CoreExpression coreExpression3 = coreExpression2;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CombinedExpression.class, NegationExpression.class, CombinedExpression.class, MatchExpression.class}, (CoreExpression)coreExpression3, n)) {
                case 0: {
                    CombinedExpression cmb = (CombinedExpression)coreExpression3;
                    if (cmb.combiType() != CombinedExpressionType.AND) {
                        n = 1;
                        continue block6;
                    }
                    List orMembers = cmb.members().stream().map(NegationExpression.class::cast).map(NegationExpression::delegate).collect(Collectors.toCollection(ArrayList::new));
                    CoreExpression aliasInExpression = CombinedExpression.orOf((List)orMembers);
                    return this.aliasMap.computeIfAbsent(aliasInExpression, coreExpression -> new ExpressionAlias(this.createAliasName(), aliasInExpression));
                }
                case 1: {
                    NegationExpression neg = (NegationExpression)coreExpression3;
                    return this.aliasMap.computeIfAbsent((CoreExpression)neg.delegate(), coreExpression -> new ExpressionAlias(this.createAliasName(), (CoreExpression)neg.delegate()));
                }
                case 2: {
                    CombinedExpression cmb = (CombinedExpression)coreExpression3;
                    if (cmb.combiType() != CombinedExpressionType.OR) {
                        n = 3;
                        continue block6;
                    }
                    return this.aliasMap.computeIfAbsent((CoreExpression)cmb, coreExpression -> new ExpressionAlias(this.createAliasName(), (CoreExpression)cmb));
                }
                case 3: {
                    MatchExpression match = (MatchExpression)coreExpression3;
                    return this.aliasMap.computeIfAbsent((CoreExpression)match, coreExpression -> new ExpressionAlias(this.createAliasName(), (CoreExpression)match));
                }
            }
            break;
        }
        throw new IllegalArgumentException("Cannot create alias for expression (unsupported type), given: " + String.valueOf(expression));
    }

    public ExpressionAlias getPrimaryAlias() {
        return this.primaryAlias;
    }

    public void setPrimaryAlias(ExpressionAlias primaryAlias) {
        this.primaryAlias = primaryAlias;
    }

    public void determinePrimaryAlias(CoreExpressionSqlHelper expressionHelper, Set<ExpressionAlias> aliasesInWhereClause) {
        if (this.primaryAlias != null || expressionHelper.getStats().isSeparateBaseTableRequired()) {
            return;
        }
        List<ExpressionAlias> aliasList = this.getOrderedAliasList();
        List<ExpressionAlias> candidates = aliasList.stream().filter(alias -> this.isPrimaryAliasCandidate(expressionHelper, aliasesInWhereClause, (ExpressionAlias)alias)).toList();
        List<CoreExpression> requiredCandidates = this.filterRequiredAliasExpressions(expressionHelper, candidates);
        expressionHelper.sortByComplexityDescending(requiredCandidates);
        this.prioritizePrimaryTableIfPresent(expressionHelper, requiredCandidates);
        if (!requiredCandidates.isEmpty()) {
            CoreExpression selectedCandidate = requiredCandidates.get(0);
            for (ExpressionAlias alias2 : aliasList) {
                if (!alias2.getExpression().equals((Object)selectedCandidate)) continue;
                this.setPrimaryAlias(alias2);
            }
        }
    }

    private void prioritizePrimaryTableIfPresent(CoreExpressionSqlHelper expressionHelper, List<CoreExpression> candidates) {
        List<CoreExpression> candidatesOnPrimaryTable = candidates.stream().filter(expressionHelper::isSimpleExpressionOnPrimaryTable).toList();
        if (!candidatesOnPrimaryTable.isEmpty()) {
            candidates.clear();
            candidates.addAll(candidatesOnPrimaryTable);
        }
    }

    private boolean isPrimaryAliasCandidate(CoreExpressionSqlHelper expressionHelper, Set<ExpressionAlias> aliasesInWhereClause, ExpressionAlias alias) {
        if (!alias.requiresAllRowsOfTableQueryInUnion()) {
            MatchExpression match;
            CoreExpression expression = alias.getExpression();
            if (alias.getNegativeReferenceCount() > 0 && expression instanceof MatchExpression && (match = (MatchExpression)expression).operator() == MatchOperator.IS_UNKNOWN) {
                expression = NegationExpression.of((CoreExpression)expression, (boolean)true);
                return expressionHelper.isEligibleForBaseQuery(expression);
            }
            return (alias.getNegativeReferenceCount() == 0 || !aliasesInWhereClause.contains(alias)) && expressionHelper.isEligibleForBaseQuery(alias.getExpression());
        }
        return false;
    }

    private List<CoreExpression> filterRequiredAliasExpressions(CoreExpressionSqlHelper expressionHelper, List<ExpressionAlias> candidates) {
        ArrayList<CoreExpression> res = new ArrayList<CoreExpression>();
        for (ExpressionAlias candidate : candidates) {
            CoreExpression effectiveExpression = candidate.getExpression();
            if (effectiveExpression instanceof MatchExpression) {
                MatchExpression match = (MatchExpression)effectiveExpression;
                if (!candidate.isReferenceMatch() && candidate.getPositiveReferenceCount() == 0 && candidate.getNegativeReferenceCount() > 0) {
                    effectiveExpression = NegationExpression.of((CoreExpression)match, (boolean)true);
                }
            }
            if (!expressionHelper.isSupersetOfRootExpression(effectiveExpression)) continue;
            res.add(candidate.getExpression());
        }
        return res;
    }

    public List<ExpressionAlias> determineAdequateBaseQueryCombination(CoreExpressionSqlHelper expressionHelper, List<ExpressionAlias> aliases) {
        ExpressionAlias priorityAlias = this.getPrimaryAlias();
        if (priorityAlias != null) {
            return Collections.singletonList(priorityAlias);
        }
        HashMap eligibleAliasMap = new HashMap();
        aliases.stream().filter(alias -> !alias.requiresAllRowsOfTableQueryInUnion() && expressionHelper.isEligibleForBaseQuery(alias.getExpression())).forEach(alias -> eligibleAliasMap.put(alias.getExpression(), alias));
        List<CoreExpression> res = expressionHelper.findMinimumRequiredOrCombination(new ArrayList<CoreExpression>(eligibleAliasMap.keySet()), 5);
        return res.stream().map(eligibleAliasMap::get).toList();
    }

    public void determineStartSelectionName() {
        if (this.startSelectionName == null) {
            this.startSelectionName = this.primaryAlias != null ? this.primaryAlias.getName() : this.getBaseQueryAliasName();
        }
    }

    protected String getBaseQueryAliasName() {
        return "bq__start";
    }

    public String getStartSelectionName() {
        return this.startSelectionName;
    }

    public void setStartSelectionName(String startQueryAliasName) {
        this.startSelectionName = startQueryAliasName;
    }

    public List<ExpressionAlias> getOrderedAliasList() {
        ArrayList<ExpressionAlias> aliasList = new ArrayList<ExpressionAlias>(this.aliasMap.values());
        Collections.sort(aliasList);
        return aliasList;
    }

    public List<List<ExpressionAlias>> groupAliasesByTable(MatchConditionFactory conditionFactory, List<ExpressionAlias> aliases) {
        TreeMap<String, List> temp = new TreeMap<String, List>();
        for (ExpressionAlias alias : aliases) {
            MatchCondition condition = conditionFactory.createMatchCondition(alias.getExpression());
            String tableKey = condition.isDualTableReferenceMatch() ? AliasHelper.createTableKey(condition.tableLeft().tableName(), condition.tableRight().tableName()) : condition.tableLeft().tableName();
            List aliasGroup = temp.computeIfAbsent(tableKey, string -> new ArrayList());
            aliasGroup.add(alias);
        }
        return new ArrayList<List<ExpressionAlias>>(temp.values());
    }

    private static String createTableKey(String ... tableNames) {
        return Arrays.stream(tableNames).sorted().collect(Collectors.joining("::"));
    }

    public String determineReferenceMatchTableOrAliasRight(MatchCondition condition) {
        String res = null;
        res = condition.isSingleTableReferenceMatchInvolvingMultipleRows() ? "sq__self" : condition.tableRight().tableName();
        return res;
    }

    public String determineReferenceMatchDataColumnOrAliasRight(MatchCondition condition, boolean qualified) {
        Object res = null;
        res = condition.isSingleTableReferenceMatchInvolvingMultipleRows() ? "sq__self." + condition.dataColumnNameRight(false) : condition.dataColumnNameRight(qualified);
        return res;
    }

    public String determineReferenceMatchIdColumnOrAliasRight(MatchCondition condition) {
        Object res = null;
        res = condition.isSingleTableReferenceMatchInvolvingMultipleRows() ? "sq__self." + condition.idColumnNameRight(false) : condition.idColumnNameRight(true);
        return res;
    }

    public String determineReferenceMatchTableRight(MatchCondition condition) {
        Object res = condition.tableRight().tableName();
        if (condition.isSingleTableReferenceMatchInvolvingMultipleRows()) {
            res = (String)res + " sq__self";
        }
        return res;
    }

    public boolean isPrimaryAliasRunnningOnPrimaryTable(CoreExpressionSqlHelper expressionHelper) {
        SimpleExpression simple;
        CoreExpression coreExpression;
        return this.primaryAlias != null && (coreExpression = this.primaryAlias.getExpression()) instanceof SimpleExpression && expressionHelper.isPrimaryTableInvolved(simple = (SimpleExpression)coreExpression);
    }
}

