/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.FormatStyle;
import de.calamanari.adl.FormatUtils;

public class SqlFormatUtils {
    public static void appendSpacedIf(StringBuilder sb, boolean condition, String ... values) {
        if (condition) {
            FormatUtils.appendSpaced((StringBuilder)sb, (String[])values);
        }
    }

    public static boolean endsWithOpenBraceOrAllWhitespace(StringBuilder sb) {
        for (int idx = sb.length() - 1; idx > -1; --idx) {
            char ch = sb.charAt(idx);
            if (ch == '(') {
                return true;
            }
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public static void appendOrderBy(StringBuilder sb, String columnName, FormatStyle style, int level) {
        FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)style, (int)level, (boolean)true);
        if (style.isMultiLine()) {
            FormatUtils.appendIndentOrWhitespace((StringBuilder)sb, (FormatStyle)style, (int)level, (boolean)true);
        }
        sb.append("ORDER BY");
        FormatUtils.space((StringBuilder)sb);
        sb.append(columnName);
    }

    public static void appendQualifiedColumnName(StringBuilder sb, String alias, String columnName) {
        sb.append(alias);
        sb.append(".");
        sb.append(columnName);
    }

    public static void appendIsNullInversion(StringBuilder sb, boolean negation) {
        FormatUtils.space((StringBuilder)sb);
        if (negation) {
            sb.append("IS NULL");
        } else {
            sb.append("IS NOT NULL");
        }
    }

    private SqlFormatUtils() {
    }
}

