/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.cnv.tps.AdlDateUtils;
import de.calamanari.adl.cnv.tps.AdlFormattingException;
import de.calamanari.adl.cnv.tps.AdlType;
import de.calamanari.adl.cnv.tps.ArgMetaInfo;
import de.calamanari.adl.cnv.tps.DefaultAdlType;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.DefaultAdlSqlType;
import de.calamanari.adl.sql.DefaultQueryParameter;
import de.calamanari.adl.sql.QueryParameter;
import de.calamanari.adl.sql.QueryParameterCreator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultQueryParameterCreator
implements QueryParameterCreator {
    private static final long serialVersionUID = -1904380668225305221L;
    private static final DefaultQueryParameterCreator INSTANCE = new DefaultQueryParameterCreator();
    private static final AtomicInteger GLOBAL_ID_SEQUENCE = new AtomicInteger(1000);

    public static final DefaultQueryParameterCreator getInstance() {
        return INSTANCE;
    }

    private DefaultQueryParameterCreator() {
    }

    @Override
    public DefaultQueryParameter createParameter(String id, ArgMetaInfo argMetaInfo, String argValue, MatchOperator matchOperator, AdlSqlType adlSqlType) {
        if (id == null || argMetaInfo == null || matchOperator == null || adlSqlType == null) {
            throw new AdlFormattingException(String.format("Parameters id, argMetaInfo, matchOperator and adlSqlType must not be null, given: id=%s, argMetaInfo=%s, matchOperator=%s, adlSqlType=%s", id, argMetaInfo, matchOperator, adlSqlType), AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_4003_GENERAL_ERROR, (Object[])new Object[0]));
        }
        Context ctx = new Context(id, argMetaInfo, adlSqlType, matchOperator);
        this.assertTypesSupported(argValue, ctx);
        if (argValue == null) {
            return new DefaultQueryParameter(id, adlSqlType, null, matchOperator);
        }
        AdlType adlType = argMetaInfo.type().getBaseType();
        if (adlType instanceof DefaultAdlType) {
            DefaultAdlType defaultType = (DefaultAdlType)adlType;
            switch (defaultType) {
                case STRING: {
                    return this.createStringParameter(argValue, ctx);
                }
                case INTEGER: {
                    return this.createLongParameter(argValue, ctx);
                }
                case DECIMAL: {
                    return this.createDoubleParameter(argValue, ctx);
                }
                case BOOL: {
                    return this.createBooleanParameter(argValue, ctx);
                }
                case DATE: {
                    return this.createDateParameter(argValue, ctx);
                }
            }
        }
        throw new AdlFormattingException(String.format("Unsupported source argument type: %s (new DefaultAdlType introduced?)", argMetaInfo), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_4003_GENERAL_ERROR, (String)argMetaInfo.argName(), (Object[])new Object[0]));
    }

    @Override
    public boolean isTypeCombinationSupported(AdlType sourceType, AdlSqlType targetType) {
        AdlType adlType;
        if (!(sourceType instanceof AdlSqlType) && (adlType = sourceType.getBaseType()) instanceof DefaultAdlType) {
            DefaultAdlType inputType = (DefaultAdlType)adlType;
            adlType = targetType.getBaseType();
            if (adlType instanceof DefaultAdlSqlType) {
                DefaultAdlSqlType outputType = (DefaultAdlSqlType)adlType;
                switch (inputType) {
                    case STRING: {
                        return true;
                    }
                    case INTEGER: {
                        return true;
                    }
                    case DECIMAL: {
                        return outputType != DefaultAdlSqlType.SQL_BIT && outputType != DefaultAdlSqlType.SQL_BOOLEAN;
                    }
                    case BOOL: {
                        return outputType == DefaultAdlSqlType.SQL_BIGINT || outputType == DefaultAdlSqlType.SQL_INTEGER || outputType == DefaultAdlSqlType.SQL_SMALLINT || outputType == DefaultAdlSqlType.SQL_TINYINT || outputType == DefaultAdlSqlType.SQL_BOOLEAN || outputType == DefaultAdlSqlType.SQL_BIT || outputType == DefaultAdlSqlType.SQL_CHAR || outputType == DefaultAdlSqlType.SQL_LONGNVARCHAR || outputType == DefaultAdlSqlType.SQL_LONGVARCHAR || outputType == DefaultAdlSqlType.SQL_NCHAR || outputType == DefaultAdlSqlType.SQL_NVARCHAR || outputType == DefaultAdlSqlType.SQL_VARCHAR;
                    }
                    case DATE: {
                        return outputType == DefaultAdlSqlType.SQL_DATE || outputType == DefaultAdlSqlType.SQL_TIMESTAMP || outputType == DefaultAdlSqlType.SQL_INTEGER || outputType == DefaultAdlSqlType.SQL_BIGINT || outputType == DefaultAdlSqlType.SQL_CHAR || outputType == DefaultAdlSqlType.SQL_LONGNVARCHAR || outputType == DefaultAdlSqlType.SQL_LONGVARCHAR || outputType == DefaultAdlSqlType.SQL_NCHAR || outputType == DefaultAdlSqlType.SQL_NVARCHAR || outputType == DefaultAdlSqlType.SQL_VARCHAR || outputType == DefaultAdlSqlType.SQL_DECIMAL || outputType == DefaultAdlSqlType.SQL_DOUBLE || outputType == DefaultAdlSqlType.SQL_NUMERIC || outputType == DefaultAdlSqlType.SQL_REAL;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public QueryParameter createParameter(ArgMetaInfo argMetaInfo, String argValue, MatchOperator matchOperator, AdlSqlType adlSqlType) {
        return this.createParameter("P_" + GLOBAL_ID_SEQUENCE.incrementAndGet(), argMetaInfo, argValue, matchOperator, adlSqlType);
    }

    private void assertTypesSupported(String argValue, Context ctx) {
        if (!(ctx.argMetaInfo.type().getBaseType() instanceof DefaultAdlType)) {
            throw new AdlFormattingException(String.format("Unsupported type %s in logical data model. Make sure any custom type's getBaseType() method returns one of the DefaultAdlTypes, given: id=%s, argMetaInfo=%s", ctx.parameterId, ctx.argMetaInfo.type(), ctx.argMetaInfo), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_4002_CONFIG_ERROR, (String)ctx.argMetaInfo.argName(), (Object[])new Object[0]));
        }
        if (!(ctx.adlSqlType.getBaseType() instanceof DefaultAdlSqlType)) {
            throw new AdlFormattingException(String.format("Unsupported sql type request. Make sure any custom type's getBaseType() method returns one of the DefaultAdlSqlTypes, given: id=%s, adlSqlType=%s requested for argMetaInfo=%s", ctx.parameterId, ctx.adlSqlType, ctx.argMetaInfo), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_4002_CONFIG_ERROR, (String)ctx.argMetaInfo.argName(), (Object[])new Object[0]));
        }
        if (!this.isTypeCombinationSupported(ctx.argMetaInfo.type(), ctx.adlSqlType)) {
            throw DefaultQueryParameterCreator.createNotAlignableException(argValue, argValue, ctx);
        }
    }

    private DefaultQueryParameter createStringParameter(String argValue, Context ctx) {
        String formattedValue = ctx.argMetaInfo.type().getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        return this.createTargetParameter(argValue, formattedValue, ctx);
    }

    private DefaultQueryParameter createTargetParameter(String argValue, String formattedValue, Context ctx) {
        AdlSqlType adlSqlType = ctx.adlSqlType.getBaseType();
        if (adlSqlType instanceof DefaultAdlSqlType) {
            DefaultAdlSqlType baseType = (DefaultAdlSqlType)adlSqlType;
            switch (baseType) {
                case SQL_BOOLEAN: 
                case SQL_BIT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Boolean.valueOf(this.parseBoolean(argValue, ctx)), ctx.matchOperator);
                }
                case SQL_DATE: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, this.parseDate(argValue, ctx), ctx.matchOperator);
                }
                case SQL_DECIMAL: 
                case SQL_DOUBLE: 
                case SQL_REAL: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Double.valueOf(this.parseDouble(argValue, ctx)), ctx.matchOperator);
                }
                case SQL_NUMERIC: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, BigDecimal.valueOf(this.parseDouble(argValue, ctx)).setScale(7, RoundingMode.HALF_UP), ctx.matchOperator);
                }
                case SQL_FLOAT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Float.valueOf((float)this.parseDouble(argValue, ctx)), ctx.matchOperator);
                }
                case SQL_TIMESTAMP: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, new Timestamp(this.assertInRange(this.parseLongOrTimestamp(argValue, ctx), 0L, 253402300799000L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_BIGINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Long.valueOf(this.parseLongOrEpochSeconds(argValue, ctx)), ctx.matchOperator);
                }
                case SQL_INTEGER: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Integer.valueOf((int)this.assertInRange(this.parseLongOrEpochSeconds(argValue, ctx), -2147483647L, Integer.MAX_VALUE, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_SMALLINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Short.valueOf((short)this.assertInRange(this.parseLong(argValue, ctx), -32767L, 32767L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_TINYINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Byte.valueOf((byte)this.assertInRange(this.parseLong(argValue, ctx), 0L, 255L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_CHAR: 
                case SQL_LONGNVARCHAR: 
                case SQL_LONGVARCHAR: 
                case SQL_NCHAR: 
                case SQL_NVARCHAR: 
                case SQL_VARCHAR: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, (Serializable)((Object)argValue), ctx.matchOperator);
                }
            }
        }
        throw DefaultQueryParameterCreator.createNotAlignableException(argValue, formattedValue, ctx);
    }

    private DefaultQueryParameter createLongParameter(String argValue, Context ctx) {
        String formattedValue = ctx.argMetaInfo.type().getFormatter().format(argValue, argValue, ctx.matchOperator);
        try {
            long value = Long.parseLong(formattedValue);
            return this.createTargetParameter(value, false, formattedValue, ctx);
        }
        catch (NumberFormatException ex) {
            throw new AdlFormattingException(String.format("Unexpected formatting exception, %s is not of type long (error in formatter of argMetaInfo=%s with id=%s, argValue=%s, matchOperator=%s, adlSqlType=%s)", formattedValue, ctx.argMetaInfo, ctx.parameterId, argValue, ctx.matchOperator, ctx.adlSqlType), (Throwable)ex, AudlangMessage.argValueMsg((AudlangUserMessage)CommonErrors.ERR_2004_VALUE_FORMAT, (String)ctx.argMetaInfo.argName(), (String)argValue, (Object[])new Object[0]));
        }
    }

    private DefaultQueryParameter createDoubleParameter(String argValue, Context ctx) {
        String formattedValue = ctx.argMetaInfo.type().getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        try {
            double value = Double.parseDouble(formattedValue);
            return this.createTargetParameter(value, formattedValue, ctx);
        }
        catch (NumberFormatException ex) {
            throw new AdlFormattingException(String.format("Unexpected formatting exception, %s is not of type double (error in formatter of argMetaInfo=%s with id=%s, argValue=%s, matchOperator=%s, adlSqlType=%s)", formattedValue, ctx.argMetaInfo, ctx.parameterId, argValue, ctx.matchOperator, ctx.adlSqlType), (Throwable)ex, AudlangMessage.argValueMsg((AudlangUserMessage)CommonErrors.ERR_2004_VALUE_FORMAT, (String)ctx.argMetaInfo.argName(), (String)argValue, (Object[])new Object[0]));
        }
    }

    private DefaultQueryParameter createTargetParameter(double argValue, String formattedValue, Context ctx) {
        AdlSqlType adlSqlType = ctx.adlSqlType.getBaseType();
        if (adlSqlType instanceof DefaultAdlSqlType) {
            DefaultAdlSqlType baseType = (DefaultAdlSqlType)adlSqlType;
            switch (baseType) {
                case SQL_DATE: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, new Date((long)argValue), ctx.matchOperator);
                }
                case SQL_DECIMAL: 
                case SQL_DOUBLE: 
                case SQL_REAL: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Double.valueOf(argValue), ctx.matchOperator);
                }
                case SQL_NUMERIC: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, BigDecimal.valueOf(argValue).setScale(7, RoundingMode.HALF_UP), ctx.matchOperator);
                }
                case SQL_FLOAT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Float.valueOf((float)argValue), ctx.matchOperator);
                }
                case SQL_TIMESTAMP: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, new Timestamp(this.assertInRange((long)argValue, 0L, 253402300799000L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_BIGINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Long.valueOf((long)argValue), ctx.matchOperator);
                }
                case SQL_INTEGER: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Integer.valueOf((int)this.assertInRange((long)argValue, -2147483647L, Integer.MAX_VALUE, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_SMALLINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Short.valueOf((short)this.assertInRange((long)argValue, -32767L, 32767L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_TINYINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Byte.valueOf((byte)this.assertInRange((long)argValue, 0L, 255L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_CHAR: 
                case SQL_LONGNVARCHAR: 
                case SQL_LONGVARCHAR: 
                case SQL_NCHAR: 
                case SQL_NVARCHAR: 
                case SQL_VARCHAR: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, (Serializable)((Object)formattedValue), ctx.matchOperator);
                }
            }
        }
        throw DefaultQueryParameterCreator.createNotAlignableException(argValue, "" + argValue, ctx);
    }

    private DefaultQueryParameter createBooleanParameter(String argValue, Context ctx) {
        String formattedValue = ctx.argMetaInfo.type().getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        if ("0".equals(argValue)) {
            return this.createTargetParameter(false, formattedValue, ctx);
        }
        if ("1".equals(argValue)) {
            return this.createTargetParameter(true, formattedValue, ctx);
        }
        throw new AdlFormattingException(String.format("Unexpected formatting exception, %s is unknown, expected '0' or '1' (error in formatter of argMetaInfo=%s with id=%s, argValue=%s, matchOperator=%s, adlSqlType=%s)", formattedValue, ctx.argMetaInfo, ctx.parameterId, argValue, ctx.matchOperator, ctx.adlSqlType), AudlangMessage.argValueMsg((AudlangUserMessage)CommonErrors.ERR_2005_VALUE_FORMAT_BOOL, (String)ctx.argMetaInfo.argName(), (String)argValue, (Object[])new Object[0]));
    }

    private DefaultQueryParameter createTargetParameter(boolean argValue, String formattedValue, Context ctx) {
        AdlSqlType adlSqlType = ctx.adlSqlType.getBaseType();
        if (adlSqlType instanceof DefaultAdlSqlType) {
            DefaultAdlSqlType baseType = (DefaultAdlSqlType)adlSqlType;
            switch (baseType) {
                case SQL_BIGINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Long.valueOf(argValue ? 1L : 0L), ctx.matchOperator);
                }
                case SQL_INTEGER: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Integer.valueOf(argValue ? 1 : 0), ctx.matchOperator);
                }
                case SQL_SMALLINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Short.valueOf((short)(argValue ? 1 : 0)), ctx.matchOperator);
                }
                case SQL_TINYINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Byte.valueOf((byte)(argValue ? 1 : 0)), ctx.matchOperator);
                }
                case SQL_BOOLEAN: 
                case SQL_BIT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Boolean.valueOf(argValue), ctx.matchOperator);
                }
                case SQL_CHAR: 
                case SQL_LONGNVARCHAR: 
                case SQL_LONGVARCHAR: 
                case SQL_NCHAR: 
                case SQL_NVARCHAR: 
                case SQL_VARCHAR: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, (Serializable)((Object)formattedValue), ctx.matchOperator);
                }
            }
        }
        throw DefaultQueryParameterCreator.createNotAlignableException(argValue, "" + argValue, ctx);
    }

    private DefaultQueryParameter createDateParameter(String argValue, Context ctx) {
        String formattedValue = ctx.argMetaInfo.type().getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        long utcMillis = AdlDateUtils.tryParseUtcMillis((String)formattedValue);
        if (utcMillis >= 0L) {
            return this.createTargetParameter(utcMillis, true, formattedValue, ctx);
        }
        throw new AdlFormattingException(String.format("Unexpected formatting exception, %s is no valid date value (error in formatter of argMetaInfo=%s with id=%s, argValue=%s, matchOperator=%s, adlSqlType=%s)", formattedValue, ctx.argMetaInfo, ctx.parameterId, argValue, ctx.matchOperator, ctx.adlSqlType), AudlangMessage.argValueMsg((AudlangUserMessage)CommonErrors.ERR_2006_VALUE_FORMAT_DATE, (String)ctx.argMetaInfo.argName(), (String)argValue, (Object[])new Object[0]));
    }

    private DefaultQueryParameter createTargetParameter(long argValue, boolean assumeUtcMillis, String formattedValue, Context ctx) {
        AdlSqlType adlSqlType = ctx.adlSqlType.getBaseType();
        if (adlSqlType instanceof DefaultAdlSqlType) {
            DefaultAdlSqlType baseType = (DefaultAdlSqlType)adlSqlType;
            switch (baseType) {
                case SQL_BOOLEAN: 
                case SQL_BIT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Boolean.valueOf(this.assertInRange(argValue, 0L, 1L, formattedValue, ctx) == 1L), ctx.matchOperator);
                }
                case SQL_DATE: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, new Date(this.assertInRange(argValue, 0L, 253402300799000L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_DECIMAL: 
                case SQL_DOUBLE: 
                case SQL_REAL: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Double.valueOf(argValue), ctx.matchOperator);
                }
                case SQL_NUMERIC: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, BigDecimal.valueOf(argValue).setScale(7, RoundingMode.HALF_UP), ctx.matchOperator);
                }
                case SQL_FLOAT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Float.valueOf(argValue), ctx.matchOperator);
                }
                case SQL_TIMESTAMP: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, new Timestamp(this.assertInRange(argValue, 0L, 253402300799000L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_BIGINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Long.valueOf(DefaultQueryParameterCreator.toEpochSecondsIfRequired(argValue, assumeUtcMillis)), ctx.matchOperator);
                }
                case SQL_INTEGER: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Integer.valueOf((int)this.assertInRange(DefaultQueryParameterCreator.toEpochSecondsIfRequired(argValue, assumeUtcMillis), -2147483647L, Integer.MAX_VALUE, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_SMALLINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Short.valueOf((short)this.assertInRange(argValue, -32767L, 32767L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_TINYINT: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, Byte.valueOf((byte)this.assertInRange(argValue, 0L, 255L, formattedValue, ctx)), ctx.matchOperator);
                }
                case SQL_CHAR: 
                case SQL_LONGNVARCHAR: 
                case SQL_LONGVARCHAR: 
                case SQL_NCHAR: 
                case SQL_NVARCHAR: 
                case SQL_VARCHAR: {
                    return new DefaultQueryParameter(ctx.parameterId, ctx.adlSqlType, (Serializable)((Object)formattedValue), ctx.matchOperator);
                }
            }
        }
        throw DefaultQueryParameterCreator.createNotAlignableException(argValue, formattedValue, ctx);
    }

    private static long toEpochSecondsIfRequired(long millis, boolean required) {
        return required ? millis / 1000L : millis;
    }

    private long assertInRange(long value, long min, long max, String formattedValue, Context ctx) {
        if (value >= min && value <= max) {
            return value;
        }
        throw new AdlFormattingException(String.format("Unable to align the argument value to the target type (not within in expected range [%d..%d]), given: id=%s, argMetaInfo=%s, argValue=%s (%s), matchOperator=%s, adlSqlType=%s", min, max, ctx.parameterId, ctx.argMetaInfo, formattedValue, formattedValue, ctx.matchOperator, ctx.adlSqlType), AudlangMessage.argValueMsg((AudlangUserMessage)CommonErrors.ERR_2003_VALUE_RANGE, (String)ctx.argMetaInfo.argName(), (String)formattedValue, (Object[])new Object[0]));
    }

    private boolean parseBoolean(String argValue, Context ctx) {
        String formattedValue = DefaultAdlType.BOOL.getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        return "TRUE".equals(formattedValue);
    }

    private Date parseDate(String argValue, Context ctx) {
        DefaultAdlType.DATE.getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        return new Date(AdlDateUtils.tryParseUtcMillis((String)argValue));
    }

    private double parseDouble(String argValue, Context ctx) {
        String formattedValue = DefaultAdlType.DECIMAL.getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        return Double.parseDouble(formattedValue);
    }

    private long parseLong(String argValue, Context ctx) {
        String formattedValue = DefaultAdlType.INTEGER.getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        return Long.parseLong(formattedValue);
    }

    private long parseLongOrTimestamp(String argValue, Context ctx) {
        if (argValue != null && argValue.length() > 10) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                java.util.Date temp = sdf.parse(argValue);
                if (argValue.equals(sdf.format(temp))) {
                    return temp.getTime();
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this.parseLong(argValue, ctx);
    }

    private long parseLongOrEpochSeconds(String argValue, Context ctx) {
        String formattedValue = DefaultAdlType.INTEGER.getFormatter().format(ctx.argMetaInfo.argName(), argValue, ctx.matchOperator);
        long res = Long.parseLong(formattedValue);
        if (AdlDateUtils.tryParseUtcMillis((String)argValue) > -1L) {
            res /= 1000L;
        }
        return res;
    }

    private static AdlFormattingException createNotAlignableException(Object argValue, String formattedValue, Context ctx) {
        return new AdlFormattingException(String.format("Unable to align the argument value to the target type, given: id=%s, argMetaInfo=%s, argValue=%s (%s), matchOperator=%s, adlSqlType=%s", ctx.parameterId, ctx.argMetaInfo, formattedValue, argValue, ctx.matchOperator, ctx.adlSqlType), AudlangMessage.argValueMsg((AudlangUserMessage)CommonErrors.ERR_3001_TYPE_MISMATCH, (String)ctx.argMetaInfo.argName(), (String)formattedValue, (Object[])new Object[0]));
    }

    Object readResolve() {
        return INSTANCE;
    }

    public static void resetIdSequence() {
        GLOBAL_ID_SEQUENCE.set(1000);
    }

    private record Context(String parameterId, ArgMetaInfo argMetaInfo, AdlSqlType adlSqlType, MatchOperator matchOperator) {
    }
}

