/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.irl.MatchOperator;
import de.calamanari.adl.sql.AdlSqlType;
import de.calamanari.adl.sql.DefaultAdlSqlType;
import de.calamanari.adl.sql.QueryParameter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public record DefaultQueryParameter(String id, AdlSqlType adlSqlType, Serializable value, MatchOperator operator) implements QueryParameter
{
    public DefaultQueryParameter {
        DefaultQueryParameter.assertValidId(id, adlSqlType, value);
        if (adlSqlType == null || operator == null) {
            throw new IllegalArgumentException(String.format("The arguments adlSqlType and operator of the destination column must not be null, given: id=%s, adlSqlType=null, value=%s, operator=%s.", id, value, operator));
        }
        DefaultQueryParameter.assertTypesSupported(id, adlSqlType, value);
    }

    private static void assertTypesSupported(String id, AdlSqlType adlSqlType, Serializable value) {
        AdlSqlType adlSqlType2 = adlSqlType.getBaseType();
        if (adlSqlType2 instanceof DefaultAdlSqlType) {
            DefaultAdlSqlType baseType = (DefaultAdlSqlType)adlSqlType2;
            switch (baseType) {
                case SQL_BIGINT: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Long.class, value);
                    break;
                }
                case SQL_BIT: 
                case SQL_BOOLEAN: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Boolean.class, value);
                    break;
                }
                case SQL_CHAR: 
                case SQL_LONGNVARCHAR: 
                case SQL_LONGVARCHAR: 
                case SQL_NCHAR: 
                case SQL_NVARCHAR: 
                case SQL_VARCHAR: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, String.class, value);
                    break;
                }
                case SQL_DATE: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Date.class, value);
                    break;
                }
                case SQL_DECIMAL: 
                case SQL_DOUBLE: 
                case SQL_REAL: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Double.class, value);
                    break;
                }
                case SQL_FLOAT: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Float.class, value);
                    break;
                }
                case SQL_INTEGER: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Integer.class, value);
                    break;
                }
                case SQL_TINYINT: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Byte.class, value);
                    break;
                }
                case SQL_NUMERIC: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, BigDecimal.class, value);
                    break;
                }
                case SQL_SMALLINT: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Short.class, value);
                    break;
                }
                case SQL_TIMESTAMP: {
                    DefaultQueryParameter.assertTransferTypeSupported(id, adlSqlType, Timestamp.class, value);
                }
            }
            return;
        }
        throw new ConfigException(String.format("Unsupported AdlSqlType: %s (not implemented, yet)", adlSqlType), AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (Object[])new Object[0]));
    }

    private static void assertTransferTypeSupported(String id, AdlSqlType adlSqlType, Class<?> type, Object value) {
        if (value != null) {
            try {
                type.cast(value);
            }
            catch (ClassCastException classCastException) {
                throw new ConfigException(String.format("Transfer type mismatch: id=%s, adlSqlType=%s, expectedType=%s, incompatible value=%s", id, adlSqlType, type, value), AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_3001_TYPE_MISMATCH, (Object[])new Object[0]));
            }
        }
    }

    private static void assertValidId(String id, AdlSqlType adlSqlType, Serializable value) {
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException(String.format("The paramteer id must not be null or blank, given: id=%s, adlSqlType=%s, value=%s.", id, adlSqlType, value));
        }
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if ("${}".indexOf(ch) <= -1 && !Character.isWhitespace(ch)) continue;
            throw new IllegalArgumentException(String.format("The parameter id must not contain any whitespace, '$', '{' or '}', given: id=%s, adlSqlType=%s, value=%s.", id, adlSqlType, value));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.applyUnsafe(sb, 0);
        return sb.toString();
    }
}

