//@formatter:off
/*
 * QueryPreparationException
 * Copyright 2024 Karl Eilebrecht
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"):
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//@formatter:on

package de.calamanari.adl.sql;

import de.calamanari.adl.AdlException;

/**
 * Exception to be thrown on unexpected problems when setting up an sql-query.
 * 
 * @author <a href="mailto:Karl.Eilebrecht(a/t)calamanari.de">Karl Eilebrecht</a>
 */
public class QueryPreparationException extends AdlException {

    private static final long serialVersionUID = 3661161487844075302L;

    /**
     * @param message
     */
    public QueryPreparationException(String message) {
        super(message);
    }

    /**
     * @param cause
     */
    public QueryPreparationException(Throwable cause) {
        super(cause);
    }

    /**
     * @param message
     * @param cause
     */
    public QueryPreparationException(String message, Throwable cause) {
        super(message, cause);
    }

}
