/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.cnv.tps.ContainsNotSupportedException;
import de.calamanari.adl.sql.config.SqlContainsPolicy;

public enum DefaultSqlContainsPolicy implements SqlContainsPolicy
{
    MYSQL(s -> DefaultSqlContainsPolicy.removePatternCharacters(s, "%_"), (columnName, patternParameter) -> columnName + " LIKE CONCAT('%', " + patternParameter + ", '%')"),
    SQL92(s -> DefaultSqlContainsPolicy.removePatternCharacters(s, "%_"), (columnName, patternParameter) -> columnName + " LIKE '%' || " + patternParameter + " || '%'"),
    SQL_SERVER(s -> DefaultSqlContainsPolicy.removePatternCharacters(s, "%_["), (columnName, patternParameter) -> columnName + " LIKE '%' + " + patternParameter + " + '%'"),
    SQL_SERVER2(SqlContainsPolicy.PreparatorFunction.none(), (columnName, patternParameter) -> "CHARINDEX(" + patternParameter + ", " + columnName + ", 0) > 0"),
    UNSUPPORTED(SqlContainsPolicy.PreparatorFunction.none(), (columnName, patternParameter) -> {
        AudlangMessage userMessage = AudlangMessage.msg((AudlangUserMessage)CommonErrors.ERR_2200_CONTAINS_NOT_SUPPORTED, (Object[])new Object[0]);
        throw new ContainsNotSupportedException("Error: Underlying data store does not support translating CONTAINS conditions, column: " + columnName, userMessage);
    });

    private final SqlContainsPolicy.PreparatorFunction prepareSearchSnippetFunction;
    private final SqlContainsPolicy.CreatorFunction createInstructionFunction;

    private DefaultSqlContainsPolicy(SqlContainsPolicy.PreparatorFunction prepareSearchSnippetFunction, SqlContainsPolicy.CreatorFunction createInstructionFunction) {
        this.prepareSearchSnippetFunction = prepareSearchSnippetFunction;
        this.createInstructionFunction = createInstructionFunction;
    }

    private static String removePatternCharacters(String value, String patternCharacters) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            boolean illegal;
            char ch = value.charAt(i);
            boolean bl = illegal = patternCharacters.indexOf(ch) > -1;
            if (illegal && sb == null) {
                sb = new StringBuilder();
                sb.append(value.substring(0, i));
                continue;
            }
            if (illegal || sb == null) continue;
            sb.append(ch);
        }
        return sb != null ? sb.toString() : value;
    }

    @Override
    public String prepareSearchSnippet(String value) {
        return (String)this.prepareSearchSnippetFunction.apply(value);
    }

    @Override
    public String createInstruction(String columnName, String patternParameter) {
        return (String)this.createInstructionFunction.apply(columnName, patternParameter);
    }
}

