/*
 * Decompiled with CFR 0.152.
 */
package de.calamanari.adl.sql.config;

import de.calamanari.adl.AudlangMessage;
import de.calamanari.adl.AudlangUserMessage;
import de.calamanari.adl.CommonErrors;
import de.calamanari.adl.cnv.tps.ArgMetaInfo;
import de.calamanari.adl.cnv.tps.ConfigException;
import de.calamanari.adl.sql.config.DataColumn;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ArgColumnAssignment(ArgMetaInfo arg, DataColumn column) implements Serializable
{
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgColumnAssignment.class);

    public ArgColumnAssignment(ArgMetaInfo arg, DataColumn column) {
        if (arg == null || column == null) {
            throw new IllegalArgumentException(String.format("Arguments must not be null, given: arg=%s, column=%s", arg, column));
        }
        if (!column.columnType().isCompatibleWith(arg.type())) {
            throw new ConfigException(String.format("Incompatible types: cannot map this attribute to the given column, given: arg=%s, column=%s\nEither choose a different type or configure a custom QueryParameterCreator to bridge the gap.\nSee also AdlSqlType.withQueryParameterCreator(...)\n", arg, column), AudlangMessage.argMsg((AudlangUserMessage)CommonErrors.ERR_3000_MAPPING_FAILED, (String)arg.argName(), (Object[])new Object[0]));
        }
        if (arg.isAlwaysKnown() != column.isAlwaysKnown() || arg.isCollection() != column.isMultiRow()) {
            this.arg = new ArgMetaInfo(arg.argName(), arg.type(), column.isAlwaysKnown(), column.isMultiRow());
            LOGGER.trace("ArgMetaInfo auto-adjustment from column: {} -> {} (reason: {})", new Object[]{arg, this.arg, column});
        } else {
            this.arg = arg;
        }
        this.column = column;
    }
}

